/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.Iterator;
import java.util.List;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.world.entity.EnumItemSlot;

public final class EquipmentSlotGroup
extends Enum<EquipmentSlotGroup>
implements INamable,
Iterable<EnumItemSlot> {
    public static final /* enum */ EquipmentSlotGroup ANY = new EquipmentSlotGroup(0, "any", var0 -> true);
    public static final /* enum */ EquipmentSlotGroup MAINHAND = new EquipmentSlotGroup(1, "mainhand", EnumItemSlot.MAINHAND);
    public static final /* enum */ EquipmentSlotGroup OFFHAND = new EquipmentSlotGroup(2, "offhand", EnumItemSlot.OFFHAND);
    public static final /* enum */ EquipmentSlotGroup HAND = new EquipmentSlotGroup(3, "hand", var0 -> var0.getType() == EnumItemSlot.Function.HAND);
    public static final /* enum */ EquipmentSlotGroup FEET = new EquipmentSlotGroup(4, "feet", EnumItemSlot.FEET);
    public static final /* enum */ EquipmentSlotGroup LEGS = new EquipmentSlotGroup(5, "legs", EnumItemSlot.LEGS);
    public static final /* enum */ EquipmentSlotGroup CHEST = new EquipmentSlotGroup(6, "chest", EnumItemSlot.CHEST);
    public static final /* enum */ EquipmentSlotGroup HEAD = new EquipmentSlotGroup(7, "head", EnumItemSlot.HEAD);
    public static final /* enum */ EquipmentSlotGroup ARMOR = new EquipmentSlotGroup(8, "armor", EnumItemSlot::isArmor);
    public static final /* enum */ EquipmentSlotGroup BODY = new EquipmentSlotGroup(9, "body", EnumItemSlot.BODY);
    public static final /* enum */ EquipmentSlotGroup SADDLE = new EquipmentSlotGroup(10, "saddle", EnumItemSlot.SADDLE);
    public static final IntFunction<EquipmentSlotGroup> BY_ID;
    public static final Codec<EquipmentSlotGroup> CODEC;
    public static final StreamCodec<ByteBuf, EquipmentSlotGroup> STREAM_CODEC;
    private final int id;
    private final String key;
    private final Predicate<EnumItemSlot> predicate;
    private final List<EnumItemSlot> slots;
    private static final /* synthetic */ EquipmentSlotGroup[] s;

    public static EquipmentSlotGroup[] values() {
        return (EquipmentSlotGroup[])s.clone();
    }

    public static EquipmentSlotGroup valueOf(String var0) {
        return Enum.valueOf(EquipmentSlotGroup.class, var0);
    }

    private EquipmentSlotGroup(int var2, String var3, Predicate var4) {
        this.id = var2;
        this.key = var3;
        this.predicate = var4;
        this.slots = EnumItemSlot.VALUES.stream().filter(var4).toList();
    }

    private EquipmentSlotGroup(int var2, String var3, EnumItemSlot var4) {
        this(var2, var3, (T var1) -> var1 == var4);
    }

    public static EquipmentSlotGroup bySlot(EnumItemSlot var0) {
        return switch (var0) {
            default -> throw new MatchException(null, null);
            case EnumItemSlot.MAINHAND -> MAINHAND;
            case EnumItemSlot.OFFHAND -> OFFHAND;
            case EnumItemSlot.FEET -> FEET;
            case EnumItemSlot.LEGS -> LEGS;
            case EnumItemSlot.CHEST -> CHEST;
            case EnumItemSlot.HEAD -> HEAD;
            case EnumItemSlot.BODY -> BODY;
            case EnumItemSlot.SADDLE -> SADDLE;
        };
    }

    @Override
    public String getSerializedName() {
        return this.key;
    }

    public boolean test(EnumItemSlot var0) {
        return this.predicate.test(var0);
    }

    public List<EnumItemSlot> slots() {
        return this.slots;
    }

    @Override
    public Iterator<EnumItemSlot> iterator() {
        return this.slots.iterator();
    }

    private static /* synthetic */ EquipmentSlotGroup[] b() {
        return new EquipmentSlotGroup[]{ANY, MAINHAND, OFFHAND, HAND, FEET, LEGS, CHEST, HEAD, ARMOR, BODY, SADDLE};
    }

    static {
        s = EquipmentSlotGroup.b();
        BY_ID = ByIdMap.continuous(var0 -> var0.id, EquipmentSlotGroup.values(), ByIdMap.a.ZERO);
        CODEC = INamable.fromEnum(EquipmentSlotGroup::values);
        STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, var0 -> var0.id);
    }
}

