/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.Vec3D;
import org.jspecify.annotations.Nullable;

public interface ItemOwner {
    public World level();

    public Vec3D position();

    public float getVisualRotationYInDegrees();

    default public @Nullable EntityLiving asLivingEntity() {
        return null;
    }

    public static ItemOwner offsetFromOwner(ItemOwner var0, Vec3D var1) {
        return new a(var0, var1);
    }

    public record a(ItemOwner owner, Vec3D offset) implements ItemOwner
    {
        @Override
        public World level() {
            return this.owner.level();
        }

        @Override
        public Vec3D position() {
            return this.owner.position().add(this.offset);
        }

        @Override
        public float getVisualRotationYInDegrees() {
            return this.owner.getVisualRotationYInDegrees();
        }

        @Override
        public @Nullable EntityLiving asLivingEntity() {
            return this.owner.asLivingEntity();
        }
    }
}

