/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.item.ItemStack;

public interface SlotAccess {
    public ItemStack get();

    public boolean set(ItemStack var1);

    public static SlotAccess of(final Supplier<ItemStack> var0, final Consumer<ItemStack> var1) {
        return new SlotAccess(){

            @Override
            public ItemStack get() {
                return (ItemStack)var0.get();
            }

            @Override
            public boolean set(ItemStack var02) {
                var1.accept(var02);
                return true;
            }
        };
    }

    public static SlotAccess forEquipmentSlot(final EntityLiving var0, final EnumItemSlot var1, final Predicate<ItemStack> var2) {
        return new SlotAccess(){

            @Override
            public ItemStack get() {
                return var0.getItemBySlot(var1);
            }

            @Override
            public boolean set(ItemStack var02) {
                if (!var2.test(var02)) {
                    return false;
                }
                var0.setItemSlot(var1, var02);
                return true;
            }
        };
    }

    public static SlotAccess forEquipmentSlot(EntityLiving var02, EnumItemSlot var1) {
        return SlotAccess.forEquipmentSlot(var02, var1, var0 -> true);
    }

    public static SlotAccess forListElement(final List<ItemStack> var0, final int var1) {
        return new SlotAccess(){

            @Override
            public ItemStack get() {
                return (ItemStack)var0.get(var1);
            }

            @Override
            public boolean set(ItemStack var02) {
                var0.set(var1, var02);
                return true;
            }
        };
    }
}

