/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.kinds.Applicative;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.entity.npc.villager.EntityVillager;
import net.minecraft.world.entity.npc.villager.VillagerProfession;

public class BehaviorBetterJob {
    public static BehaviorControl<EntityVillager> create() {
        return BehaviorBuilder.create(var0 -> var0.group(var0.present(MemoryModuleType.JOB_SITE), var0.present(MemoryModuleType.NEAREST_LIVING_ENTITIES)).apply((Applicative)var0, (var1, var2) -> (var3, var42, var5) -> {
            GlobalPos var7 = (GlobalPos)var0.get(var1);
            var3.getPoiManager().getType(var7.pos()).ifPresent(var4 -> ((List)var0.get(var2)).stream().filter(var1 -> var1 instanceof EntityVillager && var1 != var42).map(var0 -> (EntityVillager)var0).filter(EntityLiving::isAlive).filter(var2 -> BehaviorBetterJob.competesForSameJobsite(var7, var4, var2)).reduce((EntityVillager)var42, BehaviorBetterJob::selectWinner));
            return true;
        }));
    }

    private static EntityVillager selectWinner(EntityVillager var0, EntityVillager var1) {
        EntityVillager var3;
        EntityVillager var2;
        if (var0.getVillagerXp() > var1.getVillagerXp()) {
            var2 = var0;
            var3 = var1;
        } else {
            var2 = var1;
            var3 = var0;
        }
        var3.getBrain().eraseMemory(MemoryModuleType.JOB_SITE);
        return var2;
    }

    private static boolean competesForSameJobsite(GlobalPos var0, Holder<VillagePlaceType> var1, EntityVillager var2) {
        Optional<GlobalPos> var3 = var2.getBrain().getMemory(MemoryModuleType.JOB_SITE);
        return var3.isPresent() && var0.equals(var3.get()) && BehaviorBetterJob.hasMatchingProfession(var1, var2.getVillagerData().profession());
    }

    private static boolean hasMatchingProfession(Holder<VillagePlaceType> var0, Holder<VillagerProfession> var1) {
        return var1.value().heldJobSite().test(var0);
    }
}

