/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorPositionEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.MemoryTarget;
import net.minecraft.world.entity.player.EntityHuman;

public class FollowTemptation
extends Behavior<EntityCreature> {
    public static final int TEMPTATION_COOLDOWN = 100;
    public static final double DEFAULT_CLOSE_ENOUGH_DIST = 2.5;
    public static final double BACKED_UP_CLOSE_ENOUGH_DIST = 3.5;
    private final Function<EntityLiving, Float> speedModifier;
    private final Function<EntityLiving, Double> closeEnoughDistance;
    private final boolean lookInTheEyes;

    public FollowTemptation(Function<EntityLiving, Float> var02) {
        this(var02, var0 -> 2.5);
    }

    public FollowTemptation(Function<EntityLiving, Float> var0, Function<EntityLiving, Double> var1) {
        this(var0, var1, false);
    }

    public FollowTemptation(Function<EntityLiving, Float> var0, Function<EntityLiving, Double> var1, boolean var2) {
        super((Map)SystemUtils.make(() -> {
            ImmutableMap.Builder var0 = ImmutableMap.builder();
            var0.put(MemoryModuleType.LOOK_TARGET, (Object)MemoryStatus.REGISTERED);
            var0.put(MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.REGISTERED);
            var0.put(MemoryModuleType.TEMPTATION_COOLDOWN_TICKS, (Object)MemoryStatus.VALUE_ABSENT);
            var0.put(MemoryModuleType.IS_TEMPTED, (Object)MemoryStatus.VALUE_ABSENT);
            var0.put(MemoryModuleType.TEMPTING_PLAYER, (Object)MemoryStatus.VALUE_PRESENT);
            var0.put(MemoryModuleType.BREED_TARGET, (Object)MemoryStatus.VALUE_ABSENT);
            var0.put(MemoryModuleType.IS_PANICKING, (Object)MemoryStatus.VALUE_ABSENT);
            return var0.build();
        }));
        this.speedModifier = var0;
        this.closeEnoughDistance = var1;
        this.lookInTheEyes = var2;
    }

    protected float getSpeedModifier(EntityCreature var0) {
        return this.speedModifier.apply(var0).floatValue();
    }

    private Optional<EntityHuman> getTemptingPlayer(EntityCreature var0) {
        return var0.getBrain().getMemory(MemoryModuleType.TEMPTING_PLAYER);
    }

    @Override
    protected boolean timedOut(long var0) {
        return false;
    }

    @Override
    protected boolean canStillUse(WorldServer var0, EntityCreature var1, long var2) {
        return this.getTemptingPlayer(var1).isPresent() && !var1.getBrain().hasMemoryValue(MemoryModuleType.BREED_TARGET) && !var1.getBrain().hasMemoryValue(MemoryModuleType.IS_PANICKING);
    }

    @Override
    protected void start(WorldServer var0, EntityCreature var1, long var2) {
        var1.getBrain().setMemory(MemoryModuleType.IS_TEMPTED, true);
    }

    @Override
    protected void stop(WorldServer var0, EntityCreature var1, long var2) {
        BehaviorController<?> var4 = var1.getBrain();
        var4.setMemory(MemoryModuleType.TEMPTATION_COOLDOWN_TICKS, 100);
        var4.eraseMemory(MemoryModuleType.IS_TEMPTED);
        var4.eraseMemory(MemoryModuleType.WALK_TARGET);
        var4.eraseMemory(MemoryModuleType.LOOK_TARGET);
    }

    @Override
    protected void tick(WorldServer var0, EntityCreature var1, long var2) {
        EntityHuman var4 = this.getTemptingPlayer(var1).get();
        BehaviorController<?> var5 = var1.getBrain();
        var5.setMemory(MemoryModuleType.LOOK_TARGET, new BehaviorPositionEntity(var4, true));
        double var6 = this.closeEnoughDistance.apply(var1);
        if (var1.distanceToSqr(var4) < MathHelper.square(var6)) {
            var5.eraseMemory(MemoryModuleType.WALK_TARGET);
        } else {
            var5.setMemory(MemoryModuleType.WALK_TARGET, new MemoryTarget(new BehaviorPositionEntity(var4, this.lookInTheEyes, this.lookInTheEyes), this.getSpeedModifier(var1), 2));
        }
    }

    @Override
    protected /* synthetic */ void stop(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        this.stop(worldServer, (EntityCreature)entityLiving, l2);
    }

    @Override
    protected /* synthetic */ void tick(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        this.tick(worldServer, (EntityCreature)entityLiving, l2);
    }

    @Override
    protected /* synthetic */ void start(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        this.start(worldServer, (EntityCreature)entityLiving, l2);
    }
}

