/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import java.util.Map;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorPositionEntity;
import net.minecraft.world.entity.ai.behavior.SpearAttack;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import org.jspecify.annotations.Nullable;

public class SpearApproach
extends Behavior<EntityCreature> {
    double speedModifierWhenRepositioning;
    float approachDistanceSq;

    public SpearApproach(double var0, float var2) {
        super(Map.of(MemoryModuleType.SPEAR_STATUS, MemoryStatus.VALUE_ABSENT));
        this.speedModifierWhenRepositioning = var0;
        this.approachDistanceSq = var2 * var2;
    }

    private boolean ableToAttack(EntityCreature var0) {
        return this.getTarget(var0) != null && var0.getMainHandItem().has(DataComponents.KINETIC_WEAPON);
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var0, EntityCreature var1) {
        return this.ableToAttack(var1) && !var1.isUsingItem();
    }

    @Override
    protected void start(WorldServer var0, EntityCreature var1, long var2) {
        var1.setAggressive(true);
        var1.getBrain().setMemory(MemoryModuleType.SPEAR_STATUS, SpearAttack.a.APPROACH);
        super.start(var0, var1, var2);
    }

    private @Nullable EntityLiving getTarget(EntityCreature var0) {
        return var0.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).orElse(null);
    }

    @Override
    protected boolean canStillUse(WorldServer var0, EntityCreature var1, long var2) {
        return this.ableToAttack(var1) && this.farEnough(var1);
    }

    private boolean farEnough(EntityCreature var0) {
        EntityLiving var1 = this.getTarget(var0);
        double var2 = var0.distanceToSqr(var1.getX(), var1.getY(), var1.getZ());
        return var2 > (double)this.approachDistanceSq;
    }

    @Override
    protected void tick(WorldServer var0, EntityCreature var1, long var2) {
        EntityLiving var4 = this.getTarget(var1);
        Entity var5 = var1.getRootVehicle();
        float var6 = 1.0f;
        if (var5 instanceof EntityInsentient) {
            EntityInsentient var7 = (EntityInsentient)var5;
            var6 = var7.chargeSpeedModifier();
        }
        var1.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, new BehaviorPositionEntity(var4, true));
        var1.getNavigation().moveTo(var4, (double)var6 * this.speedModifierWhenRepositioning);
    }

    @Override
    protected void stop(WorldServer var0, EntityCreature var1, long var2) {
        var1.getNavigation().stop();
        var1.getBrain().setMemory(MemoryModuleType.SPEAR_STATUS, SpearAttack.a.CHARGING);
    }

    @Override
    protected boolean timedOut(long var0) {
        return false;
    }

    @Override
    protected /* synthetic */ boolean canStillUse(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        return this.canStillUse(worldServer, (EntityCreature)entityLiving, l2);
    }

    @Override
    protected /* synthetic */ void stop(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        this.stop(worldServer, (EntityCreature)entityLiving, l2);
    }

    @Override
    protected /* synthetic */ void start(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        this.start(worldServer, (EntityCreature)entityLiving, l2);
    }
}

