/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior.declarative;

import com.mojang.datafixers.kinds.Const;
import com.mojang.datafixers.kinds.IdF;
import com.mojang.datafixers.kinds.K1;
import com.mojang.datafixers.kinds.OptionalBox;
import com.mojang.datafixers.util.Unit;
import java.util.Optional;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.behavior.declarative.MemoryAccessor;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import org.jspecify.annotations.Nullable;

public interface MemoryCondition<F extends K1, Value> {
    public MemoryModuleType<Value> memory();

    public MemoryStatus condition();

    public @Nullable MemoryAccessor<F, Value> createAccessor(BehaviorController<?> var1, Optional<Value> var2);

    public record a<Value>(MemoryModuleType<Value> memory) implements MemoryCondition<Const.Mu<Unit>, Value>
    {
        @Override
        public MemoryStatus condition() {
            return MemoryStatus.VALUE_ABSENT;
        }

        @Override
        public MemoryAccessor<Const.Mu<Unit>, Value> createAccessor(BehaviorController<?> var0, Optional<Value> var1) {
            if (var1.isPresent()) {
                return null;
            }
            return new MemoryAccessor(var0, this.memory, Const.create((Object)Unit.INSTANCE));
        }
    }

    public record b<Value>(MemoryModuleType<Value> memory) implements MemoryCondition<IdF.Mu, Value>
    {
        @Override
        public MemoryStatus condition() {
            return MemoryStatus.VALUE_PRESENT;
        }

        @Override
        public MemoryAccessor<IdF.Mu, Value> createAccessor(BehaviorController<?> var0, Optional<Value> var1) {
            if (var1.isEmpty()) {
                return null;
            }
            return new MemoryAccessor(var0, this.memory, IdF.create(var1.get()));
        }
    }

    public record c<Value>(MemoryModuleType<Value> memory) implements MemoryCondition<OptionalBox.Mu, Value>
    {
        @Override
        public MemoryStatus condition() {
            return MemoryStatus.REGISTERED;
        }

        @Override
        public MemoryAccessor<OptionalBox.Mu, Value> createAccessor(BehaviorController<?> var0, Optional<Value> var1) {
            return new MemoryAccessor(var0, this.memory, OptionalBox.create(var1));
        }
    }
}

