/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import java.util.EnumSet;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.World;

public abstract class PathfinderGoal {
    private final EnumSet<Type> flags = EnumSet.noneOf(Type.class);

    public abstract boolean canUse();

    public boolean canContinueToUse() {
        return this.canUse();
    }

    public boolean isInterruptable() {
        return true;
    }

    public void start() {
    }

    public void stop() {
    }

    public boolean requiresUpdateEveryTick() {
        return false;
    }

    public void tick() {
    }

    public void setFlags(EnumSet<Type> var0) {
        this.flags.clear();
        this.flags.addAll(var0);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public EnumSet<Type> getFlags() {
        return this.flags;
    }

    protected int adjustedTickDelay(int var0) {
        return this.requiresUpdateEveryTick() ? var0 : PathfinderGoal.reducedTickDelay(var0);
    }

    protected static int reducedTickDelay(int var0) {
        return MathHelper.positiveCeilDiv(var0, 2);
    }

    protected static WorldServer getServerLevel(Entity var0) {
        return (WorldServer)var0.level();
    }

    protected static WorldServer getServerLevel(World var0) {
        return (WorldServer)var0;
    }

    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type MOVE = new Type();
        public static final /* enum */ Type LOOK = new Type();
        public static final /* enum */ Type JUMP = new Type();
        public static final /* enum */ Type TARGET = new Type();
        private static final /* synthetic */ Type[] e;

        public static Type[] values() {
            return (Type[])e.clone();
        }

        public static Type valueOf(String var0) {
            return Enum.valueOf(Type.class, var0);
        }

        private static /* synthetic */ Type[] a() {
            return new Type[]{MOVE, LOOK, JUMP, TARGET};
        }

        static {
            e = Type.a();
        }
    }
}

