/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.entity.raid.PersistentRaid;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.phys.Vec3D;

public class PathfinderGoalRaid<T extends EntityRaider>
extends PathfinderGoal {
    private static final int RECRUITMENT_SEARCH_TICK_DELAY = 20;
    private static final float SPEED_MODIFIER = 1.0f;
    private final T mob;
    private int recruitmentTick;

    public PathfinderGoalRaid(T var0) {
        this.mob = var0;
        this.setFlags(EnumSet.of(PathfinderGoal.Type.MOVE));
    }

    @Override
    public boolean canUse() {
        return ((EntityInsentient)this.mob).getTarget() == null && !((Entity)this.mob).hasControllingPassenger() && ((EntityRaider)this.mob).hasActiveRaid() && !((EntityRaider)this.mob).getCurrentRaid().isOver() && !PathfinderGoalRaid.getServerLevel(((Entity)this.mob).level()).isVillage(((Entity)this.mob).blockPosition());
    }

    @Override
    public boolean canContinueToUse() {
        return ((EntityRaider)this.mob).hasActiveRaid() && !((EntityRaider)this.mob).getCurrentRaid().isOver() && !PathfinderGoalRaid.getServerLevel(((Entity)this.mob).level()).isVillage(((Entity)this.mob).blockPosition());
    }

    @Override
    public void tick() {
        if (((EntityRaider)this.mob).hasActiveRaid()) {
            Vec3D var1;
            Raid var0 = ((EntityRaider)this.mob).getCurrentRaid();
            if (((EntityRaider)this.mob).tickCount > this.recruitmentTick) {
                this.recruitmentTick = ((EntityRaider)this.mob).tickCount + 20;
                this.recruitNearby(var0);
            }
            if (!((EntityCreature)this.mob).isPathFinding() && (var1 = DefaultRandomPos.getPosTowards(this.mob, 15, 4, Vec3D.atBottomCenterOf(var0.getCenter()), 1.5707963705062866)) != null) {
                ((EntityInsentient)this.mob).getNavigation().moveTo(var1.x, var1.y, var1.z, 1.0);
            }
        }
    }

    private void recruitNearby(Raid var02) {
        if (var02.isActive()) {
            WorldServer var1 = PathfinderGoalRaid.getServerLevel(((Entity)this.mob).level());
            HashSet var2 = Sets.newHashSet();
            List<EntityRaider> var3 = var1.getEntitiesOfClass(EntityRaider.class, ((Entity)this.mob).getBoundingBox().inflate(16.0), var0 -> !var0.hasActiveRaid() && PersistentRaid.canJoinRaid(var0));
            var2.addAll(var3);
            for (EntityRaider var5 : var2) {
                var02.joinRaid(var1, var02.getGroupsSpawned(), var5, null, true);
            }
        }
    }
}

