/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import java.util.EnumSet;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;

public class PathfinderGoalSit
extends PathfinderGoal {
    private final EntityTameableAnimal mob;

    public PathfinderGoalSit(EntityTameableAnimal var0) {
        this.mob = var0;
        this.setFlags(EnumSet.of(PathfinderGoal.Type.JUMP, PathfinderGoal.Type.MOVE));
    }

    @Override
    public boolean canContinueToUse() {
        return this.mob.isOrderedToSit();
    }

    @Override
    public boolean canUse() {
        boolean var0 = this.mob.isOrderedToSit();
        if (!var0 && !this.mob.isTame()) {
            return false;
        }
        if (this.mob.isInWater()) {
            return false;
        }
        if (!this.mob.onGround()) {
            return false;
        }
        EntityLiving var1 = this.mob.getOwner();
        if (var1 == null || var1.level() != this.mob.level()) {
            return true;
        }
        if (this.mob.distanceToSqr(var1) < 144.0 && var1.getLastHurtByMob() != null) {
            return false;
        }
        return var0;
    }

    @Override
    public void start() {
        this.mob.getNavigation().stop();
        this.mob.setInSittingPose(true);
    }

    @Override
    public void stop() {
        this.mob.setInSittingPose(false);
    }
}

