/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.ai.behavior.BehaviorUtil;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.phys.Vec3D;
import org.jspecify.annotations.Nullable;

public class PathfinderGoalStrollVillage
extends PathfinderGoalRandomStroll {
    private static final int MAX_XZ_DIST = 10;
    private static final int MAX_Y_DIST = 7;

    public PathfinderGoalStrollVillage(EntityCreature var0, double var1, boolean var3) {
        super(var0, var1, 10, var3);
    }

    @Override
    public boolean canUse() {
        BlockPosition var1;
        WorldServer var0 = (WorldServer)this.mob.level();
        if (var0.isVillage(var1 = this.mob.blockPosition())) {
            return false;
        }
        return super.canUse();
    }

    @Override
    protected @Nullable Vec3D getPosition() {
        BlockPosition var1;
        SectionPosition var2;
        WorldServer var0 = (WorldServer)this.mob.level();
        SectionPosition var3 = BehaviorUtil.findSectionClosestToVillage(var0, var2 = SectionPosition.of(var1 = this.mob.blockPosition()), 2);
        if (var3 != var2) {
            return DefaultRandomPos.getPosTowards(this.mob, 10, 7, Vec3D.atBottomCenterOf(var3.center()), 1.5707963705062866);
        }
        return null;
    }
}

