/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import java.util.function.Predicate;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.world.EnumHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.item.ItemStack;
import org.jspecify.annotations.Nullable;

public class PathfinderGoalUseItem<T extends EntityInsentient>
extends PathfinderGoal {
    private final T mob;
    private final ItemStack item;
    private final Predicate<? super T> canUseSelector;
    private final @Nullable SoundEffect finishUsingSound;

    public PathfinderGoalUseItem(T var0, ItemStack var1, @Nullable SoundEffect var2, Predicate<? super T> var3) {
        this.mob = var0;
        this.item = var1;
        this.finishUsingSound = var2;
        this.canUseSelector = var3;
    }

    @Override
    public boolean canUse() {
        return this.canUseSelector.test(this.mob);
    }

    @Override
    public boolean canContinueToUse() {
        return ((EntityLiving)this.mob).isUsingItem();
    }

    @Override
    public void start() {
        ((EntityLiving)this.mob).setItemSlot(EnumItemSlot.MAINHAND, this.item.copy());
        ((EntityLiving)this.mob).startUsingItem(EnumHand.MAIN_HAND);
    }

    @Override
    public void stop() {
        ((EntityLiving)this.mob).setItemSlot(EnumItemSlot.MAINHAND, ItemStack.EMPTY);
        if (this.finishUsingSound != null) {
            ((Entity)this.mob).playSound(this.finishUsingSound, 1.0f, ((Entity)this.mob).getRandom().nextFloat() * 0.2f + 0.9f);
        }
    }
}

