/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import net.minecraft.sounds.SoundEffect;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.animal.equine.EntityHorseAbstract;

public class RandomStandGoal
extends PathfinderGoal {
    private final EntityHorseAbstract horse;
    private int nextStand;

    public RandomStandGoal(EntityHorseAbstract var0) {
        this.horse = var0;
        this.resetStandInterval(var0);
    }

    @Override
    public void start() {
        this.horse.standIfPossible();
        this.playStandSound();
    }

    private void playStandSound() {
        SoundEffect var0 = this.horse.getAmbientStandSound();
        if (var0 != null) {
            this.horse.playSound(var0);
        }
    }

    @Override
    public boolean canContinueToUse() {
        return false;
    }

    @Override
    public boolean canUse() {
        ++this.nextStand;
        if (this.nextStand > 0 && this.horse.getRandom().nextInt(1000) < this.nextStand) {
            this.resetStandInterval(this.horse);
            return !this.horse.isImmobile() && this.horse.getRandom().nextInt(10) == 0;
        }
        return false;
    }

    private void resetStandInterval(EntityHorseAbstract var0) {
        this.nextStand = -var0.getAmbientStandInterval();
    }

    @Override
    public boolean requiresUpdateEveryTick() {
        return true;
    }
}

