/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.EnumHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.item.component.KineticWeapon;
import net.minecraft.world.phys.Vec3D;
import org.jspecify.annotations.Nullable;

public class SpearUseGoal<T extends EntityMonster>
extends PathfinderGoal {
    static final int MIN_REPOSITION_DISTANCE = 6;
    static final int MAX_REPOSITION_DISTANCE = 7;
    static final int MIN_COOLDOWN_DISTANCE = 9;
    static final int MAX_COOLDOWN_DISTANCE = 11;
    static final double MAX_FLEEING_TIME = SpearUseGoal.reducedTickDelay(100);
    private final T mob;
    private @Nullable a state;
    double speedModifierWhenCharging;
    double speedModifierWhenRepositioning;
    float approachDistanceSq;
    float targetInRangeRadiusSq;

    public SpearUseGoal(T var0, double var1, double var3, float var5, float var6) {
        this.mob = var0;
        this.speedModifierWhenCharging = var1;
        this.speedModifierWhenRepositioning = var3;
        this.approachDistanceSq = var5 * var5;
        this.targetInRangeRadiusSq = var6 * var6;
        this.setFlags(EnumSet.of(PathfinderGoal.Type.MOVE, PathfinderGoal.Type.LOOK));
    }

    @Override
    public boolean canUse() {
        return this.ableToAttack() && !((EntityLiving)this.mob).isUsingItem();
    }

    private boolean ableToAttack() {
        return ((EntityInsentient)this.mob).getTarget() != null && ((EntityLiving)this.mob).getMainHandItem().has(DataComponents.KINETIC_WEAPON);
    }

    private int getKineticWeaponUseDuration() {
        int var0 = Optional.ofNullable(((EntityLiving)this.mob).getMainHandItem().get(DataComponents.KINETIC_WEAPON)).map(KineticWeapon::computeDamageUseDuration).orElse(0);
        return SpearUseGoal.reducedTickDelay(var0);
    }

    @Override
    public boolean canContinueToUse() {
        return this.state != null && !this.state.done && this.ableToAttack();
    }

    @Override
    public void start() {
        super.start();
        ((EntityInsentient)this.mob).setAggressive(true);
        this.state = new a();
    }

    @Override
    public void stop() {
        super.stop();
        ((EntityInsentient)this.mob).getNavigation().stop();
        ((EntityInsentient)this.mob).setAggressive(false);
        this.state = null;
        ((EntityLiving)this.mob).stopUsingItem();
    }

    @Override
    public void tick() {
        double var6;
        if (this.state == null) {
            return;
        }
        EntityLiving var0 = ((EntityInsentient)this.mob).getTarget();
        double var1 = ((Entity)this.mob).distanceToSqr(var0.getX(), var0.getY(), var0.getZ());
        Entity var3 = ((Entity)this.mob).getRootVehicle();
        float var4 = 1.0f;
        if (var3 instanceof EntityInsentient) {
            EntityInsentient var5 = (EntityInsentient)var3;
            var4 = var5.chargeSpeedModifier();
        }
        int var5 = ((Entity)this.mob).isPassenger() ? 2 : 0;
        ((EntityInsentient)this.mob).lookAt(var0, 30.0f, 30.0f);
        ((EntityInsentient)this.mob).getLookControl().setLookAt(var0, 30.0f, 30.0f);
        if (this.state.notEngagedYet()) {
            if (var1 > (double)this.approachDistanceSq) {
                ((EntityInsentient)this.mob).getNavigation().moveTo(var0, (double)var4 * this.speedModifierWhenRepositioning);
                return;
            }
            this.state.startEngagement(this.getKineticWeaponUseDuration());
            ((EntityLiving)this.mob).startUsingItem(EnumHand.MAIN_HAND);
        }
        if (this.state.tickAndCheckEngagement()) {
            ((EntityLiving)this.mob).stopUsingItem();
            var6 = Math.sqrt(var1);
            this.state.awayPos = LandRandomPos.getPosAway(this.mob, Math.max(0.0, (double)(9 + var5) - var6), Math.max(1.0, (double)(11 + var5) - var6), 7, var0.position());
            this.state.fleeingTime = 1;
        }
        if (this.state.tickAndCheckFleeing()) {
            return;
        }
        if (this.state.awayPos != null) {
            ((EntityInsentient)this.mob).getNavigation().moveTo(this.state.awayPos.x, this.state.awayPos.y, this.state.awayPos.z, (double)var4 * this.speedModifierWhenRepositioning);
            if (((EntityInsentient)this.mob).getNavigation().isDone()) {
                if (this.state.fleeingTime > 0) {
                    this.state.done = true;
                    return;
                }
                this.state.awayPos = null;
            }
        } else {
            ((EntityInsentient)this.mob).getNavigation().moveTo(var0, (double)var4 * this.speedModifierWhenCharging);
            if (var1 < (double)this.targetInRangeRadiusSq || ((EntityInsentient)this.mob).getNavigation().isDone()) {
                var6 = Math.sqrt(var1);
                this.state.awayPos = LandRandomPos.getPosAway(this.mob, (double)(6 + var5) - var6, (double)(7 + var5) - var6, 7, var0.position());
            }
        }
    }

    public static class a {
        private int engageTime = -1;
        int fleeingTime = -1;
        @Nullable Vec3D awayPos;
        boolean done = false;

        public boolean notEngagedYet() {
            return this.engageTime < 0;
        }

        public void startEngagement(int var0) {
            this.engageTime = var0;
        }

        public boolean tickAndCheckEngagement() {
            if (this.engageTime > 0) {
                --this.engageTime;
                if (this.engageTime == 0) {
                    return true;
                }
            }
            return false;
        }

        public boolean tickAndCheckFleeing() {
            if (this.fleeingTime > 0) {
                ++this.fleeingTime;
                if ((double)this.fleeingTime > MAX_FLEEING_TIME) {
                    this.done = true;
                    return true;
                }
            }
            return false;
        }
    }
}

