/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.memory;

import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.sensing.Sensor;

public class NearestVisibleLivingEntities {
    private static final NearestVisibleLivingEntities EMPTY = new NearestVisibleLivingEntities();
    private final List<EntityLiving> nearbyEntities;
    private final Predicate<EntityLiving> lineOfSightTest;

    private NearestVisibleLivingEntities() {
        this.nearbyEntities = List.of();
        this.lineOfSightTest = var0 -> false;
    }

    public NearestVisibleLivingEntities(WorldServer var0, EntityLiving var1, List<EntityLiving> var22) {
        this.nearbyEntities = var22;
        Object2BooleanOpenHashMap var3 = new Object2BooleanOpenHashMap(var22.size());
        Predicate<EntityLiving> var4 = var2 -> Sensor.isEntityTargetable(var0, var1, var2);
        this.lineOfSightTest = var2 -> var3.computeIfAbsent(var2, var4);
    }

    public static NearestVisibleLivingEntities empty() {
        return EMPTY;
    }

    public Optional<EntityLiving> findClosest(Predicate<EntityLiving> var0) {
        for (EntityLiving var2 : this.nearbyEntities) {
            if (!var0.test(var2) || !this.lineOfSightTest.test(var2)) continue;
            return Optional.of(var2);
        }
        return Optional.empty();
    }

    public Iterable<EntityLiving> findAll(Predicate<EntityLiving> var0) {
        return Iterables.filter(this.nearbyEntities, var1 -> var0.test((EntityLiving)var1) && this.lineOfSightTest.test((EntityLiving)var1));
    }

    public Stream<EntityLiving> find(Predicate<EntityLiving> var0) {
        return this.nearbyEntities.stream().filter(var1 -> var0.test((EntityLiving)var1) && this.lineOfSightTest.test((EntityLiving)var1));
    }

    public boolean contains(EntityLiving var0) {
        return this.nearbyEntities.contains(var0) && this.lineOfSightTest.test(var0);
    }

    public boolean contains(Predicate<EntityLiving> var0) {
        for (EntityLiving var2 : this.nearbyEntities) {
            if (!var0.test(var2) || !this.lineOfSightTest.test(var2)) continue;
            return true;
        }
        return false;
    }
}

