/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ambient;

import net.minecraft.core.BlockPosition;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.ambient.EntityAmbient;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import org.jspecify.annotations.Nullable;

public class EntityBat
extends EntityAmbient {
    public static final float FLAP_LENGTH_SECONDS = 0.5f;
    public static final float TICKS_PER_FLAP = 10.0f;
    private static final DataWatcherObject<Byte> DATA_ID_FLAGS = DataWatcher.defineId(EntityBat.class, DataWatcherRegistry.BYTE);
    private static final int FLAG_RESTING = 1;
    private static final PathfinderTargetCondition BAT_RESTING_TARGETING = PathfinderTargetCondition.forNonCombat().range(4.0);
    private static final byte DEFAULT_FLAGS = 0;
    public final AnimationState flyAnimationState = new AnimationState();
    public final AnimationState restAnimationState = new AnimationState();
    private @Nullable BlockPosition targetPosition;

    public EntityBat(EntityTypes<? extends EntityBat> var0, World var1) {
        super((EntityTypes<? extends EntityAmbient>)var0, var1);
        if (!var1.isClientSide()) {
            this.setResting(true);
        }
    }

    @Override
    public boolean isFlapping() {
        return !this.isResting() && (float)this.tickCount % 10.0f == 0.0f;
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        super.defineSynchedData(var0);
        var0.define(DATA_ID_FLAGS, (byte)0);
    }

    @Override
    protected float getSoundVolume() {
        return 0.1f;
    }

    @Override
    public float getVoicePitch() {
        return super.getVoicePitch() * 0.95f;
    }

    @Override
    public @Nullable SoundEffect getAmbientSound() {
        if (this.isResting() && this.random.nextInt(4) != 0) {
            return null;
        }
        return SoundEffects.BAT_AMBIENT;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.BAT_HURT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.BAT_DEATH;
    }

    @Override
    public boolean isPushable() {
        return false;
    }

    @Override
    protected void doPush(Entity var0) {
    }

    @Override
    protected void pushEntities() {
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityInsentient.createMobAttributes().add(GenericAttributes.MAX_HEALTH, 6.0);
    }

    public boolean isResting() {
        return (this.entityData.get(DATA_ID_FLAGS) & 1) != 0;
    }

    public void setResting(boolean var0) {
        byte var1 = this.entityData.get(DATA_ID_FLAGS);
        if (var0) {
            this.entityData.set(DATA_ID_FLAGS, (byte)(var1 | 1));
        } else {
            this.entityData.set(DATA_ID_FLAGS, (byte)(var1 & 0xFFFFFFFE));
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.isResting()) {
            this.setDeltaMovement(Vec3D.ZERO);
            this.setPosRaw(this.getX(), (double)MathHelper.floor(this.getY()) + 1.0 - (double)this.getBbHeight(), this.getZ());
        } else {
            this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, 0.6, 1.0));
        }
        this.setupAnimationStates();
    }

    @Override
    protected void customServerAiStep(WorldServer var0) {
        super.customServerAiStep(var0);
        BlockPosition var1 = this.blockPosition();
        BlockPosition var2 = var1.above();
        if (this.isResting()) {
            boolean var3 = this.isSilent();
            if (var0.getBlockState(var2).isRedstoneConductor(var0, var1)) {
                if (this.random.nextInt(200) == 0) {
                    this.yHeadRot = this.random.nextInt(360);
                }
                if (var0.getNearestPlayer(BAT_RESTING_TARGETING, this) != null) {
                    this.setResting(false);
                    if (!var3) {
                        var0.levelEvent(null, 1025, var1, 0);
                    }
                }
            } else {
                this.setResting(false);
                if (!var3) {
                    var0.levelEvent(null, 1025, var1, 0);
                }
            }
        } else {
            if (!(this.targetPosition == null || var0.isEmptyBlock(this.targetPosition) && this.targetPosition.getY() > var0.getMinY())) {
                this.targetPosition = null;
            }
            if (this.targetPosition == null || this.random.nextInt(30) == 0 || this.targetPosition.closerToCenterThan(this.position(), 2.0)) {
                this.targetPosition = BlockPosition.containing(this.getX() + (double)this.random.nextInt(7) - (double)this.random.nextInt(7), this.getY() + (double)this.random.nextInt(6) - 2.0, this.getZ() + (double)this.random.nextInt(7) - (double)this.random.nextInt(7));
            }
            double var3 = (double)this.targetPosition.getX() + 0.5 - this.getX();
            double var5 = (double)this.targetPosition.getY() + 0.1 - this.getY();
            double var7 = (double)this.targetPosition.getZ() + 0.5 - this.getZ();
            Vec3D var9 = this.getDeltaMovement();
            Vec3D var10 = var9.add((Math.signum(var3) * 0.5 - var9.x) * (double)0.1f, (Math.signum(var5) * (double)0.7f - var9.y) * (double)0.1f, (Math.signum(var7) * 0.5 - var9.z) * (double)0.1f);
            this.setDeltaMovement(var10);
            float var11 = (float)(MathHelper.atan2(var10.z, var10.x) * 57.2957763671875) - 90.0f;
            float var12 = MathHelper.wrapDegrees(var11 - this.getYRot());
            this.zza = 0.5f;
            this.setYRot(this.getYRot() + var12);
            if (this.random.nextInt(100) == 0 && var0.getBlockState(var2).isRedstoneConductor(var0, var2)) {
                this.setResting(true);
            }
        }
    }

    @Override
    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.EVENTS;
    }

    @Override
    protected void checkFallDamage(double var0, boolean var2, IBlockData var3, BlockPosition var4) {
    }

    @Override
    public boolean isIgnoringBlockTriggers() {
        return true;
    }

    @Override
    public boolean hurtServer(WorldServer var0, DamageSource var1, float var2) {
        if (this.isInvulnerableTo(var0, var1)) {
            return false;
        }
        if (this.isResting()) {
            this.setResting(false);
        }
        return super.hurtServer(var0, var1, var2);
    }

    @Override
    protected void readAdditionalSaveData(ValueInput var0) {
        super.readAdditionalSaveData(var0);
        this.entityData.set(DATA_ID_FLAGS, var0.getByteOr("BatFlags", (byte)0));
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput var0) {
        super.addAdditionalSaveData(var0);
        var0.putByte("BatFlags", this.entityData.get(DATA_ID_FLAGS));
    }

    public static boolean checkBatSpawnRules(EntityTypes<EntityBat> var0, GeneratorAccess var1, EntitySpawnReason var2, BlockPosition var3, RandomSource var4) {
        if (var3.getY() >= var1.getHeightmapPos(HeightMap.Type.WORLD_SURFACE, var3).getY()) {
            return false;
        }
        if (var4.nextBoolean()) {
            return false;
        }
        if (var1.getMaxLocalRawBrightness(var3) > var4.nextInt(4)) {
            return false;
        }
        if (!var1.getBlockState(var3.below()).is(TagsBlock.BATS_SPAWNABLE_ON)) {
            return false;
        }
        return EntityBat.checkMobSpawnRules(var0, var1, var2, var3, var4);
    }

    private void setupAnimationStates() {
        if (this.isResting()) {
            this.flyAnimationState.stop();
            this.restAnimationState.startIfStopped(this.tickCount);
        } else {
            this.restAnimationState.stop();
            this.flyAnimationState.startIfStopped(this.tickCount);
        }
    }
}

