/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.camel;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.camel.Camel;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import org.jspecify.annotations.Nullable;

public class CamelHusk
extends Camel {
    public CamelHusk(EntityTypes<? extends Camel> var0, World var1) {
        super(var0, var1);
    }

    @Override
    public boolean removeWhenFarAway(double var0) {
        return true;
    }

    @Override
    public boolean isMobControlled() {
        return this.getFirstPassenger() instanceof EntityInsentient;
    }

    @Override
    public EnumInteractionResult interact(EntityHuman var0, EnumHand var1) {
        this.setPersistenceRequired();
        return super.interact(var0, var1);
    }

    @Override
    public boolean canBeLeashed() {
        return !this.isMobControlled();
    }

    @Override
    public boolean isFood(ItemStack var0) {
        return var0.is(TagsItem.CAMEL_HUSK_FOOD);
    }

    @Override
    protected SoundEffect getAmbientSound() {
        return SoundEffects.CAMEL_HUSK_AMBIENT;
    }

    @Override
    public boolean canMate(EntityAnimal var0) {
        return false;
    }

    @Override
    public @Nullable Camel getBreedOffspring(WorldServer var0, EntityAgeable var1) {
        return null;
    }

    @Override
    public boolean canFallInLove() {
        return false;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.CAMEL_HUSK_DEATH;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.CAMEL_HUSK_HURT;
    }

    @Override
    protected void playStepSound(BlockPosition var0, IBlockData var1) {
        if (var1.is(TagsBlock.CAMEL_SAND_STEP_SOUND_BLOCKS)) {
            this.playSound(SoundEffects.CAMEL_HUSK_STEP_SAND, 0.4f, 1.0f);
        } else {
            this.playSound(SoundEffects.CAMEL_HUSK_STEP, 0.4f, 1.0f);
        }
    }

    @Override
    protected SoundEffect getDashingSound() {
        return SoundEffects.CAMEL_HUSK_DASH;
    }

    @Override
    protected SoundEffect getDashReadySound() {
        return SoundEffects.CAMEL_HUSK_DASH_READY;
    }

    @Override
    protected SoundEffect getEatingSound() {
        return SoundEffects.CAMEL_HUSK_EAT;
    }

    @Override
    protected SoundEffect getStandUpSound() {
        return SoundEffects.CAMEL_HUSK_STAND;
    }

    @Override
    protected SoundEffect getSitDownSound() {
        return SoundEffects.CAMEL_HUSK_SIT;
    }

    @Override
    protected Holder.c<SoundEffect> getSaddleSound() {
        return SoundEffects.CAMEL_HUSK_SADDLE;
    }

    @Override
    public float chargeSpeedModifier() {
        return 4.0f;
    }

    @Override
    public /* synthetic */ @Nullable EntityAgeable getBreedOffspring(WorldServer worldServer, EntityAgeable entityAgeable) {
        return this.getBreedOffspring(worldServer, entityAgeable);
    }
}

