/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.cow;

import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.animal.TemperatureVariants;
import net.minecraft.world.entity.animal.cow.CowVariant;
import net.minecraft.world.entity.variant.BiomeCheck;
import net.minecraft.world.entity.variant.ModelAndTexture;
import net.minecraft.world.entity.variant.SpawnPrioritySelectors;
import net.minecraft.world.level.biome.BiomeBase;

public class CowVariants {
    public static final ResourceKey<CowVariant> TEMPERATE = CowVariants.createKey(TemperatureVariants.TEMPERATE);
    public static final ResourceKey<CowVariant> WARM = CowVariants.createKey(TemperatureVariants.WARM);
    public static final ResourceKey<CowVariant> COLD = CowVariants.createKey(TemperatureVariants.COLD);
    public static final ResourceKey<CowVariant> DEFAULT = TEMPERATE;

    private static ResourceKey<CowVariant> createKey(MinecraftKey var0) {
        return ResourceKey.create(Registries.COW_VARIANT, var0);
    }

    public static void bootstrap(BootstrapContext<CowVariant> var0) {
        CowVariants.register(var0, TEMPERATE, CowVariant.a.NORMAL, "temperate_cow", SpawnPrioritySelectors.fallback(0));
        CowVariants.register(var0, WARM, CowVariant.a.WARM, "warm_cow", BiomeTags.SPAWNS_WARM_VARIANT_FARM_ANIMALS);
        CowVariants.register(var0, COLD, CowVariant.a.COLD, "cold_cow", BiomeTags.SPAWNS_COLD_VARIANT_FARM_ANIMALS);
    }

    private static void register(BootstrapContext<CowVariant> var0, ResourceKey<CowVariant> var1, CowVariant.a var2, String var3, TagKey<BiomeBase> var4) {
        HolderSet.Named<BiomeBase> var5 = var0.lookup(Registries.BIOME).getOrThrow(var4);
        CowVariants.register(var0, var1, var2, var3, SpawnPrioritySelectors.single(new BiomeCheck(var5), 1));
    }

    private static void register(BootstrapContext<CowVariant> var0, ResourceKey<CowVariant> var1, CowVariant.a var2, String var3, SpawnPrioritySelectors var4) {
        MinecraftKey var5 = MinecraftKey.withDefaultNamespace("entity/cow/" + var3);
        var0.register(var1, new CowVariant(new ModelAndTexture<CowVariant.a>(var2, var5), var4));
    }
}

