/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.fish;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import net.minecraft.EnumChatFormat;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.animal.fish.EntityFishSchool;
import net.minecraft.world.entity.animal.fish.EntityWaterAnimal;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jspecify.annotations.Nullable;

public class EntityTropicalFish
extends EntityFishSchool {
    public static final d DEFAULT_VARIANT = new d(Variant.KOB, EnumColor.WHITE, EnumColor.WHITE);
    private static final DataWatcherObject<Integer> DATA_ID_TYPE_VARIANT = DataWatcher.defineId(EntityTropicalFish.class, DataWatcherRegistry.INT);
    public static final List<d> COMMON_VARIANTS = List.of(new d(Variant.STRIPEY, EnumColor.ORANGE, EnumColor.GRAY), new d(Variant.FLOPPER, EnumColor.GRAY, EnumColor.GRAY), new d(Variant.FLOPPER, EnumColor.GRAY, EnumColor.BLUE), new d(Variant.CLAYFISH, EnumColor.WHITE, EnumColor.GRAY), new d(Variant.SUNSTREAK, EnumColor.BLUE, EnumColor.GRAY), new d(Variant.KOB, EnumColor.ORANGE, EnumColor.WHITE), new d(Variant.SPOTTY, EnumColor.PINK, EnumColor.LIGHT_BLUE), new d(Variant.BLOCKFISH, EnumColor.PURPLE, EnumColor.YELLOW), new d(Variant.CLAYFISH, EnumColor.WHITE, EnumColor.RED), new d(Variant.SPOTTY, EnumColor.WHITE, EnumColor.YELLOW), new d(Variant.GLITTER, EnumColor.WHITE, EnumColor.GRAY), new d(Variant.CLAYFISH, EnumColor.WHITE, EnumColor.ORANGE), new d(Variant.DASHER, EnumColor.CYAN, EnumColor.PINK), new d(Variant.BRINELY, EnumColor.LIME, EnumColor.LIGHT_BLUE), new d(Variant.BETTY, EnumColor.RED, EnumColor.WHITE), new d(Variant.SNOOPER, EnumColor.GRAY, EnumColor.RED), new d(Variant.BLOCKFISH, EnumColor.RED, EnumColor.WHITE), new d(Variant.FLOPPER, EnumColor.WHITE, EnumColor.YELLOW), new d(Variant.KOB, EnumColor.RED, EnumColor.WHITE), new d(Variant.SUNSTREAK, EnumColor.GRAY, EnumColor.WHITE), new d(Variant.DASHER, EnumColor.CYAN, EnumColor.YELLOW), new d(Variant.FLOPPER, EnumColor.YELLOW, EnumColor.YELLOW));
    private boolean isSchool = true;

    public EntityTropicalFish(EntityTypes<? extends EntityTropicalFish> var0, World var1) {
        super((EntityTypes<? extends EntityFishSchool>)var0, var1);
    }

    public static String getPredefinedName(int var0) {
        return "entity.minecraft.tropical_fish.predefined." + var0;
    }

    static int packVariant(Variant var0, EnumColor var1, EnumColor var2) {
        return var0.getPackedId() & 0xFFFF | (var1.getId() & 0xFF) << 16 | (var2.getId() & 0xFF) << 24;
    }

    public static EnumColor getBaseColor(int var0) {
        return EnumColor.byId(var0 >> 16 & 0xFF);
    }

    public static EnumColor getPatternColor(int var0) {
        return EnumColor.byId(var0 >> 24 & 0xFF);
    }

    public static Variant getPattern(int var0) {
        return Variant.byId(var0 & 0xFFFF);
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        super.defineSynchedData(var0);
        var0.define(DATA_ID_TYPE_VARIANT, DEFAULT_VARIANT.getPackedId());
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput var0) {
        super.addAdditionalSaveData(var0);
        var0.store("Variant", d.CODEC, new d(this.getPackedVariant()));
    }

    @Override
    protected void readAdditionalSaveData(ValueInput var0) {
        super.readAdditionalSaveData(var0);
        d var1 = var0.read("Variant", d.CODEC).orElse(DEFAULT_VARIANT);
        this.setPackedVariant(var1.getPackedId());
    }

    public void setPackedVariant(int var0) {
        this.entityData.set(DATA_ID_TYPE_VARIANT, var0);
    }

    @Override
    public boolean isMaxGroupSizeReached(int var0) {
        return !this.isSchool;
    }

    public int getPackedVariant() {
        return this.entityData.get(DATA_ID_TYPE_VARIANT);
    }

    public EnumColor getBaseColor() {
        return EntityTropicalFish.getBaseColor(this.getPackedVariant());
    }

    public EnumColor getPatternColor() {
        return EntityTropicalFish.getPatternColor(this.getPackedVariant());
    }

    public Variant getPattern() {
        return EntityTropicalFish.getPattern(this.getPackedVariant());
    }

    private void setPattern(Variant var0) {
        int var1 = this.getPackedVariant();
        EnumColor var2 = EntityTropicalFish.getBaseColor(var1);
        EnumColor var3 = EntityTropicalFish.getPatternColor(var1);
        this.setPackedVariant(EntityTropicalFish.packVariant(var0, var2, var3));
    }

    private void setBaseColor(EnumColor var0) {
        int var1 = this.getPackedVariant();
        Variant var2 = EntityTropicalFish.getPattern(var1);
        EnumColor var3 = EntityTropicalFish.getPatternColor(var1);
        this.setPackedVariant(EntityTropicalFish.packVariant(var2, var0, var3));
    }

    private void setPatternColor(EnumColor var0) {
        int var1 = this.getPackedVariant();
        Variant var2 = EntityTropicalFish.getPattern(var1);
        EnumColor var3 = EntityTropicalFish.getBaseColor(var1);
        this.setPackedVariant(EntityTropicalFish.packVariant(var2, var3, var0));
    }

    @Override
    public <T> @Nullable T get(DataComponentType<? extends T> var0) {
        if (var0 == DataComponents.TROPICAL_FISH_PATTERN) {
            return EntityTropicalFish.castComponentValue(var0, this.getPattern());
        }
        if (var0 == DataComponents.TROPICAL_FISH_BASE_COLOR) {
            return EntityTropicalFish.castComponentValue(var0, this.getBaseColor());
        }
        if (var0 == DataComponents.TROPICAL_FISH_PATTERN_COLOR) {
            return EntityTropicalFish.castComponentValue(var0, this.getPatternColor());
        }
        return super.get(var0);
    }

    @Override
    protected void applyImplicitComponents(DataComponentGetter var0) {
        this.applyImplicitComponentIfPresent(var0, DataComponents.TROPICAL_FISH_PATTERN);
        this.applyImplicitComponentIfPresent(var0, DataComponents.TROPICAL_FISH_BASE_COLOR);
        this.applyImplicitComponentIfPresent(var0, DataComponents.TROPICAL_FISH_PATTERN_COLOR);
        super.applyImplicitComponents(var0);
    }

    @Override
    protected <T> boolean applyImplicitComponent(DataComponentType<T> var0, T var1) {
        if (var0 == DataComponents.TROPICAL_FISH_PATTERN) {
            this.setPattern(EntityTropicalFish.castComponentValue(DataComponents.TROPICAL_FISH_PATTERN, var1));
            return true;
        }
        if (var0 == DataComponents.TROPICAL_FISH_BASE_COLOR) {
            this.setBaseColor(EntityTropicalFish.castComponentValue(DataComponents.TROPICAL_FISH_BASE_COLOR, var1));
            return true;
        }
        if (var0 == DataComponents.TROPICAL_FISH_PATTERN_COLOR) {
            this.setPatternColor(EntityTropicalFish.castComponentValue(DataComponents.TROPICAL_FISH_PATTERN_COLOR, var1));
            return true;
        }
        return super.applyImplicitComponent(var0, var1);
    }

    @Override
    public void saveToBucketTag(ItemStack var0) {
        super.saveToBucketTag(var0);
        var0.copyFrom(DataComponents.TROPICAL_FISH_PATTERN, this);
        var0.copyFrom(DataComponents.TROPICAL_FISH_BASE_COLOR, this);
        var0.copyFrom(DataComponents.TROPICAL_FISH_PATTERN_COLOR, this);
    }

    @Override
    public ItemStack getBucketItemStack() {
        return new ItemStack(Items.TROPICAL_FISH_BUCKET);
    }

    @Override
    protected SoundEffect getAmbientSound() {
        return SoundEffects.TROPICAL_FISH_AMBIENT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.TROPICAL_FISH_DEATH;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.TROPICAL_FISH_HURT;
    }

    @Override
    protected SoundEffect getFlopSound() {
        return SoundEffects.TROPICAL_FISH_FLOP;
    }

    @Override
    public @Nullable GroupDataEntity finalizeSpawn(WorldAccess var0, DifficultyDamageScaler var1, EntitySpawnReason var2, @Nullable GroupDataEntity var3) {
        d var4;
        var3 = super.finalizeSpawn(var0, var1, var2, var3);
        RandomSource var5 = var0.getRandom();
        if (var3 instanceof c) {
            c var6 = (c)var3;
            var4 = var6.variant;
        } else if ((double)var5.nextFloat() < 0.9) {
            var4 = SystemUtils.getRandom(COMMON_VARIANTS, var5);
            var3 = new c(this, var4);
        } else {
            this.isSchool = false;
            Variant[] var7 = Variant.values();
            EnumColor[] var8 = EnumColor.values();
            Variant var9 = SystemUtils.getRandom(var7, var5);
            EnumColor var10 = SystemUtils.getRandom(var8, var5);
            EnumColor var11 = SystemUtils.getRandom(var8, var5);
            var4 = new d(var9, var10, var11);
        }
        this.setPackedVariant(var4.getPackedId());
        return var3;
    }

    public static boolean checkTropicalFishSpawnRules(EntityTypes<EntityTropicalFish> var0, GeneratorAccess var1, EntitySpawnReason var2, BlockPosition var3, RandomSource var4) {
        return var1.getFluidState(var3.below()).is(TagsFluid.WATER) && var1.getBlockState(var3.above()).is(Blocks.WATER) && (var1.getBiome(var3).is(BiomeTags.ALLOWS_TROPICAL_FISH_SPAWNS_AT_ANY_HEIGHT) || EntityWaterAnimal.checkSurfaceWaterAnimalSpawnRules(var0, var1, var2, var3, var4));
    }

    public static final class Variant
    extends Enum<Variant>
    implements INamable,
    TooltipProvider {
        public static final /* enum */ Variant KOB = new Variant("kob", Base.SMALL, 0);
        public static final /* enum */ Variant SUNSTREAK = new Variant("sunstreak", Base.SMALL, 1);
        public static final /* enum */ Variant SNOOPER = new Variant("snooper", Base.SMALL, 2);
        public static final /* enum */ Variant DASHER = new Variant("dasher", Base.SMALL, 3);
        public static final /* enum */ Variant BRINELY = new Variant("brinely", Base.SMALL, 4);
        public static final /* enum */ Variant SPOTTY = new Variant("spotty", Base.SMALL, 5);
        public static final /* enum */ Variant FLOPPER = new Variant("flopper", Base.LARGE, 0);
        public static final /* enum */ Variant STRIPEY = new Variant("stripey", Base.LARGE, 1);
        public static final /* enum */ Variant GLITTER = new Variant("glitter", Base.LARGE, 2);
        public static final /* enum */ Variant BLOCKFISH = new Variant("blockfish", Base.LARGE, 3);
        public static final /* enum */ Variant BETTY = new Variant("betty", Base.LARGE, 4);
        public static final /* enum */ Variant CLAYFISH = new Variant("clayfish", Base.LARGE, 5);
        public static final Codec<Variant> CODEC;
        private static final IntFunction<Variant> BY_ID;
        public static final StreamCodec<ByteBuf, Variant> STREAM_CODEC;
        private final String name;
        private final IChatBaseComponent displayName;
        private final Base base;
        private final int packedId;
        private static final /* synthetic */ Variant[] t;

        public static Variant[] values() {
            return (Variant[])t.clone();
        }

        public static Variant valueOf(String var0) {
            return Enum.valueOf(Variant.class, var0);
        }

        private Variant(String var2, Base var3, int var4) {
            this.name = var2;
            this.base = var3;
            this.packedId = var3.id | var4 << 8;
            this.displayName = IChatBaseComponent.translatable("entity.minecraft.tropical_fish.type." + this.name);
        }

        public static Variant byId(int var0) {
            return BY_ID.apply(var0);
        }

        public Base base() {
            return this.base;
        }

        public int getPackedId() {
            return this.packedId;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        public IChatBaseComponent displayName() {
            return this.displayName;
        }

        @Override
        public void addToTooltip(Item.b var0, Consumer<IChatBaseComponent> var1, TooltipFlag var2, DataComponentGetter var3) {
            EnumColor var4 = var3.getOrDefault(DataComponents.TROPICAL_FISH_BASE_COLOR, DEFAULT_VARIANT.baseColor());
            EnumColor var5 = var3.getOrDefault(DataComponents.TROPICAL_FISH_PATTERN_COLOR, DEFAULT_VARIANT.patternColor());
            EnumChatFormat[] var6 = new EnumChatFormat[]{EnumChatFormat.ITALIC, EnumChatFormat.GRAY};
            int var7 = COMMON_VARIANTS.indexOf(new d(this, var4, var5));
            if (var7 != -1) {
                var1.accept(IChatBaseComponent.translatable(EntityTropicalFish.getPredefinedName(var7)).withStyle(var6));
                return;
            }
            var1.accept(this.displayName.plainCopy().withStyle(var6));
            IChatMutableComponent var8 = IChatBaseComponent.translatable("color.minecraft." + var4.getName());
            if (var4 != var5) {
                var8.append(", ").append(IChatBaseComponent.translatable("color.minecraft." + var5.getName()));
            }
            var8.withStyle(var6);
            var1.accept(var8);
        }

        private static /* synthetic */ Variant[] e() {
            return new Variant[]{KOB, SUNSTREAK, SNOOPER, DASHER, BRINELY, SPOTTY, FLOPPER, STRIPEY, GLITTER, BLOCKFISH, BETTY, CLAYFISH};
        }

        static {
            t = Variant.e();
            CODEC = INamable.fromEnum(Variant::values);
            BY_ID = ByIdMap.sparse(Variant::getPackedId, Variant.values(), KOB);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Variant::getPackedId);
        }
    }

    public record d(Variant pattern, EnumColor baseColor, EnumColor patternColor) {
        public static final Codec<d> CODEC = Codec.INT.xmap(d::new, d::getPackedId);

        public d(int var0) {
            this(EntityTropicalFish.getPattern(var0), EntityTropicalFish.getBaseColor(var0), EntityTropicalFish.getPatternColor(var0));
        }

        public int getPackedId() {
            return EntityTropicalFish.packVariant(this.pattern, this.baseColor, this.patternColor);
        }
    }

    static class c
    extends EntityFishSchool.a {
        final d variant;

        c(EntityTropicalFish var0, d var1) {
            super(var0);
            this.variant = var1;
        }
    }

    public static final class Base
    extends Enum<Base> {
        public static final /* enum */ Base SMALL = new Base(0);
        public static final /* enum */ Base LARGE = new Base(1);
        final int id;
        private static final /* synthetic */ Base[] d;

        public static Base[] values() {
            return (Base[])d.clone();
        }

        public static Base valueOf(String var0) {
            return Enum.valueOf(Base.class, var0);
        }

        private Base(int var2) {
            this.id = var2;
        }

        private static /* synthetic */ Base[] a() {
            return new Base[]{SMALL, LARGE};
        }

        static {
            d = Base.a();
        }
    }
}

