/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.nautilus;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsEntity;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.behavior.AnimalPanic;
import net.minecraft.world.entity.ai.behavior.BehaviorAttackTargetSet;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.BehaviorGate;
import net.minecraft.world.entity.ai.behavior.BehaviorLook;
import net.minecraft.world.entity.ai.behavior.BehaviorLookWalk;
import net.minecraft.world.entity.ai.behavior.BehaviorMakeLoveAnimal;
import net.minecraft.world.entity.ai.behavior.BehaviorStrollRandomUnconstrained;
import net.minecraft.world.entity.ai.behavior.BehaviorUtil;
import net.minecraft.world.entity.ai.behavior.BehavorMove;
import net.minecraft.world.entity.ai.behavior.ChargeAttack;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.FollowTemptation;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.nautilus.AbstractNautilus;
import net.minecraft.world.entity.animal.nautilus.Nautilus;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.gamerules.GameRules;

public class NautilusAi {
    private static final float SPEED_MULTIPLIER_WHEN_IDLING_IN_WATER = 1.0f;
    private static final float SPEED_MULTIPLIER_WHEN_TEMPTED = 1.3f;
    private static final float SPEED_MULTIPLIER_WHEN_MAKING_LOVE = 0.4f;
    private static final float SPEED_MULTIPLIER_WHEN_PANICKING = 1.6f;
    private static final UniformInt TIME_BETWEEN_NON_PLAYER_ATTACKS = UniformInt.of(2400, 3600);
    private static final float SPEED_WHEN_ATTACKING = 0.6f;
    private static final float ATTACK_KNOCKBACK_FORCE = 2.0f;
    private static final int ANGER_DURATION = 400;
    private static final int TIME_BETWEEN_ATTACKS = 80;
    private static final double MAX_CHARGE_DISTANCE = 12.0;
    private static final double MAX_TARGET_DETECTION_DISTANCE = 11.0;
    protected static final PathfinderTargetCondition ATTACK_TARGET_CONDITIONS = PathfinderTargetCondition.forCombat().selector((var0, var1) -> (var1.getGameRules().get(GameRules.MOB_GRIEFING) != false || !var0.getType().equals(EntityTypes.ARMOR_STAND)) && var1.getWorldBorder().isWithinBounds(var0.getBoundingBox()));
    protected static final ImmutableList<SensorType<? extends Sensor<? super Nautilus>>> SENSOR_TYPES = ImmutableList.of(SensorType.NEAREST_LIVING_ENTITIES, SensorType.NEAREST_ADULT, SensorType.NEAREST_PLAYERS, SensorType.HURT_BY, SensorType.NAUTILUS_TEMPTATIONS);
    protected static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of(MemoryModuleType.LOOK_TARGET, MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, MemoryModuleType.WALK_TARGET, MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, MemoryModuleType.PATH, MemoryModuleType.NEAREST_VISIBLE_ADULT, MemoryModuleType.TEMPTATION_COOLDOWN_TICKS, MemoryModuleType.IS_TEMPTED, MemoryModuleType.TEMPTING_PLAYER, MemoryModuleType.BREED_TARGET, MemoryModuleType.IS_PANICKING, MemoryModuleType.ATTACK_TARGET, (Object[])new MemoryModuleType[]{MemoryModuleType.CHARGE_COOLDOWN_TICKS, MemoryModuleType.HURT_BY, MemoryModuleType.ANGRY_AT, MemoryModuleType.ATTACK_TARGET_COOLDOWN});

    protected static void initMemories(AbstractNautilus var0, RandomSource var1) {
        var0.getBrain().setMemory(MemoryModuleType.ATTACK_TARGET_COOLDOWN, TIME_BETWEEN_NON_PLAYER_ATTACKS.sample(var1));
    }

    protected static BehaviorController.b<Nautilus> brainProvider() {
        return BehaviorController.provider(MEMORY_TYPES, SENSOR_TYPES);
    }

    protected static BehaviorController<?> makeBrain(BehaviorController<Nautilus> var0) {
        NautilusAi.initCoreActivity(var0);
        NautilusAi.initIdleActivity(var0);
        NautilusAi.initFightActivity(var0);
        var0.setCoreActivities((Set<Activity>)ImmutableSet.of((Object)Activity.CORE));
        var0.setDefaultActivity(Activity.IDLE);
        var0.useDefaultActivity();
        return var0;
    }

    private static void initCoreActivity(BehaviorController<Nautilus> var0) {
        var0.addActivity(Activity.CORE, 0, (ImmutableList<BehaviorControl<Nautilus>>)ImmutableList.of(new AnimalPanic(1.6f), (Object)new BehaviorLook(45, 90), (Object)new BehavorMove(), (Object)new CountDownCooldownTicks(MemoryModuleType.TEMPTATION_COOLDOWN_TICKS), (Object)new CountDownCooldownTicks(MemoryModuleType.CHARGE_COOLDOWN_TICKS), (Object)new CountDownCooldownTicks(MemoryModuleType.ATTACK_TARGET_COOLDOWN)));
    }

    private static void initIdleActivity(BehaviorController<Nautilus> var02) {
        var02.addActivity(Activity.IDLE, (ImmutableList<Pair<Integer, BehaviorControl<Nautilus>>>)ImmutableList.of((Object)Pair.of((Object)1, (Object)new BehaviorMakeLoveAnimal(EntityTypes.NAUTILUS, 0.4f, 2)), (Object)Pair.of((Object)2, (Object)new FollowTemptation(var0 -> Float.valueOf(1.3f), var0 -> var0.isBaby() ? 2.5 : 3.5)), (Object)Pair.of((Object)3, BehaviorAttackTargetSet.create(NautilusAi::findNearestValidAttackTarget)), (Object)Pair.of((Object)4, new BehaviorGate((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT)), (Set<MemoryModuleType<?>>)ImmutableSet.of(), BehaviorGate.Order.ORDERED, BehaviorGate.Execution.TRY_ALL, ImmutableList.of((Object)Pair.of(BehaviorStrollRandomUnconstrained.swim(1.0f), (Object)2), (Object)Pair.of(BehaviorLookWalk.create(1.0f, 3), (Object)3))))));
    }

    private static void initFightActivity(BehaviorController<Nautilus> var0) {
        var0.addActivityWithConditions(Activity.FIGHT, (ImmutableList<Pair<Integer, BehaviorControl<Nautilus>>>)ImmutableList.of((Object)Pair.of((Object)0, (Object)new ChargeAttack(80, ATTACK_TARGET_CONDITIONS, 0.6f, 2.0f, 12.0, 11.0, SoundEffects.NAUTILUS_DASH))), (Set<Pair<MemoryModuleType<?>, MemoryStatus>>)ImmutableSet.of((Object)Pair.of(MemoryModuleType.ATTACK_TARGET, (Object)((Object)MemoryStatus.VALUE_PRESENT)), (Object)Pair.of(MemoryModuleType.TEMPTING_PLAYER, (Object)((Object)MemoryStatus.VALUE_ABSENT)), (Object)Pair.of(MemoryModuleType.BREED_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT)), (Object)Pair.of(MemoryModuleType.CHARGE_COOLDOWN_TICKS, (Object)((Object)MemoryStatus.VALUE_ABSENT))));
    }

    protected static Optional<? extends EntityLiving> findNearestValidAttackTarget(WorldServer var0, AbstractNautilus var1) {
        if (BehaviorUtil.isBreeding(var1) || !var1.isInWater() || var1.isBaby() || var1.isTame()) {
            return Optional.empty();
        }
        Optional<EntityLiving> var22 = BehaviorUtil.getLivingEntityFromUUIDMemory(var1, MemoryModuleType.ANGRY_AT).filter(var2 -> var2.isInWater() && Sensor.isEntityAttackableIgnoringLineOfSight(var0, var1, var2));
        if (var22.isPresent()) {
            return var22;
        }
        if (var1.getBrain().hasMemoryValue(MemoryModuleType.ATTACK_TARGET_COOLDOWN)) {
            return Optional.empty();
        }
        var1.getBrain().setMemory(MemoryModuleType.ATTACK_TARGET_COOLDOWN, TIME_BETWEEN_NON_PLAYER_ATTACKS.sample(var0.random));
        if (var0.random.nextFloat() < 0.5f) {
            return Optional.empty();
        }
        Optional<EntityLiving> var3 = var1.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES).orElse(NearestVisibleLivingEntities.empty()).findClosest(NautilusAi::isHostileTarget);
        return var3;
    }

    protected static void setAngerTarget(WorldServer var0, AbstractNautilus var1, EntityLiving var2) {
        if (Sensor.isEntityAttackableIgnoringLineOfSight(var0, var1, var2)) {
            var1.getBrain().eraseMemory(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE);
            var1.getBrain().setMemoryWithExpiry(MemoryModuleType.ANGRY_AT, var2.getUUID(), 400L);
        }
    }

    private static boolean isHostileTarget(EntityLiving var0) {
        return var0.isInWater() && var0.getType().is(TagsEntity.NAUTILUS_HOSTILES);
    }

    public static void updateActivity(Nautilus var0) {
        var0.getBrain().setActiveActivityToFirstValid((List<Activity>)ImmutableList.of((Object)Activity.FIGHT, (Object)Activity.IDLE));
    }

    public static Predicate<ItemStack> getTemptations() {
        return var0 -> var0.is(TagsItem.NAUTILUS_FOOD);
    }
}

