/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.zombie;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SpecialDates;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntityPositionTypes;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreakDoor;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMoveThroughVillage;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRemoveBlock;
import net.minecraft.world.entity.ai.goal.PathfinderGoalZombieAttack;
import net.minecraft.world.entity.ai.goal.SpearUseGoal;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.chicken.EntityChicken;
import net.minecraft.world.entity.animal.golem.EntityIronGolem;
import net.minecraft.world.entity.animal.turtle.EntityTurtle;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.zombie.EntityPigZombie;
import net.minecraft.world.entity.monster.zombie.EntityZombieVillager;
import net.minecraft.world.entity.npc.villager.EntityVillager;
import net.minecraft.world.entity.npc.villager.EntityVillagerAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jspecify.annotations.Nullable;

public class EntityZombie
extends EntityMonster {
    private static final MinecraftKey SPEED_MODIFIER_BABY_ID = MinecraftKey.withDefaultNamespace("baby");
    private static final AttributeModifier SPEED_MODIFIER_BABY = new AttributeModifier(SPEED_MODIFIER_BABY_ID, 0.5, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    private static final MinecraftKey REINFORCEMENT_CALLER_CHARGE_ID = MinecraftKey.withDefaultNamespace("reinforcement_caller_charge");
    private static final AttributeModifier ZOMBIE_REINFORCEMENT_CALLEE_CHARGE = new AttributeModifier(MinecraftKey.withDefaultNamespace("reinforcement_callee_charge"), -0.05f, AttributeModifier.Operation.ADD_VALUE);
    private static final MinecraftKey LEADER_ZOMBIE_BONUS_ID = MinecraftKey.withDefaultNamespace("leader_zombie_bonus");
    private static final MinecraftKey ZOMBIE_RANDOM_SPAWN_BONUS_ID = MinecraftKey.withDefaultNamespace("zombie_random_spawn_bonus");
    private static final DataWatcherObject<Boolean> DATA_BABY_ID = DataWatcher.defineId(EntityZombie.class, DataWatcherRegistry.BOOLEAN);
    private static final DataWatcherObject<Integer> DATA_SPECIAL_TYPE_ID = DataWatcher.defineId(EntityZombie.class, DataWatcherRegistry.INT);
    public static final DataWatcherObject<Boolean> DATA_DROWNED_CONVERSION_ID = DataWatcher.defineId(EntityZombie.class, DataWatcherRegistry.BOOLEAN);
    public static final float ZOMBIE_LEADER_CHANCE = 0.05f;
    public static final int REINFORCEMENT_ATTEMPTS = 50;
    public static final int REINFORCEMENT_RANGE_MAX = 40;
    public static final int REINFORCEMENT_RANGE_MIN = 7;
    private static final int NOT_CONVERTING = -1;
    private static final EntitySize BABY_DIMENSIONS = EntityTypes.ZOMBIE.getDimensions().scale(0.5f).withEyeHeight(0.93f);
    private static final float BREAK_DOOR_CHANCE = 0.1f;
    private static final Predicate<EnumDifficulty> DOOR_BREAKING_PREDICATE = var0 -> var0 == EnumDifficulty.HARD;
    private static final boolean DEFAULT_BABY = false;
    private static final boolean DEFAULT_CAN_BREAK_DOORS = false;
    private static final int DEFAULT_IN_WATER_TIME = 0;
    private final PathfinderGoalBreakDoor breakDoorGoal = new PathfinderGoalBreakDoor(this, DOOR_BREAKING_PREDICATE);
    private boolean canBreakDoors = false;
    private int inWaterTime = 0;
    public int conversionTime;

    public EntityZombie(EntityTypes<? extends EntityZombie> var0, World var1) {
        super((EntityTypes<? extends EntityMonster>)var0, var1);
    }

    public EntityZombie(World var0) {
        this((EntityTypes<? extends EntityZombie>)EntityTypes.ZOMBIE, var0);
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(4, new a((EntityCreature)this, 1.0, 3));
        this.goalSelector.addGoal(8, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.goalSelector.addGoal(8, new PathfinderGoalRandomLookaround(this));
        this.addBehaviourGoals();
    }

    protected void addBehaviourGoals() {
        this.goalSelector.addGoal(2, new SpearUseGoal<EntityZombie>(this, 1.0, 1.0, 10.0f, 2.0f));
        this.goalSelector.addGoal(3, new PathfinderGoalZombieAttack(this, 1.0, false));
        this.goalSelector.addGoal(6, new PathfinderGoalMoveThroughVillage(this, 1.0, true, 4, this::canBreakDoors));
        this.goalSelector.addGoal(7, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.targetSelector.addGoal(1, new PathfinderGoalHurtByTarget(this, new Class[0]).setAlertOthers(EntityPigZombie.class));
        this.targetSelector.addGoal(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
        this.targetSelector.addGoal(3, new PathfinderGoalNearestAttackableTarget<EntityVillagerAbstract>((EntityInsentient)this, EntityVillagerAbstract.class, false));
        this.targetSelector.addGoal(3, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, true));
        this.targetSelector.addGoal(5, new PathfinderGoalNearestAttackableTarget<EntityTurtle>(this, EntityTurtle.class, 10, true, false, EntityTurtle.BABY_ON_LAND_SELECTOR));
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityMonster.createMonsterAttributes().add(GenericAttributes.FOLLOW_RANGE, 35.0).add(GenericAttributes.MOVEMENT_SPEED, 0.23f).add(GenericAttributes.ATTACK_DAMAGE, 3.0).add(GenericAttributes.ARMOR, 2.0).add(GenericAttributes.SPAWN_REINFORCEMENTS_CHANCE);
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        super.defineSynchedData(var0);
        var0.define(DATA_BABY_ID, false);
        var0.define(DATA_SPECIAL_TYPE_ID, 0);
        var0.define(DATA_DROWNED_CONVERSION_ID, false);
    }

    public boolean isUnderWaterConverting() {
        return this.getEntityData().get(DATA_DROWNED_CONVERSION_ID);
    }

    public boolean canBreakDoors() {
        return this.canBreakDoors;
    }

    public void setCanBreakDoors(boolean var0) {
        if (this.navigation.canNavigateGround()) {
            if (this.canBreakDoors != var0) {
                this.canBreakDoors = var0;
                this.navigation.setCanOpenDoors(var0);
                if (var0) {
                    this.goalSelector.addGoal(1, this.breakDoorGoal);
                } else {
                    this.goalSelector.removeGoal(this.breakDoorGoal);
                }
            }
        } else if (this.canBreakDoors) {
            this.goalSelector.removeGoal(this.breakDoorGoal);
            this.canBreakDoors = false;
        }
    }

    @Override
    public boolean isBaby() {
        return this.getEntityData().get(DATA_BABY_ID);
    }

    @Override
    protected int getBaseExperienceReward(WorldServer var0) {
        if (this.isBaby()) {
            this.xpReward = (int)((double)this.xpReward * 2.5);
        }
        return super.getBaseExperienceReward(var0);
    }

    @Override
    public void setBaby(boolean var0) {
        this.getEntityData().set(DATA_BABY_ID, var0);
        if (this.level() != null && !this.level().isClientSide()) {
            AttributeModifiable var1 = this.getAttribute(GenericAttributes.MOVEMENT_SPEED);
            var1.removeModifier(SPEED_MODIFIER_BABY_ID);
            if (var0) {
                var1.addTransientModifier(SPEED_MODIFIER_BABY);
            }
        }
    }

    @Override
    public void onSyncedDataUpdated(DataWatcherObject<?> var0) {
        if (DATA_BABY_ID.equals(var0)) {
            this.refreshDimensions();
        }
        super.onSyncedDataUpdated(var0);
    }

    protected boolean convertsInWater() {
        return true;
    }

    @Override
    public void tick() {
        World world = this.level();
        if (world instanceof WorldServer) {
            WorldServer var0 = (WorldServer)world;
            if (this.isAlive() && !this.isNoAi()) {
                if (this.isUnderWaterConverting()) {
                    --this.conversionTime;
                    if (this.conversionTime < 0) {
                        this.doUnderWaterConversion(var0);
                    }
                } else if (this.convertsInWater()) {
                    if (this.isEyeInFluid(TagsFluid.WATER)) {
                        ++this.inWaterTime;
                        if (this.inWaterTime >= 600) {
                            this.startUnderWaterConversion(300);
                        }
                    } else {
                        this.inWaterTime = -1;
                    }
                }
            }
        }
        super.tick();
    }

    public void startUnderWaterConversion(int var0) {
        this.conversionTime = var0;
        this.getEntityData().set(DATA_DROWNED_CONVERSION_ID, true);
    }

    protected void doUnderWaterConversion(WorldServer var0) {
        this.convertToZombieType(var0, EntityTypes.DROWNED);
        if (!this.isSilent()) {
            var0.levelEvent(null, 1040, this.blockPosition(), 0);
        }
    }

    protected void convertToZombieType(WorldServer var0, EntityTypes<? extends EntityZombie> var12) {
        this.convertTo(var12, ConversionParams.single(this, true, true), var1 -> var1.handleAttributes(var0.getCurrentDifficultyAt(var1.blockPosition()).getSpecialMultiplier()));
    }

    @VisibleForTesting
    public boolean convertVillagerToZombieVillager(WorldServer var0, EntityVillager var1) {
        EntityZombieVillager var22 = var1.convertTo(EntityTypes.ZOMBIE_VILLAGER, ConversionParams.single(var1, true, true), var2 -> {
            var2.finalizeSpawn(var0, var0.getCurrentDifficultyAt(var2.blockPosition()), EntitySpawnReason.CONVERSION, new GroupDataZombie(false, true));
            var2.setVillagerData(var1.getVillagerData());
            var2.setGossips(var1.getGossips().copy());
            var2.setTradeOffers(var1.getOffers().copy());
            var2.setVillagerXp(var1.getVillagerXp());
            if (!this.isSilent()) {
                var0.levelEvent(null, 1026, this.blockPosition(), 0);
            }
        });
        return var22 != null;
    }

    protected boolean isSunSensitive() {
        return true;
    }

    @Override
    public boolean hurtServer(WorldServer var0, DamageSource var1, float var2) {
        if (!super.hurtServer(var0, var1, var2)) {
            return false;
        }
        EntityLiving var3 = this.getTarget();
        if (var3 == null && var1.getEntity() instanceof EntityLiving) {
            var3 = (EntityLiving)var1.getEntity();
        }
        if (var3 != null && var0.getDifficulty() == EnumDifficulty.HARD && (double)this.random.nextFloat() < this.getAttributeValue(GenericAttributes.SPAWN_REINFORCEMENTS_CHANCE) && var0.isSpawningMonsters()) {
            int var4 = MathHelper.floor(this.getX());
            int var5 = MathHelper.floor(this.getY());
            int var6 = MathHelper.floor(this.getZ());
            EntityTypes<? extends EntityZombie> var7 = this.getType();
            EntityZombie var8 = var7.create(var0, EntitySpawnReason.REINFORCEMENT);
            if (var8 == null) {
                return true;
            }
            for (int var9 = 0; var9 < 50; ++var9) {
                int var12;
                int var11;
                int var10 = var4 + MathHelper.nextInt(this.random, 7, 40) * MathHelper.nextInt(this.random, -1, 1);
                BlockPosition var13 = new BlockPosition(var10, var11 = var5 + MathHelper.nextInt(this.random, 7, 40) * MathHelper.nextInt(this.random, -1, 1), var12 = var6 + MathHelper.nextInt(this.random, 7, 40) * MathHelper.nextInt(this.random, -1, 1));
                if (!EntityPositionTypes.isSpawnPositionOk(var7, var0, var13) || !EntityPositionTypes.checkSpawnRules(var7, var0, EntitySpawnReason.REINFORCEMENT, var13, var0.random)) continue;
                var8.setPos(var10, var11, var12);
                if (var0.hasNearbyAlivePlayer(var10, var11, var12, 7.0) || !var0.isUnobstructed(var8) || !var0.noCollision(var8) || !var8.canSpawnInLiquids() && var0.containsAnyLiquid(var8.getBoundingBox())) continue;
                var8.setTarget(var3);
                var8.finalizeSpawn(var0, var0.getCurrentDifficultyAt(var8.blockPosition()), EntitySpawnReason.REINFORCEMENT, null);
                var0.addFreshEntityWithPassengers(var8);
                AttributeModifiable var14 = this.getAttribute(GenericAttributes.SPAWN_REINFORCEMENTS_CHANCE);
                AttributeModifier var15 = var14.getModifier(REINFORCEMENT_CALLER_CHARGE_ID);
                double var16 = var15 != null ? var15.amount() : 0.0;
                var14.removeModifier(REINFORCEMENT_CALLER_CHARGE_ID);
                var14.addPermanentModifier(new AttributeModifier(REINFORCEMENT_CALLER_CHARGE_ID, var16 - 0.05, AttributeModifier.Operation.ADD_VALUE));
                var8.getAttribute(GenericAttributes.SPAWN_REINFORCEMENTS_CHANCE).addPermanentModifier(ZOMBIE_REINFORCEMENT_CALLEE_CHARGE);
                break;
            }
        }
        return true;
    }

    @Override
    public boolean doHurtTarget(WorldServer var0, Entity var1) {
        boolean var2 = super.doHurtTarget(var0, var1);
        if (var2) {
            float var3 = var0.getCurrentDifficultyAt(this.blockPosition()).getEffectiveDifficulty();
            if (this.getMainHandItem().isEmpty() && this.isOnFire() && this.random.nextFloat() < var3 * 0.3f) {
                var1.igniteForSeconds(2 * (int)var3);
            }
        }
        return var2;
    }

    @Override
    protected SoundEffect getAmbientSound() {
        return SoundEffects.ZOMBIE_AMBIENT;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.ZOMBIE_HURT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.ZOMBIE_DEATH;
    }

    protected SoundEffect getStepSound() {
        return SoundEffects.ZOMBIE_STEP;
    }

    @Override
    protected void playStepSound(BlockPosition var0, IBlockData var1) {
        this.playSound(this.getStepSound(), 0.15f, 1.0f);
    }

    public EntityTypes<? extends EntityZombie> getType() {
        return super.getType();
    }

    protected boolean canSpawnInLiquids() {
        return false;
    }

    @Override
    protected void populateDefaultEquipmentSlots(RandomSource var0, DifficultyDamageScaler var1) {
        super.populateDefaultEquipmentSlots(var0, var1);
        float f2 = var0.nextFloat();
        float f3 = this.level().getDifficulty() == EnumDifficulty.HARD ? 0.05f : 0.01f;
        if (f2 < f3) {
            int var2 = var0.nextInt(6);
            if (var2 == 0) {
                this.setItemSlot(EnumItemSlot.MAINHAND, new ItemStack(Items.IRON_SWORD));
            } else if (var2 == 1) {
                this.setItemSlot(EnumItemSlot.MAINHAND, new ItemStack(Items.IRON_SPEAR));
            } else {
                this.setItemSlot(EnumItemSlot.MAINHAND, new ItemStack(Items.IRON_SHOVEL));
            }
        }
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput var0) {
        super.addAdditionalSaveData(var0);
        var0.putBoolean("IsBaby", this.isBaby());
        var0.putBoolean("CanBreakDoors", this.canBreakDoors());
        var0.putInt("InWaterTime", this.isInWater() ? this.inWaterTime : -1);
        var0.putInt("DrownedConversionTime", this.isUnderWaterConverting() ? this.conversionTime : -1);
    }

    @Override
    protected void readAdditionalSaveData(ValueInput var0) {
        super.readAdditionalSaveData(var0);
        this.setBaby(var0.getBooleanOr("IsBaby", false));
        this.setCanBreakDoors(var0.getBooleanOr("CanBreakDoors", false));
        this.inWaterTime = var0.getIntOr("InWaterTime", 0);
        int var1 = var0.getIntOr("DrownedConversionTime", -1);
        if (var1 != -1) {
            this.startUnderWaterConversion(var1);
        } else {
            this.getEntityData().set(DATA_DROWNED_CONVERSION_ID, false);
        }
    }

    @Override
    public boolean killedEntity(WorldServer var0, EntityLiving var1, DamageSource var2) {
        boolean var3 = super.killedEntity(var0, var1, var2);
        if ((var0.getDifficulty() == EnumDifficulty.NORMAL || var0.getDifficulty() == EnumDifficulty.HARD) && var1 instanceof EntityVillager) {
            EntityVillager var4 = (EntityVillager)var1;
            if (var0.getDifficulty() != EnumDifficulty.HARD && this.random.nextBoolean()) {
                return var3;
            }
            if (this.convertVillagerToZombieVillager(var0, var4)) {
                var3 = false;
            }
        }
        return var3;
    }

    @Override
    public EntitySize getDefaultDimensions(EntityPose var0) {
        return this.isBaby() ? BABY_DIMENSIONS : super.getDefaultDimensions(var0);
    }

    @Override
    public boolean canHoldItem(ItemStack var0) {
        if (var0.is(TagsItem.EGGS) && this.isBaby() && this.isPassenger()) {
            return false;
        }
        return super.canHoldItem(var0);
    }

    @Override
    public boolean wantsToPickUp(WorldServer var0, ItemStack var1) {
        if (var1.is(Items.GLOW_INK_SAC)) {
            return false;
        }
        return super.wantsToPickUp(var0, var1);
    }

    @Override
    public @Nullable GroupDataEntity finalizeSpawn(WorldAccess var0, DifficultyDamageScaler var1, EntitySpawnReason var2, @Nullable GroupDataEntity var3) {
        RandomSource var4 = var0.getRandom();
        var3 = super.finalizeSpawn(var0, var1, var2, var3);
        float var5 = var1.getSpecialMultiplier();
        if (var2 != EntitySpawnReason.CONVERSION) {
            this.setCanPickUpLoot(var4.nextFloat() < 0.55f * var5);
        }
        if (var3 == null) {
            var3 = new GroupDataZombie(EntityZombie.getSpawnAsBabyOdds(var4), true);
        }
        if (var3 instanceof GroupDataZombie) {
            GroupDataZombie var6 = (GroupDataZombie)var3;
            if (var6.isBaby) {
                this.setBaby(true);
                if (var6.canSpawnJockey) {
                    EntityChicken var7;
                    if ((double)var4.nextFloat() < 0.05) {
                        List<Entity> var72 = var0.getEntitiesOfClass(EntityChicken.class, this.getBoundingBox().inflate(5.0, 3.0, 5.0), IEntitySelector.ENTITY_NOT_BEING_RIDDEN);
                        if (!var72.isEmpty()) {
                            EntityChicken var8 = (EntityChicken)var72.get(0);
                            var8.setChickenJockey(true);
                            this.startRiding(var8, false, false);
                        }
                    } else if ((double)var4.nextFloat() < 0.05 && (var7 = EntityTypes.CHICKEN.create(this.level(), EntitySpawnReason.JOCKEY)) != null) {
                        var7.snapTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), 0.0f);
                        var7.finalizeSpawn(var0, var1, EntitySpawnReason.JOCKEY, null);
                        var7.setChickenJockey(true);
                        this.startRiding(var7, false, false);
                        var0.addFreshEntity(var7);
                    }
                }
            }
            this.setCanBreakDoors(var4.nextFloat() < var5 * 0.1f);
            if (var2 != EntitySpawnReason.CONVERSION) {
                this.populateDefaultEquipmentSlots(var4, var1);
                this.populateDefaultEquipmentEnchantments(var0, var4, var1);
            }
        }
        if (this.getItemBySlot(EnumItemSlot.HEAD).isEmpty() && SpecialDates.isHalloween() && var4.nextFloat() < 0.25f) {
            this.setItemSlot(EnumItemSlot.HEAD, new ItemStack(var4.nextFloat() < 0.1f ? Blocks.JACK_O_LANTERN : Blocks.CARVED_PUMPKIN));
            this.setDropChance(EnumItemSlot.HEAD, 0.0f);
        }
        this.handleAttributes(var5);
        return var3;
    }

    @VisibleForTesting
    public void setInWaterTime(int var0) {
        this.inWaterTime = var0;
    }

    @VisibleForTesting
    public void setConversionTime(int var0) {
        this.conversionTime = var0;
    }

    public static boolean getSpawnAsBabyOdds(RandomSource var0) {
        return var0.nextFloat() < 0.05f;
    }

    protected void handleAttributes(float var0) {
        this.randomizeReinforcementsChance();
        this.getAttribute(GenericAttributes.KNOCKBACK_RESISTANCE).addOrReplacePermanentModifier(new AttributeModifier(RANDOM_SPAWN_BONUS_ID, this.random.nextDouble() * (double)0.05f, AttributeModifier.Operation.ADD_VALUE));
        double var1 = this.random.nextDouble() * 1.5 * (double)var0;
        if (var1 > 1.0) {
            this.getAttribute(GenericAttributes.FOLLOW_RANGE).addOrReplacePermanentModifier(new AttributeModifier(ZOMBIE_RANDOM_SPAWN_BONUS_ID, var1, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        }
        if (this.random.nextFloat() < var0 * 0.05f) {
            this.getAttribute(GenericAttributes.SPAWN_REINFORCEMENTS_CHANCE).addOrReplacePermanentModifier(new AttributeModifier(LEADER_ZOMBIE_BONUS_ID, this.random.nextDouble() * 0.25 + 0.5, AttributeModifier.Operation.ADD_VALUE));
            this.getAttribute(GenericAttributes.MAX_HEALTH).addOrReplacePermanentModifier(new AttributeModifier(LEADER_ZOMBIE_BONUS_ID, this.random.nextDouble() * 3.0 + 1.0, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
            this.setCanBreakDoors(true);
        }
    }

    protected void randomizeReinforcementsChance() {
        this.getAttribute(GenericAttributes.SPAWN_REINFORCEMENTS_CHANCE).setBaseValue(this.random.nextDouble() * (double)0.1f);
    }

    class a
    extends PathfinderGoalRemoveBlock {
        a(EntityCreature var1, double var2, int var4) {
            super(Blocks.TURTLE_EGG, var1, var2, var4);
        }

        @Override
        public void playDestroyProgressSound(GeneratorAccess var0, BlockPosition var1) {
            var0.playSound(null, var1, SoundEffects.ZOMBIE_DESTROY_EGG, SoundCategory.HOSTILE, 0.5f, 0.9f + EntityZombie.this.random.nextFloat() * 0.2f);
        }

        @Override
        public void playBreakSound(World var0, BlockPosition var1) {
            var0.playSound(null, var1, SoundEffects.TURTLE_EGG_BREAK, SoundCategory.BLOCKS, 0.7f, 0.9f + var0.random.nextFloat() * 0.2f);
        }

        @Override
        public double acceptedDistance() {
            return 1.14;
        }
    }

    public static class GroupDataZombie
    implements GroupDataEntity {
        public final boolean isBaby;
        public final boolean canSpawnJockey;

        public GroupDataZombie(boolean var0, boolean var1) {
            this.isBaby = var0;
            this.canSpawnJockey = var1;
        }
    }
}

