/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.npc.villager;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.npc.villager.VillagerProfession;
import net.minecraft.world.entity.npc.villager.VillagerType;

public record VillagerData(Holder<VillagerType> type, Holder<VillagerProfession> profession, int level) {
    public static final int MIN_VILLAGER_LEVEL = 1;
    public static final int MAX_VILLAGER_LEVEL = 5;
    private static final int[] NEXT_LEVEL_XP_THRESHOLDS = new int[]{0, 10, 70, 150, 250};
    public static final Codec<VillagerData> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)BuiltInRegistries.VILLAGER_TYPE.holderByNameCodec().fieldOf("type").orElseGet(() -> BuiltInRegistries.VILLAGER_TYPE.getOrThrow(VillagerType.PLAINS)).forGetter(var0 -> var0.type), (App)BuiltInRegistries.VILLAGER_PROFESSION.holderByNameCodec().fieldOf("profession").orElseGet(() -> BuiltInRegistries.VILLAGER_PROFESSION.getOrThrow(VillagerProfession.NONE)).forGetter(var0 -> var0.profession), (App)Codec.INT.fieldOf("level").orElse((Object)1).forGetter(var0 -> var0.level)).apply((Applicative)var02, VillagerData::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, VillagerData> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.holderRegistry(Registries.VILLAGER_TYPE), VillagerData::type, ByteBufCodecs.holderRegistry(Registries.VILLAGER_PROFESSION), VillagerData::profession, ByteBufCodecs.VAR_INT, VillagerData::level, VillagerData::new);

    public VillagerData {
        var2 = Math.max(1, var2);
    }

    public VillagerData withType(Holder<VillagerType> var0) {
        return new VillagerData(var0, this.profession, this.level);
    }

    public VillagerData withType(HolderGetter.a var0, ResourceKey<VillagerType> var1) {
        return this.withType(var0.getOrThrow(var1));
    }

    public VillagerData withProfession(Holder<VillagerProfession> var0) {
        return new VillagerData(this.type, var0, this.level);
    }

    public VillagerData withProfession(HolderGetter.a var0, ResourceKey<VillagerProfession> var1) {
        return this.withProfession(var0.getOrThrow(var1));
    }

    public VillagerData withLevel(int var0) {
        return new VillagerData(this.type, this.profession, var0);
    }

    public static int getMinXpPerLevel(int var0) {
        return VillagerData.canLevelUp(var0) ? NEXT_LEVEL_XP_THRESHOLDS[var0 - 1] : 0;
    }

    public static int getMaxXpPerLevel(int var0) {
        return VillagerData.canLevelUp(var0) ? NEXT_LEVEL_XP_THRESHOLDS[var0] : 0;
    }

    public static boolean canLevelUp(int var0) {
        return var0 >= 1 && var0 < 5;
    }
}

