/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile.hurtingprojectile;

import net.minecraft.core.BlockPosition;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.boss.wither.EntityWither;
import net.minecraft.world.entity.projectile.hurtingprojectile.EntityFireball;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;

public class EntityWitherSkull
extends EntityFireball {
    private static final DataWatcherObject<Boolean> DATA_DANGEROUS = DataWatcher.defineId(EntityWitherSkull.class, DataWatcherRegistry.BOOLEAN);
    private static final boolean DEFAULT_DANGEROUS = false;

    public EntityWitherSkull(EntityTypes<? extends EntityWitherSkull> var0, World var1) {
        super((EntityTypes<? extends EntityFireball>)var0, var1);
    }

    public EntityWitherSkull(World var0, EntityLiving var1, Vec3D var2) {
        super(EntityTypes.WITHER_SKULL, var1, var2, var0);
    }

    @Override
    protected float getInertia() {
        return this.isDangerous() ? 0.73f : super.getInertia();
    }

    @Override
    public boolean isOnFire() {
        return false;
    }

    @Override
    public float getBlockExplosionResistance(Explosion var0, IBlockAccess var1, BlockPosition var2, IBlockData var3, Fluid var4, float var5) {
        if (this.isDangerous() && EntityWither.canDestroy(var3)) {
            return Math.min(0.8f, var5);
        }
        return var5;
    }

    @Override
    protected void onHitEntity(MovingObjectPositionEntity var0) {
        boolean var4;
        EntityLiving var5;
        super.onHitEntity(var0);
        World world = this.level();
        if (!(world instanceof WorldServer)) {
            return;
        }
        WorldServer var1 = (WorldServer)world;
        Entity var2 = var0.getEntity();
        Entity var3 = this.getOwner();
        if (var3 instanceof EntityLiving) {
            var5 = (EntityLiving)var3;
            DamageSource var6 = this.damageSources().witherSkull(this, var5);
            var4 = var2.hurtServer(var1, var6, 8.0f);
            if (var4) {
                if (var2.isAlive()) {
                    EnchantmentManager.doPostAttackEffects(var1, var2, var6);
                } else {
                    var5.heal(5.0f);
                }
            }
        } else {
            var4 = var2.hurtServer(var1, this.damageSources().magic(), 5.0f);
        }
        if (var4 && var2 instanceof EntityLiving) {
            var5 = (EntityLiving)var2;
            int var6 = 0;
            if (this.level().getDifficulty() == EnumDifficulty.NORMAL) {
                var6 = 10;
            } else if (this.level().getDifficulty() == EnumDifficulty.HARD) {
                var6 = 40;
            }
            if (var6 > 0) {
                var5.addEffect(new MobEffect(MobEffects.WITHER, 20 * var6, 1), this.getEffectSource());
            }
        }
    }

    @Override
    protected void onHit(MovingObjectPosition var0) {
        super.onHit(var0);
        if (!this.level().isClientSide()) {
            this.level().explode((Entity)this, this.getX(), this.getY(), this.getZ(), 1.0f, false, World.a.MOB);
            this.discard();
        }
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        var0.define(DATA_DANGEROUS, false);
    }

    public boolean isDangerous() {
        return this.entityData.get(DATA_DANGEROUS);
    }

    public void setDangerous(boolean var0) {
        this.entityData.set(DATA_DANGEROUS, var0);
    }

    @Override
    protected boolean shouldBurn() {
        return false;
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput var0) {
        super.addAdditionalSaveData(var0);
        var0.putBoolean("dangerous", this.isDangerous());
    }

    @Override
    protected void readAdditionalSaveData(ValueInput var0) {
        super.readAdditionalSaveData(var0);
        this.setDangerous(var0.getBooleanOr("dangerous", false));
    }
}

