/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.variant;

import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SystemUtils;

public interface PriorityProvider<Context, Condition extends b<Context>> {
    public List<a<Context, Condition>> selectors();

    public static <C, T> Stream<T> select(Stream<T> var0, Function<T, PriorityProvider<C, ?>> var1, C var22) {
        ArrayList var3 = new ArrayList();
        var0.forEach(var2 -> {
            PriorityProvider var3 = (PriorityProvider)var1.apply(var2);
            for (a var5 : var3.selectors()) {
                var3.add(new c(var2, var5.priority(), (b)DataFixUtils.orElseGet(var5.condition(), b::alwaysTrue)));
            }
        });
        var3.sort(c.HIGHEST_PRIORITY_FIRST);
        Iterator var4 = var3.iterator();
        int var5 = Integer.MIN_VALUE;
        while (var4.hasNext()) {
            c var6 = (c)var4.next();
            if (var6.priority < var5) {
                var4.remove();
                continue;
            }
            if (var6.condition.test(var22)) {
                var5 = var6.priority;
                continue;
            }
            var4.remove();
        }
        return var3.stream().map(c::entry);
    }

    public static <C, T> Optional<T> pick(Stream<T> var0, Function<T, PriorityProvider<C, ?>> var1, RandomSource var2, C var3) {
        List<T> var4 = PriorityProvider.select(var0, var1, var3).toList();
        return SystemUtils.getRandomSafe(var4, var2);
    }

    public static <Context, Condition extends b<Context>> List<a<Context, Condition>> single(Condition var0, int var1) {
        return List.of(new a(var0, var1));
    }

    public static <Context, Condition extends b<Context>> List<a<Context, Condition>> alwaysTrue(int var0) {
        return List.of(new a(Optional.empty(), var0));
    }

    public static final class c<C, T>
    extends Record {
        private final T entry;
        final int priority;
        final b<C> condition;
        public static final Comparator<c<?, ?>> HIGHEST_PRIORITY_FIRST = Comparator.comparingInt(c::priority).reversed();

        public c(T var0, int var1, b<C> var2) {
            this.entry = var0;
            this.priority = var1;
            this.condition = var2;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "entry;priority;condition", "entry", "priority", "condition"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "entry;priority;condition", "entry", "priority", "condition"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "entry;priority;condition", "entry", "priority", "condition"}, this, var0);
        }

        public T entry() {
            return this.entry;
        }

        public int priority() {
            return this.priority;
        }

        public b<C> condition() {
            return this.condition;
        }
    }

    @FunctionalInterface
    public static interface b<C>
    extends Predicate<C> {
        public static <C> b<C> alwaysTrue() {
            return var0 -> true;
        }
    }

    public record a<Context, Condition extends b<Context>>(Optional<Condition> condition, int priority) {
        public a(Condition var0, int var1) {
            this(Optional.of(var0), var1);
        }

        public a(int var0) {
            this(Optional.empty(), var0);
        }

        public static <Context, Condition extends b<Context>> Codec<a<Context, Condition>> codec(Codec<Condition> var0) {
            return RecordCodecBuilder.create(var1 -> var1.group((App)var0.optionalFieldOf("condition").forGetter(a::condition), (App)Codec.INT.fieldOf("priority").forGetter(a::priority)).apply((Applicative)var1, a::new));
        }
    }
}

