/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.food;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.food.FoodConstants;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.component.ConsumableListener;
import net.minecraft.world.level.World;

public record FoodInfo(int nutrition, float saturation, boolean canAlwaysEat) implements ConsumableListener
{
    public static final Codec<FoodInfo> DIRECT_CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("nutrition").forGetter(FoodInfo::nutrition), (App)Codec.FLOAT.fieldOf("saturation").forGetter(FoodInfo::saturation), (App)Codec.BOOL.optionalFieldOf("can_always_eat", (Object)false).forGetter(FoodInfo::canAlwaysEat)).apply((Applicative)var0, FoodInfo::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, FoodInfo> DIRECT_STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.VAR_INT, FoodInfo::nutrition, ByteBufCodecs.FLOAT, FoodInfo::saturation, ByteBufCodecs.BOOL, FoodInfo::canAlwaysEat, FoodInfo::new);

    @Override
    public void onConsume(World var0, EntityLiving var1, ItemStack var2, Consumable var3) {
        RandomSource var4 = var1.getRandom();
        var0.playSound(null, var1.getX(), var1.getY(), var1.getZ(), var3.sound().value(), SoundCategory.NEUTRAL, 1.0f, var4.triangle(1.0f, 0.4f));
        if (var1 instanceof EntityHuman) {
            EntityHuman var5 = (EntityHuman)var1;
            var5.getFoodData().eat(this);
            var0.playSound(null, var5.getX(), var5.getY(), var5.getZ(), SoundEffects.PLAYER_BURP, SoundCategory.PLAYERS, 0.5f, MathHelper.randomBetween(var4, 0.9f, 1.0f));
        }
    }

    public static class a {
        private int nutrition;
        private float saturationModifier;
        private boolean canAlwaysEat;

        public a nutrition(int var0) {
            this.nutrition = var0;
            return this;
        }

        public a saturationModifier(float var0) {
            this.saturationModifier = var0;
            return this;
        }

        public a alwaysEdible() {
            this.canAlwaysEat = true;
            return this;
        }

        public FoodInfo build() {
            float var0 = FoodConstants.saturationByModifier(this.nutrition, this.saturationModifier);
            return new FoodInfo(this.nutrition, var0, this.canAlwaysEat);
        }
    }
}

