/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import net.minecraft.world.IInventory;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class ContainerHopper
extends Container {
    public static final int CONTAINER_SIZE = 5;
    private final IInventory hopper;

    public ContainerHopper(int var0, PlayerInventory var1) {
        this(var0, var1, new InventorySubcontainer(5));
    }

    public ContainerHopper(int var0, PlayerInventory var1, IInventory var2) {
        super(Containers.HOPPER, var0);
        this.hopper = var2;
        ContainerHopper.checkContainerSize(var2, 5);
        var2.startOpen(var1.player);
        for (int var3 = 0; var3 < 5; ++var3) {
            this.addSlot(new Slot(var2, var3, 44 + var3 * 18, 20));
        }
        this.addStandardInventorySlots(var1, 8, 51);
    }

    @Override
    public boolean stillValid(EntityHuman var0) {
        return this.hopper.stillValid(var0);
    }

    @Override
    public ItemStack quickMoveStack(EntityHuman var0, int var1) {
        ItemStack var2 = ItemStack.EMPTY;
        Slot var3 = (Slot)this.slots.get(var1);
        if (var3 != null && var3.hasItem()) {
            ItemStack var4 = var3.getItem();
            var2 = var4.copy();
            if (var1 < this.hopper.getContainerSize() ? !this.moveItemStackTo(var4, this.hopper.getContainerSize(), this.slots.size(), true) : !this.moveItemStackTo(var4, 0, this.hopper.getContainerSize(), false)) {
                return ItemStack.EMPTY;
            }
            if (var4.isEmpty()) {
                var3.setByPlayer(ItemStack.EMPTY);
            } else {
                var3.setChanged();
            }
        }
        return var2;
    }

    @Override
    public void removed(EntityHuman var0) {
        super.removed(var0);
        this.hopper.stopOpen(var0);
    }
}

