/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import net.minecraft.resources.MinecraftKey;
import net.minecraft.tags.TagsEntity;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.animal.equine.EntityHorseAbstract;
import net.minecraft.world.entity.animal.equine.EntityLlama;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.AbstractMountInventoryMenu;
import net.minecraft.world.inventory.ArmorSlot;
import net.minecraft.world.inventory.Slot;

public class ContainerHorse
extends AbstractMountInventoryMenu {
    private static final MinecraftKey SADDLE_SLOT_SPRITE = MinecraftKey.withDefaultNamespace("container/slot/saddle");
    private static final MinecraftKey LLAMA_ARMOR_SLOT_SPRITE = MinecraftKey.withDefaultNamespace("container/slot/llama_armor");
    private static final MinecraftKey ARMOR_SLOT_SPRITE = MinecraftKey.withDefaultNamespace("container/slot/horse_armor");

    public ContainerHorse(int var0, PlayerInventory var1, IInventory var2, final EntityHorseAbstract var3, int var4) {
        super(var0, var1, var2, var3);
        IInventory var5 = var3.createEquipmentSlotContainer(EnumItemSlot.SADDLE);
        this.addSlot(new ArmorSlot(this, var5, var3, EnumItemSlot.SADDLE, 0, 8, 18, SADDLE_SLOT_SPRITE){

            @Override
            public boolean isActive() {
                return var3.canUseSlot(EnumItemSlot.SADDLE) && var3.getType().is(TagsEntity.CAN_EQUIP_SADDLE);
            }
        });
        final boolean var6 = var3 instanceof EntityLlama;
        MinecraftKey var7 = var6 ? LLAMA_ARMOR_SLOT_SPRITE : ARMOR_SLOT_SPRITE;
        IInventory var8 = var3.createEquipmentSlotContainer(EnumItemSlot.BODY);
        this.addSlot(new ArmorSlot(this, var8, var3, EnumItemSlot.BODY, 0, 8, 36, var7){

            @Override
            public boolean isActive() {
                return var3.canUseSlot(EnumItemSlot.BODY) && (var3.getType().is(TagsEntity.CAN_WEAR_HORSE_ARMOR) || var6);
            }
        });
        if (var4 > 0) {
            for (int var9 = 0; var9 < 3; ++var9) {
                for (int var10 = 0; var10 < var4; ++var10) {
                    this.addSlot(new Slot(var2, var10 + var9 * var4, 80 + var10 * 18, 18 + var9 * 18));
                }
            }
        }
        this.addStandardInventorySlots(var1, 8, 84);
    }

    @Override
    protected boolean hasInventoryChanged(IInventory var0) {
        return ((EntityHorseAbstract)this.mount).hasInventoryChanged(var0);
    }
}

