/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.EnumChatFormat;
import net.minecraft.advancements.criterion.CriterionConditionBlock;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.level.storage.TagValueOutput;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class AdventureModePredicate {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Codec<AdventureModePredicate> CODEC = ExtraCodecs.compactListCodec(CriterionConditionBlock.CODEC, ExtraCodecs.nonEmptyList(CriterionConditionBlock.CODEC.listOf())).xmap(AdventureModePredicate::new, var0 -> var0.predicates);
    public static final StreamCodec<RegistryFriendlyByteBuf, AdventureModePredicate> STREAM_CODEC = StreamCodec.composite(CriterionConditionBlock.STREAM_CODEC.apply(ByteBufCodecs.list()), var0 -> var0.predicates, AdventureModePredicate::new);
    public static final IChatBaseComponent CAN_BREAK_HEADER = IChatBaseComponent.translatable("item.canBreak").withStyle(EnumChatFormat.GRAY);
    public static final IChatBaseComponent CAN_PLACE_HEADER = IChatBaseComponent.translatable("item.canPlace").withStyle(EnumChatFormat.GRAY);
    private static final IChatBaseComponent UNKNOWN_USE = IChatBaseComponent.translatable("item.canUse.unknown").withStyle(EnumChatFormat.GRAY);
    private final List<CriterionConditionBlock> predicates;
    private @Nullable List<IChatBaseComponent> cachedTooltip;
    private @Nullable ShapeDetectorBlock lastCheckedBlock;
    private boolean lastResult;
    private boolean checksBlockEntity;

    public AdventureModePredicate(List<CriterionConditionBlock> var0) {
        this.predicates = var0;
    }

    private static boolean areSameBlocks(ShapeDetectorBlock var0, @Nullable ShapeDetectorBlock var1, boolean var2) {
        if (var1 == null || var0.getState() != var1.getState()) {
            return false;
        }
        if (!var2) {
            return true;
        }
        if (var0.getEntity() == null && var1.getEntity() == null) {
            return true;
        }
        if (var0.getEntity() == null || var1.getEntity() == null) {
            return false;
        }
        try (ProblemReporter.j var3 = new ProblemReporter.j(LOGGER);){
            IRegistryCustom var4 = var0.getLevel().registryAccess();
            NBTTagCompound var5 = AdventureModePredicate.saveBlockEntity(var0.getEntity(), var4, var3);
            NBTTagCompound var6 = AdventureModePredicate.saveBlockEntity(var1.getEntity(), var4, var3);
            boolean bl = Objects.equals(var5, var6);
            return bl;
        }
    }

    private static NBTTagCompound saveBlockEntity(TileEntity var0, IRegistryCustom var1, ProblemReporter var2) {
        TagValueOutput var3 = TagValueOutput.createWithContext(var2.forChild(var0.problemPath()), var1);
        var0.saveWithId(var3);
        return var3.buildResult();
    }

    public boolean test(ShapeDetectorBlock var0) {
        if (AdventureModePredicate.areSameBlocks(var0, this.lastCheckedBlock, this.checksBlockEntity)) {
            return this.lastResult;
        }
        this.lastCheckedBlock = var0;
        this.checksBlockEntity = false;
        for (CriterionConditionBlock var2 : this.predicates) {
            if (!var2.matches(var0)) continue;
            this.checksBlockEntity |= var2.requiresNbt();
            this.lastResult = true;
            return true;
        }
        this.lastResult = false;
        return false;
    }

    private List<IChatBaseComponent> tooltip() {
        if (this.cachedTooltip == null) {
            this.cachedTooltip = AdventureModePredicate.computeTooltip(this.predicates);
        }
        return this.cachedTooltip;
    }

    public void addToTooltip(Consumer<IChatBaseComponent> var0) {
        this.tooltip().forEach(var0);
    }

    private static List<IChatBaseComponent> computeTooltip(List<CriterionConditionBlock> var02) {
        for (CriterionConditionBlock var2 : var02) {
            if (!var2.blocks().isEmpty()) continue;
            return List.of(UNKNOWN_USE);
        }
        return var02.stream().flatMap(var0 -> var0.blocks().orElseThrow().stream()).distinct().map(var0 -> ((Block)var0.value()).getName().withStyle(EnumChatFormat.DARK_GRAY)).toList();
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (var0 instanceof AdventureModePredicate) {
            AdventureModePredicate var1 = (AdventureModePredicate)var0;
            return this.predicates.equals(var1.predicates);
        }
        return false;
    }

    public int hashCode() {
        return this.predicates.hashCode();
    }

    public String toString() {
        return "AdventureModePredicate{predicates=" + String.valueOf(this.predicates) + "}";
    }
}

