/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.component.InstrumentComponent;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;

public class InstrumentItem
extends Item {
    public InstrumentItem(Item.Info var0) {
        super(var0);
    }

    public static ItemStack create(Item var0, Holder<Instrument> var1) {
        ItemStack var2 = new ItemStack(var0);
        var2.set(DataComponents.INSTRUMENT, new InstrumentComponent(var1));
        return var2;
    }

    @Override
    public EnumInteractionResult use(World var0, EntityHuman var1, EnumHand var2) {
        ItemStack var3 = var1.getItemInHand(var2);
        Optional<Holder<Instrument>> var4 = this.getInstrument(var3, var1.registryAccess());
        if (var4.isPresent()) {
            Instrument var5 = var4.get().value();
            var1.startUsingItem(var2);
            InstrumentItem.play(var0, var1, var5);
            var1.getCooldowns().addCooldown(var3, MathHelper.floor(var5.useDuration() * 20.0f));
            var1.awardStat(StatisticList.ITEM_USED.get(this));
            return EnumInteractionResult.CONSUME;
        }
        return EnumInteractionResult.FAIL;
    }

    @Override
    public int getUseDuration(ItemStack var02, EntityLiving var1) {
        Optional<Holder<Instrument>> var2 = this.getInstrument(var02, var1.registryAccess());
        return var2.map(var0 -> MathHelper.floor(((Instrument)var0.value()).useDuration() * 20.0f)).orElse(0);
    }

    private Optional<Holder<Instrument>> getInstrument(ItemStack var0, HolderLookup.a var1) {
        InstrumentComponent var2 = var0.get(DataComponents.INSTRUMENT);
        return var2 != null ? var2.unwrap(var1) : Optional.empty();
    }

    @Override
    public ItemUseAnimation getUseAnimation(ItemStack var0) {
        return ItemUseAnimation.TOOT_HORN;
    }

    private static void play(World var0, EntityHuman var1, Instrument var2) {
        SoundEffect var3 = var2.soundEvent().value();
        float var4 = var2.range() / 16.0f;
        var0.playSound((Entity)var1, var1, var3, SoundCategory.RECORDS, var4, 1.0f);
        var0.gameEvent(GameEvent.INSTRUMENT_PLAY, var1.position(), GameEvent.a.of(var1));
    }
}

