/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.LodestoneTracker;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import org.jspecify.annotations.Nullable;

public class ItemCompass
extends Item {
    private static final IChatBaseComponent LODESTONE_COMPASS_NAME = IChatBaseComponent.translatable("item.minecraft.lodestone_compass");

    public ItemCompass(Item.Info var0) {
        super(var0);
    }

    @Override
    public boolean isFoil(ItemStack var0) {
        return var0.has(DataComponents.LODESTONE_TRACKER) || super.isFoil(var0);
    }

    @Override
    public void inventoryTick(ItemStack var0, WorldServer var1, Entity var2, @Nullable EnumItemSlot var3) {
        LodestoneTracker var5;
        LodestoneTracker var4 = var0.get(DataComponents.LODESTONE_TRACKER);
        if (var4 != null && (var5 = var4.tick(var1)) != var4) {
            var0.set(DataComponents.LODESTONE_TRACKER, var5);
        }
    }

    @Override
    public EnumInteractionResult useOn(ItemActionContext var0) {
        BlockPosition var1 = var0.getClickedPos();
        World var2 = var0.getLevel();
        if (var2.getBlockState(var1).is(Blocks.LODESTONE)) {
            var2.playSound(null, var1, SoundEffects.LODESTONE_COMPASS_LOCK, SoundCategory.PLAYERS, 1.0f, 1.0f);
            EntityHuman var3 = var0.getPlayer();
            ItemStack var4 = var0.getItemInHand();
            boolean var5 = !var3.hasInfiniteMaterials() && var4.getCount() == 1;
            LodestoneTracker var6 = new LodestoneTracker(Optional.of(GlobalPos.of(var2.dimension(), var1)), true);
            if (var5) {
                var4.set(DataComponents.LODESTONE_TRACKER, var6);
            } else {
                ItemStack var7 = var4.transmuteCopy(Items.COMPASS, 1);
                var4.consume(1, var3);
                var7.set(DataComponents.LODESTONE_TRACKER, var6);
                if (!var3.getInventory().add(var7)) {
                    var3.drop(var7, false);
                }
            }
            return EnumInteractionResult.SUCCESS;
        }
        return super.useOn(var0);
    }

    @Override
    public IChatBaseComponent getName(ItemStack var0) {
        return var0.has(DataComponents.LODESTONE_TRACKER) ? LODESTONE_COMPASS_NAME : super.getName(var0);
    }
}

