/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.EnumDirection;
import net.minecraft.network.protocol.game.PacketPlayOutEntityVelocity;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.Vec3D;
import org.jspecify.annotations.Nullable;

public class MaceItem
extends Item {
    private static final int DEFAULT_ATTACK_DAMAGE = 5;
    private static final float DEFAULT_ATTACK_SPEED = -3.4f;
    public static final float SMASH_ATTACK_FALL_THRESHOLD = 1.5f;
    private static final float SMASH_ATTACK_HEAVY_THRESHOLD = 5.0f;
    public static final float SMASH_ATTACK_KNOCKBACK_RADIUS = 3.5f;
    private static final float SMASH_ATTACK_KNOCKBACK_POWER = 0.7f;

    public MaceItem(Item.Info var0) {
        super(var0);
    }

    public static ItemAttributeModifiers createAttributes() {
        return ItemAttributeModifiers.builder().add(GenericAttributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, 5.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(GenericAttributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, -3.4f, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    public static Tool createToolProperties() {
        return new Tool(List.of(), 1.0f, 2, false);
    }

    @Override
    public void hurtEnemy(ItemStack var0, EntityLiving var1, EntityLiving var2) {
        if (MaceItem.canSmashAttack(var2)) {
            Object var4;
            WorldServer var3 = (WorldServer)var2.level();
            var2.setDeltaMovement(var2.getDeltaMovement().with(EnumDirection.EnumAxis.Y, 0.01f));
            if (var2 instanceof EntityPlayer) {
                var4 = (EntityPlayer)var2;
                ((EntityPlayer)var4).currentImpulseImpactPos = this.calculateImpactPosition((EntityPlayer)var4);
                ((EntityHuman)var4).setIgnoreFallDamageFromCurrentImpulse(true);
                ((EntityPlayer)var4).connection.send(new PacketPlayOutEntityVelocity((Entity)var4));
            }
            if (var1.onGround()) {
                if (var2 instanceof EntityPlayer) {
                    var4 = (EntityPlayer)var2;
                    ((EntityPlayer)var4).setSpawnExtraParticlesOnFall(true);
                }
                var4 = var2.fallDistance > 5.0 ? SoundEffects.MACE_SMASH_GROUND_HEAVY : SoundEffects.MACE_SMASH_GROUND;
                var3.playSound(null, var2.getX(), var2.getY(), var2.getZ(), (SoundEffect)var4, var2.getSoundSource(), 1.0f, 1.0f);
            } else {
                var3.playSound(null, var2.getX(), var2.getY(), var2.getZ(), SoundEffects.MACE_SMASH_AIR, var2.getSoundSource(), 1.0f, 1.0f);
            }
            MaceItem.knockback(var3, var2, var1);
        }
    }

    private Vec3D calculateImpactPosition(EntityPlayer var0) {
        if (var0.isIgnoringFallDamageFromCurrentImpulse() && var0.currentImpulseImpactPos != null && var0.currentImpulseImpactPos.y <= var0.position().y) {
            return var0.currentImpulseImpactPos;
        }
        return var0.position();
    }

    @Override
    public void postHurtEnemy(ItemStack var0, EntityLiving var1, EntityLiving var2) {
        if (MaceItem.canSmashAttack(var2)) {
            var2.resetFallDistance();
        }
    }

    @Override
    public float getAttackDamageBonus(Entity var0, float var1, DamageSource var2) {
        Entity entity = var2.getDirectEntity();
        if (!(entity instanceof EntityLiving)) {
            return 0.0f;
        }
        EntityLiving var3 = (EntityLiving)entity;
        if (!MaceItem.canSmashAttack(var3)) {
            return 0.0f;
        }
        double var4 = 3.0;
        double var6 = 8.0;
        double var8 = var3.fallDistance;
        double var10 = var8 <= 3.0 ? 4.0 * var8 : (var8 <= 8.0 ? 12.0 + 2.0 * (var8 - 3.0) : 22.0 + var8 - 8.0);
        World world = var3.level();
        if (world instanceof WorldServer) {
            WorldServer var12 = (WorldServer)world;
            return (float)(var10 + (double)EnchantmentManager.modifyFallBasedDamage(var12, var3.getWeaponItem(), var0, var2, 0.0f) * var8);
        }
        return (float)var10;
    }

    private static void knockback(World var0, Entity var1, Entity var22) {
        var0.levelEvent(2013, var22.getOnPos(), 750);
        var0.getEntitiesOfClass(EntityLiving.class, var22.getBoundingBox().inflate(3.5), MaceItem.knockbackPredicate(var1, var22)).forEach(var2 -> {
            Vec3D var3 = var2.position().subtract(var22.position());
            double var4 = MaceItem.getKnockbackPower(var1, var2, var3);
            Vec3D var6 = var3.normalize().scale(var4);
            if (var4 > 0.0) {
                var2.push(var6.x, 0.7f, var6.z);
                if (var2 instanceof EntityPlayer) {
                    EntityPlayer var7 = (EntityPlayer)var2;
                    var7.connection.send(new PacketPlayOutEntityVelocity(var7));
                }
            }
        });
    }

    private static Predicate<EntityLiving> knockbackPredicate(Entity var0, Entity var1) {
        return arg_0 -> MaceItem.a(var0, var1, arg_0);
    }

    private static double getKnockbackPower(Entity var0, EntityLiving var1, Vec3D var2) {
        return (3.5 - var2.length()) * (double)0.7f * (double)(var0.fallDistance > 5.0 ? 2 : 1) * (1.0 - var1.getAttributeValue(GenericAttributes.KNOCKBACK_RESISTANCE));
    }

    public static boolean canSmashAttack(EntityLiving var0) {
        return var0.fallDistance > 1.5 && !var0.isFallFlying();
    }

    @Override
    public @Nullable DamageSource getItemDamageSource(EntityLiving var0) {
        if (MaceItem.canSmashAttack(var0)) {
            return var0.damageSources().mace(var0);
        }
        return super.getItemDamageSource(var0);
    }

    /*
     * Unable to fully structure code
     */
    private static /* synthetic */ boolean a(Entity var0, Entity var1, EntityLiving var2) {
        var3 = var2.isSpectator() == false;
        var4 = var2 != var0 && var2 != var1;
        v0 = var5 = var0.isAlliedTo(var2) == false;
        if (!(var2 instanceof EntityTameableAnimal)) ** GOTO lbl-1000
        var8 = (EntityTameableAnimal)var2;
        if (!(var1 instanceof EntityLiving)) ** GOTO lbl-1000
        var7 = (EntityLiving)var1;
        if (var8.isTame() && var8.isOwnedBy(var7)) {
            v1 = true;
        } else lbl-1000:
        // 3 sources

        {
            v1 = false;
        }
        var6 = v1 == false;
        var7 = var2 instanceof EntityArmorStand == false || (var8 = (EntityArmorStand)var2).isMarker() == false;
        var8 = var1.distanceToSqr(var2) <= Math.pow(3.5, 2.0);
        var9 = (var2 instanceof EntityHuman != false && (var10 = (EntityHuman)var2).isCreative() != false && var10.getAbilities().flying != false) == false;
        return var3 != false && var4 != false && var5 != false && var6 != false && var7 != false && var8 != false && var9 != false;
    }
}

