/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.EnumChatFormat;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;

public class SmithingTemplateItem
extends Item {
    private static final EnumChatFormat TITLE_FORMAT = EnumChatFormat.GRAY;
    private static final EnumChatFormat DESCRIPTION_FORMAT = EnumChatFormat.BLUE;
    private static final IChatBaseComponent INGREDIENTS_TITLE = IChatBaseComponent.translatable(SystemUtils.makeDescriptionId("item", MinecraftKey.withDefaultNamespace("smithing_template.ingredients"))).withStyle(TITLE_FORMAT);
    private static final IChatBaseComponent APPLIES_TO_TITLE = IChatBaseComponent.translatable(SystemUtils.makeDescriptionId("item", MinecraftKey.withDefaultNamespace("smithing_template.applies_to"))).withStyle(TITLE_FORMAT);
    private static final IChatBaseComponent SMITHING_TEMPLATE_SUFFIX = IChatBaseComponent.translatable(SystemUtils.makeDescriptionId("item", MinecraftKey.withDefaultNamespace("smithing_template"))).withStyle(TITLE_FORMAT);
    private static final IChatBaseComponent ARMOR_TRIM_APPLIES_TO = IChatBaseComponent.translatable(SystemUtils.makeDescriptionId("item", MinecraftKey.withDefaultNamespace("smithing_template.armor_trim.applies_to"))).withStyle(DESCRIPTION_FORMAT);
    private static final IChatBaseComponent ARMOR_TRIM_INGREDIENTS = IChatBaseComponent.translatable(SystemUtils.makeDescriptionId("item", MinecraftKey.withDefaultNamespace("smithing_template.armor_trim.ingredients"))).withStyle(DESCRIPTION_FORMAT);
    private static final IChatBaseComponent ARMOR_TRIM_BASE_SLOT_DESCRIPTION = IChatBaseComponent.translatable(SystemUtils.makeDescriptionId("item", MinecraftKey.withDefaultNamespace("smithing_template.armor_trim.base_slot_description")));
    private static final IChatBaseComponent ARMOR_TRIM_ADDITIONS_SLOT_DESCRIPTION = IChatBaseComponent.translatable(SystemUtils.makeDescriptionId("item", MinecraftKey.withDefaultNamespace("smithing_template.armor_trim.additions_slot_description")));
    private static final IChatBaseComponent NETHERITE_UPGRADE_APPLIES_TO = IChatBaseComponent.translatable(SystemUtils.makeDescriptionId("item", MinecraftKey.withDefaultNamespace("smithing_template.netherite_upgrade.applies_to"))).withStyle(DESCRIPTION_FORMAT);
    private static final IChatBaseComponent NETHERITE_UPGRADE_INGREDIENTS = IChatBaseComponent.translatable(SystemUtils.makeDescriptionId("item", MinecraftKey.withDefaultNamespace("smithing_template.netherite_upgrade.ingredients"))).withStyle(DESCRIPTION_FORMAT);
    private static final IChatBaseComponent NETHERITE_UPGRADE_BASE_SLOT_DESCRIPTION = IChatBaseComponent.translatable(SystemUtils.makeDescriptionId("item", MinecraftKey.withDefaultNamespace("smithing_template.netherite_upgrade.base_slot_description")));
    private static final IChatBaseComponent NETHERITE_UPGRADE_ADDITIONS_SLOT_DESCRIPTION = IChatBaseComponent.translatable(SystemUtils.makeDescriptionId("item", MinecraftKey.withDefaultNamespace("smithing_template.netherite_upgrade.additions_slot_description")));
    private static final MinecraftKey EMPTY_SLOT_HELMET = MinecraftKey.withDefaultNamespace("container/slot/helmet");
    private static final MinecraftKey EMPTY_SLOT_CHESTPLATE = MinecraftKey.withDefaultNamespace("container/slot/chestplate");
    private static final MinecraftKey EMPTY_SLOT_LEGGINGS = MinecraftKey.withDefaultNamespace("container/slot/leggings");
    private static final MinecraftKey EMPTY_SLOT_BOOTS = MinecraftKey.withDefaultNamespace("container/slot/boots");
    private static final MinecraftKey EMPTY_SLOT_HOE = MinecraftKey.withDefaultNamespace("container/slot/hoe");
    private static final MinecraftKey EMPTY_SLOT_AXE = MinecraftKey.withDefaultNamespace("container/slot/axe");
    private static final MinecraftKey EMPTY_SLOT_SWORD = MinecraftKey.withDefaultNamespace("container/slot/sword");
    private static final MinecraftKey EMPTY_SLOT_SHOVEL = MinecraftKey.withDefaultNamespace("container/slot/shovel");
    private static final MinecraftKey EMPTY_SLOT_SPEAR = MinecraftKey.withDefaultNamespace("container/slot/spear");
    private static final MinecraftKey EMPTY_SLOT_PICKAXE = MinecraftKey.withDefaultNamespace("container/slot/pickaxe");
    private static final MinecraftKey EMPTY_SLOT_INGOT = MinecraftKey.withDefaultNamespace("container/slot/ingot");
    private static final MinecraftKey EMPTY_SLOT_REDSTONE_DUST = MinecraftKey.withDefaultNamespace("container/slot/redstone_dust");
    private static final MinecraftKey EMPTY_SLOT_QUARTZ = MinecraftKey.withDefaultNamespace("container/slot/quartz");
    private static final MinecraftKey EMPTY_SLOT_EMERALD = MinecraftKey.withDefaultNamespace("container/slot/emerald");
    private static final MinecraftKey EMPTY_SLOT_DIAMOND = MinecraftKey.withDefaultNamespace("container/slot/diamond");
    private static final MinecraftKey EMPTY_SLOT_LAPIS_LAZULI = MinecraftKey.withDefaultNamespace("container/slot/lapis_lazuli");
    private static final MinecraftKey EMPTY_SLOT_AMETHYST_SHARD = MinecraftKey.withDefaultNamespace("container/slot/amethyst_shard");
    private static final MinecraftKey EMPTY_SLOT_NAUTILUS_ARMOR = MinecraftKey.withDefaultNamespace("container/slot/nautilus_armor");
    private final IChatBaseComponent appliesTo;
    private final IChatBaseComponent ingredients;
    private final IChatBaseComponent baseSlotDescription;
    private final IChatBaseComponent additionsSlotDescription;
    private final List<MinecraftKey> baseSlotEmptyIcons;
    private final List<MinecraftKey> additionalSlotEmptyIcons;

    public SmithingTemplateItem(IChatBaseComponent var0, IChatBaseComponent var1, IChatBaseComponent var2, IChatBaseComponent var3, List<MinecraftKey> var4, List<MinecraftKey> var5, Item.Info var6) {
        super(var6);
        this.appliesTo = var0;
        this.ingredients = var1;
        this.baseSlotDescription = var2;
        this.additionsSlotDescription = var3;
        this.baseSlotEmptyIcons = var4;
        this.additionalSlotEmptyIcons = var5;
    }

    public static SmithingTemplateItem createArmorTrimTemplate(Item.Info var0) {
        return new SmithingTemplateItem(ARMOR_TRIM_APPLIES_TO, ARMOR_TRIM_INGREDIENTS, ARMOR_TRIM_BASE_SLOT_DESCRIPTION, ARMOR_TRIM_ADDITIONS_SLOT_DESCRIPTION, SmithingTemplateItem.createTrimmableArmorIconList(), SmithingTemplateItem.createTrimmableMaterialIconList(), var0);
    }

    public static SmithingTemplateItem createNetheriteUpgradeTemplate(Item.Info var0) {
        return new SmithingTemplateItem(NETHERITE_UPGRADE_APPLIES_TO, NETHERITE_UPGRADE_INGREDIENTS, NETHERITE_UPGRADE_BASE_SLOT_DESCRIPTION, NETHERITE_UPGRADE_ADDITIONS_SLOT_DESCRIPTION, SmithingTemplateItem.createNetheriteUpgradeIconList(), SmithingTemplateItem.createNetheriteUpgradeMaterialList(), var0);
    }

    private static List<MinecraftKey> createTrimmableArmorIconList() {
        return List.of(EMPTY_SLOT_HELMET, EMPTY_SLOT_CHESTPLATE, EMPTY_SLOT_LEGGINGS, EMPTY_SLOT_BOOTS);
    }

    private static List<MinecraftKey> createTrimmableMaterialIconList() {
        return List.of(EMPTY_SLOT_INGOT, EMPTY_SLOT_REDSTONE_DUST, EMPTY_SLOT_LAPIS_LAZULI, EMPTY_SLOT_QUARTZ, EMPTY_SLOT_DIAMOND, EMPTY_SLOT_EMERALD, EMPTY_SLOT_AMETHYST_SHARD);
    }

    private static List<MinecraftKey> createNetheriteUpgradeIconList() {
        return List.of(EMPTY_SLOT_HELMET, EMPTY_SLOT_SWORD, EMPTY_SLOT_CHESTPLATE, EMPTY_SLOT_PICKAXE, EMPTY_SLOT_LEGGINGS, EMPTY_SLOT_AXE, EMPTY_SLOT_BOOTS, EMPTY_SLOT_HOE, EMPTY_SLOT_SHOVEL, EMPTY_SLOT_NAUTILUS_ARMOR, EMPTY_SLOT_SPEAR);
    }

    private static List<MinecraftKey> createNetheriteUpgradeMaterialList() {
        return List.of(EMPTY_SLOT_INGOT);
    }

    @Override
    public void appendHoverText(ItemStack var0, Item.b var1, TooltipDisplay var2, Consumer<IChatBaseComponent> var3, TooltipFlag var4) {
        var3.accept(SMITHING_TEMPLATE_SUFFIX);
        var3.accept(CommonComponents.EMPTY);
        var3.accept(APPLIES_TO_TITLE);
        var3.accept(CommonComponents.space().append(this.appliesTo));
        var3.accept(INGREDIENTS_TITLE);
        var3.accept(CommonComponents.space().append(this.ingredients));
    }

    public IChatBaseComponent getBaseSlotDescription() {
        return this.baseSlotDescription;
    }

    public IChatBaseComponent getAdditionSlotDescription() {
        return this.additionsSlotDescription;
    }

    public List<MinecraftKey> getBaseSlotEmptyIcons() {
        return this.baseSlotEmptyIcons;
    }

    public List<MinecraftKey> getAdditionalSlotEmptyIcons() {
        return this.additionalSlotEmptyIcons;
    }
}

