/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.EnumChatFormat;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.ARGB;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDye;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;

public record DyedItemColor(int rgb) implements TooltipProvider
{
    public static final Codec<DyedItemColor> CODEC = ExtraCodecs.RGB_COLOR_CODEC.xmap(DyedItemColor::new, DyedItemColor::rgb);
    public static final StreamCodec<ByteBuf, DyedItemColor> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.INT, DyedItemColor::rgb, DyedItemColor::new);
    public static final int LEATHER_COLOR = -6265536;

    public static int getOrDefault(ItemStack var0, int var1) {
        DyedItemColor var2 = var0.get(DataComponents.DYED_COLOR);
        return var2 != null ? ARGB.opaque(var2.rgb()) : var1;
    }

    public static ItemStack applyDyes(ItemStack var0, List<ItemDye> var1) {
        int var14;
        int var11;
        int var10;
        if (!var0.is(TagsItem.DYEABLE)) {
            return ItemStack.EMPTY;
        }
        ItemStack var2 = var0.copyWithCount(1);
        int var3 = 0;
        int var4 = 0;
        int var5 = 0;
        int var6 = 0;
        int var7 = 0;
        DyedItemColor var8 = var2.get(DataComponents.DYED_COLOR);
        if (var8 != null) {
            int var9 = ARGB.red(var8.rgb());
            var10 = ARGB.green(var8.rgb());
            var11 = ARGB.blue(var8.rgb());
            var6 += Math.max(var9, Math.max(var10, var11));
            var3 += var9;
            var4 += var10;
            var5 += var11;
            ++var7;
        }
        for (ItemDye var102 : var1) {
            var11 = var102.getDyeColor().getTextureDiffuseColor();
            int var12 = ARGB.red(var11);
            int var13 = ARGB.green(var11);
            var14 = ARGB.blue(var11);
            var6 += Math.max(var12, Math.max(var13, var14));
            var3 += var12;
            var4 += var13;
            var5 += var14;
            ++var7;
        }
        int var9 = var3 / var7;
        var10 = var4 / var7;
        var11 = var5 / var7;
        float var12 = (float)var6 / (float)var7;
        float var13 = Math.max(var9, Math.max(var10, var11));
        var9 = (int)((float)var9 * var12 / var13);
        var10 = (int)((float)var10 * var12 / var13);
        var11 = (int)((float)var11 * var12 / var13);
        var14 = ARGB.color(0, var9, var10, var11);
        var2.set(DataComponents.DYED_COLOR, new DyedItemColor(var14));
        return var2;
    }

    @Override
    public void addToTooltip(Item.b var0, Consumer<IChatBaseComponent> var1, TooltipFlag var2, DataComponentGetter var3) {
        if (var2.isAdvanced()) {
            var1.accept(IChatBaseComponent.translatable("item.color", String.format(Locale.ROOT, "#%06X", this.rgb)).withStyle(EnumChatFormat.GRAY));
        } else {
            var1.accept(IChatBaseComponent.translatable("item.dyed").withStyle(EnumChatFormat.GRAY, EnumChatFormat.ITALIC));
        }
    }
}

