/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import net.minecraft.EnumChatFormat;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import org.apache.commons.lang3.function.TriConsumer;
import org.jspecify.annotations.Nullable;

public record ItemAttributeModifiers(List<c> modifiers) {
    public static final ItemAttributeModifiers EMPTY = new ItemAttributeModifiers(List.of());
    public static final Codec<ItemAttributeModifiers> CODEC = c.CODEC.listOf().xmap(ItemAttributeModifiers::new, ItemAttributeModifiers::modifiers);
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemAttributeModifiers> STREAM_CODEC = StreamCodec.composite(c.STREAM_CODEC.apply(ByteBufCodecs.list()), ItemAttributeModifiers::modifiers, ItemAttributeModifiers::new);
    public static final DecimalFormat ATTRIBUTE_MODIFIER_FORMAT = new DecimalFormat("#.##", DecimalFormatSymbols.getInstance(Locale.ROOT));

    public static a builder() {
        return new a();
    }

    public ItemAttributeModifiers withModifierAdded(Holder<AttributeBase> var0, AttributeModifier var1, EquipmentSlotGroup var2) {
        ImmutableList.Builder var3 = ImmutableList.builderWithExpectedSize((int)(this.modifiers.size() + 1));
        for (c var5 : this.modifiers) {
            if (var5.matches(var0, var1.id())) continue;
            var3.add((Object)var5);
        }
        var3.add((Object)new c(var0, var1, var2));
        return new ItemAttributeModifiers((List<c>)var3.build());
    }

    public void forEach(EquipmentSlotGroup var0, TriConsumer<Holder<AttributeBase>, AttributeModifier, b> var1) {
        for (c var3 : this.modifiers) {
            if (!var3.slot.equals(var0)) continue;
            var1.accept(var3.attribute, (Object)var3.modifier, (Object)var3.display);
        }
    }

    public void forEach(EquipmentSlotGroup var0, BiConsumer<Holder<AttributeBase>, AttributeModifier> var1) {
        for (c var3 : this.modifiers) {
            if (!var3.slot.equals(var0)) continue;
            var1.accept(var3.attribute, var3.modifier);
        }
    }

    public void forEach(EnumItemSlot var0, BiConsumer<Holder<AttributeBase>, AttributeModifier> var1) {
        for (c var3 : this.modifiers) {
            if (!var3.slot.test(var0)) continue;
            var1.accept(var3.attribute, var3.modifier);
        }
    }

    public double compute(Holder<AttributeBase> var0, double var1, EnumItemSlot var3) {
        double var4 = var1;
        for (c var7 : this.modifiers) {
            if (!var7.slot.test(var3) || var7.attribute != var0) continue;
            double var8 = var7.modifier.amount();
            var4 += (switch (var7.modifier.operation()) {
                default -> throw new MatchException(null, null);
                case AttributeModifier.Operation.ADD_VALUE -> var8;
                case AttributeModifier.Operation.ADD_MULTIPLIED_BASE -> var8 * var1;
                case AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL -> var8 * var4;
            });
        }
        return var4;
    }

    public static class a {
        private final ImmutableList.Builder<c> entries = ImmutableList.builder();

        a() {
        }

        public a add(Holder<AttributeBase> var0, AttributeModifier var1, EquipmentSlotGroup var2) {
            this.entries.add((Object)new c(var0, var1, var2));
            return this;
        }

        public a add(Holder<AttributeBase> var0, AttributeModifier var1, EquipmentSlotGroup var2, b var3) {
            this.entries.add((Object)new c(var0, var1, var2, var3));
            return this;
        }

        public ItemAttributeModifiers build() {
            return new ItemAttributeModifiers((List<c>)this.entries.build());
        }
    }

    public static final class c
    extends Record {
        final Holder<AttributeBase> attribute;
        final AttributeModifier modifier;
        final EquipmentSlotGroup slot;
        final b display;
        public static final Codec<c> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)AttributeBase.CODEC.fieldOf("type").forGetter(c::attribute), (App)AttributeModifier.MAP_CODEC.forGetter(c::modifier), (App)EquipmentSlotGroup.CODEC.optionalFieldOf("slot", (Object)EquipmentSlotGroup.ANY).forGetter(c::slot), (App)b.CODEC.optionalFieldOf("display", (Object)b.a.INSTANCE).forGetter(c::display)).apply((Applicative)var0, c::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, c> STREAM_CODEC = StreamCodec.composite(AttributeBase.STREAM_CODEC, c::attribute, AttributeModifier.STREAM_CODEC, c::modifier, EquipmentSlotGroup.STREAM_CODEC, c::slot, b.STREAM_CODEC, c::display, c::new);

        public c(Holder<AttributeBase> var0, AttributeModifier var1, EquipmentSlotGroup var2) {
            this(var0, var1, var2, b.attributeModifiers());
        }

        public c(Holder<AttributeBase> var0, AttributeModifier var1, EquipmentSlotGroup var2, b var3) {
            this.attribute = var0;
            this.modifier = var1;
            this.slot = var2;
            this.display = var3;
        }

        public boolean matches(Holder<AttributeBase> var0, MinecraftKey var1) {
            return var0.equals(this.attribute) && this.modifier.is(var1);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "attribute;modifier;slot;display", "attribute", "modifier", "slot", "display"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "attribute;modifier;slot;display", "attribute", "modifier", "slot", "display"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "attribute;modifier;slot;display", "attribute", "modifier", "slot", "display"}, this, var0);
        }

        public Holder<AttributeBase> attribute() {
            return this.attribute;
        }

        public AttributeModifier modifier() {
            return this.modifier;
        }

        public EquipmentSlotGroup slot() {
            return this.slot;
        }

        public b display() {
            return this.display;
        }
    }

    public static interface net.minecraft.world.item.component.ItemAttributeModifiers$b {
        public static final Codec<net.minecraft.world.item.component.ItemAttributeModifiers$b> CODEC = d.CODEC.dispatch("type", net.minecraft.world.item.component.ItemAttributeModifiers$b::type, var0 -> var0.codec);
        public static final StreamCodec<RegistryFriendlyByteBuf, net.minecraft.world.item.component.ItemAttributeModifiers$b> STREAM_CODEC = d.STREAM_CODEC.cast().dispatch(net.minecraft.world.item.component.ItemAttributeModifiers$b::type, d::streamCodec);

        public static net.minecraft.world.item.component.ItemAttributeModifiers$b attributeModifiers() {
            return a.INSTANCE;
        }

        public static net.minecraft.world.item.component.ItemAttributeModifiers$b hidden() {
            return b.INSTANCE;
        }

        public static net.minecraft.world.item.component.ItemAttributeModifiers$b override(IChatBaseComponent var0) {
            return new c(var0);
        }

        public d type();

        public void apply(Consumer<IChatBaseComponent> var1, @Nullable EntityHuman var2, Holder<AttributeBase> var3, AttributeModifier var4);

        public record a() implements net.minecraft.world.item.component.ItemAttributeModifiers$b
        {
            static final a INSTANCE = new a();
            static final MapCodec<a> CODEC = MapCodec.unit((Object)INSTANCE);
            static final StreamCodec<RegistryFriendlyByteBuf, a> STREAM_CODEC = StreamCodec.unit(INSTANCE);

            @Override
            public d type() {
                return d.DEFAULT;
            }

            @Override
            public void apply(Consumer<IChatBaseComponent> var0, @Nullable EntityHuman var1, Holder<AttributeBase> var2, AttributeModifier var3) {
                double var4 = var3.amount();
                boolean var6 = false;
                if (var1 != null) {
                    if (var3.is(Item.BASE_ATTACK_DAMAGE_ID)) {
                        var4 += var1.getAttributeBaseValue(GenericAttributes.ATTACK_DAMAGE);
                        var6 = true;
                    } else if (var3.is(Item.BASE_ATTACK_SPEED_ID)) {
                        var4 += var1.getAttributeBaseValue(GenericAttributes.ATTACK_SPEED);
                        var6 = true;
                    }
                }
                double var7 = var3.operation() == AttributeModifier.Operation.ADD_MULTIPLIED_BASE || var3.operation() == AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL ? var4 * 100.0 : (var2.is(GenericAttributes.KNOCKBACK_RESISTANCE) ? var4 * 10.0 : var4);
                if (var6) {
                    var0.accept(CommonComponents.space().append(IChatBaseComponent.translatable("attribute.modifier.equals." + var3.operation().id(), ATTRIBUTE_MODIFIER_FORMAT.format(var7), IChatBaseComponent.translatable(var2.value().getDescriptionId()))).withStyle(EnumChatFormat.DARK_GREEN));
                } else if (var4 > 0.0) {
                    var0.accept(IChatBaseComponent.translatable("attribute.modifier.plus." + var3.operation().id(), ATTRIBUTE_MODIFIER_FORMAT.format(var7), IChatBaseComponent.translatable(var2.value().getDescriptionId())).withStyle(var2.value().getStyle(true)));
                } else if (var4 < 0.0) {
                    var0.accept(IChatBaseComponent.translatable("attribute.modifier.take." + var3.operation().id(), ATTRIBUTE_MODIFIER_FORMAT.format(-var7), IChatBaseComponent.translatable(var2.value().getDescriptionId())).withStyle(var2.value().getStyle(false)));
                }
            }
        }

        public record b() implements net.minecraft.world.item.component.ItemAttributeModifiers$b
        {
            static final b INSTANCE = new b();
            static final MapCodec<b> CODEC = MapCodec.unit((Object)INSTANCE);
            static final StreamCodec<RegistryFriendlyByteBuf, b> STREAM_CODEC = StreamCodec.unit(INSTANCE);

            @Override
            public d type() {
                return d.HIDDEN;
            }

            @Override
            public void apply(Consumer<IChatBaseComponent> var0, @Nullable EntityHuman var1, Holder<AttributeBase> var2, AttributeModifier var3) {
            }
        }

        public record c(IChatBaseComponent component) implements net.minecraft.world.item.component.ItemAttributeModifiers$b
        {
            static final MapCodec<c> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)ComponentSerialization.CODEC.fieldOf("value").forGetter(c::component)).apply((Applicative)var0, c::new));
            static final StreamCodec<RegistryFriendlyByteBuf, c> STREAM_CODEC = StreamCodec.composite(ComponentSerialization.STREAM_CODEC, c::component, c::new);

            @Override
            public d type() {
                return d.OVERRIDE;
            }

            @Override
            public void apply(Consumer<IChatBaseComponent> var0, @Nullable EntityHuman var1, Holder<AttributeBase> var2, AttributeModifier var3) {
                var0.accept(this.component);
            }
        }

        public static final class d
        extends Enum<d>
        implements INamable {
            public static final /* enum */ d DEFAULT = new d("default", 0, a.CODEC, a.STREAM_CODEC);
            public static final /* enum */ d HIDDEN = new d("hidden", 1, b.CODEC, b.STREAM_CODEC);
            public static final /* enum */ d OVERRIDE = new d("override", 2, c.CODEC, c.STREAM_CODEC);
            static final Codec<d> CODEC;
            private static final IntFunction<d> BY_ID;
            static final StreamCodec<ByteBuf, d> STREAM_CODEC;
            private final String name;
            private final int id;
            final MapCodec<? extends net.minecraft.world.item.component.ItemAttributeModifiers$b> codec;
            private final StreamCodec<RegistryFriendlyByteBuf, ? extends net.minecraft.world.item.component.ItemAttributeModifiers$b> streamCodec;
            private static final /* synthetic */ d[] k;

            public static d[] values() {
                return (d[])k.clone();
            }

            public static d valueOf(String var0) {
                return Enum.valueOf(d.class, var0);
            }

            private d(String var2, int var3, MapCodec var4, StreamCodec var5) {
                this.name = var2;
                this.id = var3;
                this.codec = var4;
                this.streamCodec = var5;
            }

            @Override
            public String getSerializedName() {
                return this.name;
            }

            private int id() {
                return this.id;
            }

            private StreamCodec<RegistryFriendlyByteBuf, ? extends net.minecraft.world.item.component.ItemAttributeModifiers$b> streamCodec() {
                return this.streamCodec;
            }

            private static /* synthetic */ d[] d() {
                return new d[]{DEFAULT, HIDDEN, OVERRIDE};
            }

            static {
                k = d.d();
                CODEC = INamable.fromEnum(d::values);
                BY_ID = ByIdMap.continuous(d::id, d.values(), ByIdMap.a.ZERO);
                STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, d::id);
            }
        }
    }
}

