/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.EnumChatFormat;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.players.ProfileResolver;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.entity.player.PlayerSkin;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;

public abstract sealed class ResolvableProfile
implements TooltipProvider {
    private static final Codec<ResolvableProfile> FULL_CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)Codec.mapEither(ExtraCodecs.STORED_GAME_PROFILE, Partial.MAP_CODEC).forGetter(ResolvableProfile::unpack), (App)PlayerSkin.Patch.MAP_CODEC.forGetter(ResolvableProfile::skinPatch)).apply((Applicative)var0, ResolvableProfile::create));
    public static final Codec<ResolvableProfile> CODEC = Codec.withAlternative(FULL_CODEC, ExtraCodecs.PLAYER_NAME, ResolvableProfile::createUnresolved);
    public static final StreamCodec<ByteBuf, ResolvableProfile> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.either(ByteBufCodecs.GAME_PROFILE, Partial.STREAM_CODEC), ResolvableProfile::unpack, PlayerSkin.Patch.STREAM_CODEC, ResolvableProfile::skinPatch, ResolvableProfile::create);
    protected final GameProfile partialProfile;
    protected final PlayerSkin.Patch skinPatch;

    private static ResolvableProfile create(Either<GameProfile, Partial> var0, PlayerSkin.Patch var13) {
        return (ResolvableProfile)var0.map(var1 -> new Static((Either<GameProfile, Partial>)Either.left((Object)var1), var13), var12 -> {
            if (!var12.properties.isEmpty() || var12.id.isPresent() == var12.name.isPresent()) {
                return new Static((Either<GameProfile, Partial>)Either.right((Object)var12), var13);
            }
            return var12.name.map(var1 -> new Dynamic((Either<String, UUID>)Either.left((Object)var1), var13)).orElseGet(() -> new Dynamic((Either<String, UUID>)Either.right((Object)var0.id.get()), var13));
        });
    }

    public static ResolvableProfile createResolved(GameProfile var0) {
        return new Static((Either<GameProfile, Partial>)Either.left((Object)var0), PlayerSkin.Patch.EMPTY);
    }

    public static ResolvableProfile createUnresolved(String var0) {
        return new Dynamic((Either<String, UUID>)Either.left((Object)var0), PlayerSkin.Patch.EMPTY);
    }

    public static ResolvableProfile createUnresolved(UUID var0) {
        return new Dynamic((Either<String, UUID>)Either.right((Object)var0), PlayerSkin.Patch.EMPTY);
    }

    protected abstract Either<GameProfile, Partial> unpack();

    protected ResolvableProfile(GameProfile var0, PlayerSkin.Patch var1) {
        this.partialProfile = var0;
        this.skinPatch = var1;
    }

    public abstract CompletableFuture<GameProfile> resolveProfile(ProfileResolver var1);

    public GameProfile partialProfile() {
        return this.partialProfile;
    }

    public PlayerSkin.Patch skinPatch() {
        return this.skinPatch;
    }

    static GameProfile createPartialProfile(Optional<String> var0, Optional<UUID> var1, PropertyMap var2) {
        String var3 = var0.orElse("");
        UUID var4 = var1.orElseGet(() -> var0.map(UUIDUtil::createOfflinePlayerUUID).orElse(SystemUtils.NIL_UUID));
        return new GameProfile(var4, var3, var2);
    }

    public abstract Optional<String> name();

    public static final class Static
    extends ResolvableProfile {
        public static final Static EMPTY = new Static((Either<GameProfile, Partial>)Either.right((Object)Partial.EMPTY), PlayerSkin.Patch.EMPTY);
        private final Either<GameProfile, Partial> contents;

        public Static(Either<GameProfile, Partial> var02, PlayerSkin.Patch var1) {
            super((GameProfile)var02.map(var0 -> var0, Partial::createProfile), var1);
            this.contents = var02;
        }

        @Override
        public CompletableFuture<GameProfile> resolveProfile(ProfileResolver var0) {
            return CompletableFuture.completedFuture(this.partialProfile);
        }

        @Override
        protected Either<GameProfile, Partial> unpack() {
            return this.contents;
        }

        @Override
        public Optional<String> name() {
            return (Optional)this.contents.map(var0 -> Optional.of(var0.name()), var0 -> var0.name);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object var0) {
            if (this == var0) return true;
            if (!(var0 instanceof Static)) return false;
            Static var1 = (Static)var0;
            if (!this.contents.equals(var1.contents)) return false;
            if (!this.skinPatch.equals(var1.skinPatch)) return false;
            return true;
        }

        public int hashCode() {
            int var0 = 31 + this.contents.hashCode();
            var0 = 31 * var0 + this.skinPatch.hashCode();
            return var0;
        }

        @Override
        public void addToTooltip(Item.b var0, Consumer<IChatBaseComponent> var1, TooltipFlag var2, DataComponentGetter var3) {
        }
    }

    public static final class Dynamic
    extends ResolvableProfile {
        private static final IChatBaseComponent DYNAMIC_TOOLTIP = IChatBaseComponent.translatable("component.profile.dynamic").withStyle(EnumChatFormat.GRAY);
        private final Either<String, UUID> nameOrId;

        public Dynamic(Either<String, UUID> var0, PlayerSkin.Patch var1) {
            super(ResolvableProfile.createPartialProfile(var0.left(), var0.right(), PropertyMap.EMPTY), var1);
            this.nameOrId = var0;
        }

        @Override
        public Optional<String> name() {
            return this.nameOrId.left();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object var0) {
            if (this == var0) return true;
            if (!(var0 instanceof Dynamic)) return false;
            Dynamic var1 = (Dynamic)var0;
            if (!this.nameOrId.equals(var1.nameOrId)) return false;
            if (!this.skinPatch.equals(var1.skinPatch)) return false;
            return true;
        }

        public int hashCode() {
            int var0 = 31 + this.nameOrId.hashCode();
            var0 = 31 * var0 + this.skinPatch.hashCode();
            return var0;
        }

        @Override
        protected Either<GameProfile, Partial> unpack() {
            return Either.right((Object)new Partial(this.nameOrId.left(), this.nameOrId.right(), PropertyMap.EMPTY));
        }

        @Override
        public CompletableFuture<GameProfile> resolveProfile(ProfileResolver var0) {
            return CompletableFuture.supplyAsync(() -> var0.fetchByNameOrId(this.nameOrId).orElse(this.partialProfile), SystemUtils.nonCriticalIoPool());
        }

        @Override
        public void addToTooltip(Item.b var0, Consumer<IChatBaseComponent> var1, TooltipFlag var2, DataComponentGetter var3) {
            var1.accept(DYNAMIC_TOOLTIP);
        }
    }

    protected static final class Partial
    extends Record {
        final Optional<String> name;
        final Optional<UUID> id;
        final PropertyMap properties;
        public static final Partial EMPTY = new Partial(Optional.empty(), Optional.empty(), PropertyMap.EMPTY);
        static final MapCodec<Partial> MAP_CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)ExtraCodecs.PLAYER_NAME.optionalFieldOf("name").forGetter(Partial::name), (App)UUIDUtil.CODEC.optionalFieldOf("id").forGetter(Partial::id), (App)ExtraCodecs.PROPERTY_MAP.optionalFieldOf("properties", (Object)PropertyMap.EMPTY).forGetter(Partial::properties)).apply((Applicative)var0, Partial::new));
        public static final StreamCodec<ByteBuf, Partial> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.PLAYER_NAME.apply(ByteBufCodecs::optional), Partial::name, UUIDUtil.STREAM_CODEC.apply(ByteBufCodecs::optional), Partial::id, ByteBufCodecs.GAME_PROFILE_PROPERTIES, Partial::properties, Partial::new);

        protected Partial(Optional<String> var0, Optional<UUID> var1, PropertyMap var2) {
            this.name = var0;
            this.id = var1;
            this.properties = var2;
        }

        private GameProfile createProfile() {
            return ResolvableProfile.createPartialProfile(this.name, this.id, this.properties);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Partial.class, "name;id;properties", "name", "id", "properties"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Partial.class, "name;id;properties", "name", "id", "properties"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Partial.class, "name;id;properties", "name", "id", "properties"}, this, var0);
        }

        public Optional<String> name() {
            return this.name;
        }

        public Optional<UUID> id() {
            return this.id;
        }

        public PropertyMap properties() {
            return this.properties;
        }
    }
}

