/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;

public record UseCooldown(float seconds, Optional<MinecraftKey> cooldownGroup) {
    public static final Codec<UseCooldown> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)ExtraCodecs.POSITIVE_FLOAT.fieldOf("seconds").forGetter(UseCooldown::seconds), (App)MinecraftKey.CODEC.optionalFieldOf("cooldown_group").forGetter(UseCooldown::cooldownGroup)).apply((Applicative)var0, UseCooldown::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, UseCooldown> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.FLOAT, UseCooldown::seconds, MinecraftKey.STREAM_CODEC.apply(ByteBufCodecs::optional), UseCooldown::cooldownGroup, UseCooldown::new);

    public UseCooldown(float var0) {
        this(var0, Optional.empty());
    }

    public int ticks() {
        return (int)(this.seconds * 20.0f);
    }

    public void apply(ItemStack var0, EntityLiving var1) {
        if (var1 instanceof EntityHuman) {
            EntityHuman var2 = (EntityHuman)var1;
            var2.getCooldowns().addCooldown(var0, this.ticks());
        }
    }
}

