/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.consume_effects;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.consume_effects.ConsumeEffect;
import net.minecraft.world.level.World;

public record ApplyStatusEffectsConsumeEffect(List<MobEffect> effects, float probability) implements ConsumeEffect
{
    public static final MapCodec<ApplyStatusEffectsConsumeEffect> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)MobEffect.CODEC.listOf().fieldOf("effects").forGetter(ApplyStatusEffectsConsumeEffect::effects), (App)Codec.floatRange((float)0.0f, (float)1.0f).optionalFieldOf("probability", (Object)Float.valueOf(1.0f)).forGetter(ApplyStatusEffectsConsumeEffect::probability)).apply((Applicative)var0, ApplyStatusEffectsConsumeEffect::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ApplyStatusEffectsConsumeEffect> STREAM_CODEC = StreamCodec.composite(MobEffect.STREAM_CODEC.apply(ByteBufCodecs.list()), ApplyStatusEffectsConsumeEffect::effects, ByteBufCodecs.FLOAT, ApplyStatusEffectsConsumeEffect::probability, ApplyStatusEffectsConsumeEffect::new);

    public ApplyStatusEffectsConsumeEffect(MobEffect var0, float var1) {
        this(List.of(var0), var1);
    }

    public ApplyStatusEffectsConsumeEffect(List<MobEffect> var0) {
        this(var0, 1.0f);
    }

    public ApplyStatusEffectsConsumeEffect(MobEffect var0) {
        this(var0, 1.0f);
    }

    public ConsumeEffect.a<ApplyStatusEffectsConsumeEffect> getType() {
        return ConsumeEffect.a.APPLY_EFFECTS;
    }

    @Override
    public boolean apply(World var0, ItemStack var1, EntityLiving var2) {
        if (var2.getRandom().nextFloat() >= this.probability) {
            return false;
        }
        boolean var3 = false;
        for (MobEffect var5 : this.effects) {
            if (!var2.addEffect(new MobEffect(var5))) continue;
            var3 = true;
        }
        return var3;
    }
}

