/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.consume_effects;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.consume_effects.ConsumeEffect;
import net.minecraft.world.level.World;

public record RemoveStatusEffectsConsumeEffect(HolderSet<MobEffectList> effects) implements ConsumeEffect
{
    public static final MapCodec<RemoveStatusEffectsConsumeEffect> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)RegistryCodecs.homogeneousList(Registries.MOB_EFFECT).fieldOf("effects").forGetter(RemoveStatusEffectsConsumeEffect::effects)).apply((Applicative)var0, RemoveStatusEffectsConsumeEffect::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, RemoveStatusEffectsConsumeEffect> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.holderSet(Registries.MOB_EFFECT), RemoveStatusEffectsConsumeEffect::effects, RemoveStatusEffectsConsumeEffect::new);

    public RemoveStatusEffectsConsumeEffect(Holder<MobEffectList> var0) {
        this(HolderSet.direct(var0));
    }

    public ConsumeEffect.a<RemoveStatusEffectsConsumeEffect> getType() {
        return ConsumeEffect.a.REMOVE_EFFECTS;
    }

    @Override
    public boolean apply(World var0, ItemStack var1, EntityLiving var2) {
        boolean var3 = false;
        for (Holder holder : this.effects) {
            if (!var2.removeEffect(holder)) continue;
            var3 = true;
        }
        return var3;
    }
}

