/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.consume_effects;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.animal.fox.EntityFox;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.consume_effects.ConsumeEffect;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3D;

public record TeleportRandomlyConsumeEffect(float diameter) implements ConsumeEffect
{
    private static final float DEFAULT_DIAMETER = 16.0f;
    public static final MapCodec<TeleportRandomlyConsumeEffect> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)ExtraCodecs.POSITIVE_FLOAT.optionalFieldOf("diameter", (Object)Float.valueOf(16.0f)).forGetter(TeleportRandomlyConsumeEffect::diameter)).apply((Applicative)var0, TeleportRandomlyConsumeEffect::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, TeleportRandomlyConsumeEffect> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.FLOAT, TeleportRandomlyConsumeEffect::diameter, TeleportRandomlyConsumeEffect::new);

    public TeleportRandomlyConsumeEffect() {
        this(16.0f);
    }

    public ConsumeEffect.a<TeleportRandomlyConsumeEffect> getType() {
        return ConsumeEffect.a.TELEPORT_RANDOMLY;
    }

    @Override
    public boolean apply(World var0, ItemStack var1, EntityLiving var2) {
        boolean var3 = false;
        for (int var4 = 0; var4 < 16; ++var4) {
            SoundCategory var12;
            SoundEffect var13;
            double var5 = var2.getX() + (var2.getRandom().nextDouble() - 0.5) * (double)this.diameter;
            double var7 = MathHelper.clamp(var2.getY() + (var2.getRandom().nextDouble() - 0.5) * (double)this.diameter, (double)var0.getMinY(), (double)(var0.getMinY() + ((WorldServer)var0).getLogicalHeight() - 1));
            double var9 = var2.getZ() + (var2.getRandom().nextDouble() - 0.5) * (double)this.diameter;
            if (var2.isPassenger()) {
                var2.stopRiding();
            }
            Vec3D var11 = var2.position();
            if (!var2.randomTeleport(var5, var7, var9, true)) continue;
            var0.gameEvent(GameEvent.TELEPORT, var11, GameEvent.a.of(var2));
            if (var2 instanceof EntityFox) {
                var13 = SoundEffects.FOX_TELEPORT;
                var12 = SoundCategory.NEUTRAL;
            } else {
                var13 = SoundEffects.CHORUS_FRUIT_TELEPORT;
                var12 = SoundCategory.PLAYERS;
            }
            var0.playSound(null, var2.getX(), var2.getY(), var2.getZ(), var13, var12);
            var2.resetFallDistance();
            var3 = true;
            break;
        }
        if (var3 && var2 instanceof EntityHuman) {
            EntityHuman var4 = (EntityHuman)var2;
            var4.resetCurrentImpulseContext();
        }
        return var3;
    }
}

