/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment.effects;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.particles.ExplosionParticleInfo;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.level.SimpleExplosionDamageCalculator;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3D;
import org.jspecify.annotations.Nullable;

public record ExplodeEffect(boolean attributeToUser, Optional<Holder<DamageType>> damageType, Optional<LevelBasedValue> knockbackMultiplier, Optional<HolderSet<Block>> immuneBlocks, Vec3D offset, LevelBasedValue radius, boolean createFire, World.a blockInteraction, ParticleParam smallParticle, ParticleParam largeParticle, WeightedList<ExplosionParticleInfo> blockParticles, Holder<SoundEffect> sound) implements EnchantmentEntityEffect
{
    public static final MapCodec<ExplodeEffect> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)Codec.BOOL.optionalFieldOf("attribute_to_user", (Object)false).forGetter(ExplodeEffect::attributeToUser), (App)DamageType.CODEC.optionalFieldOf("damage_type").forGetter(ExplodeEffect::damageType), (App)LevelBasedValue.CODEC.optionalFieldOf("knockback_multiplier").forGetter(ExplodeEffect::knockbackMultiplier), (App)RegistryCodecs.homogeneousList(Registries.BLOCK).optionalFieldOf("immune_blocks").forGetter(ExplodeEffect::immuneBlocks), (App)Vec3D.CODEC.optionalFieldOf("offset", (Object)Vec3D.ZERO).forGetter(ExplodeEffect::offset), (App)LevelBasedValue.CODEC.fieldOf("radius").forGetter(ExplodeEffect::radius), (App)Codec.BOOL.optionalFieldOf("create_fire", (Object)false).forGetter(ExplodeEffect::createFire), (App)World.a.CODEC.fieldOf("block_interaction").forGetter(ExplodeEffect::blockInteraction), (App)Particles.CODEC.fieldOf("small_particle").forGetter(ExplodeEffect::smallParticle), (App)Particles.CODEC.fieldOf("large_particle").forGetter(ExplodeEffect::largeParticle), (App)WeightedList.codec(ExplosionParticleInfo.CODEC).optionalFieldOf("block_particles", WeightedList.of()).forGetter(ExplodeEffect::blockParticles), (App)SoundEffect.CODEC.fieldOf("sound").forGetter(ExplodeEffect::sound)).apply((Applicative)var0, ExplodeEffect::new));

    @Override
    public void apply(WorldServer var0, int var12, EnchantedItemInUse var2, Entity var3, Vec3D var4) {
        Vec3D var5 = var4.add(this.offset);
        var0.explode(this.attributeToUser ? var3 : null, this.getDamageSource(var3, var5), new SimpleExplosionDamageCalculator(this.blockInteraction != World.a.NONE, this.damageType.isPresent(), this.knockbackMultiplier.map(var1 -> Float.valueOf(var1.calculate(var12))), this.immuneBlocks), var5.x(), var5.y(), var5.z(), Math.max(this.radius.calculate(var12), 0.0f), this.createFire, this.blockInteraction, this.smallParticle, this.largeParticle, this.blockParticles, this.sound);
    }

    private @Nullable DamageSource getDamageSource(Entity var0, Vec3D var1) {
        if (this.damageType.isEmpty()) {
            return null;
        }
        if (this.attributeToUser) {
            return new DamageSource(this.damageType.get(), var0);
        }
        return new DamageSource(this.damageType.get(), var1);
    }

    public MapCodec<ExplodeEffect> codec() {
        return CODEC;
    }
}

