/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment.effects;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.INamable;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantFloat;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.phys.Vec3D;

public record SpawnParticlesEffect(ParticleParam particle, a horizontalPosition, a verticalPosition, c horizontalVelocity, c verticalVelocity, FloatProvider speed) implements EnchantmentEntityEffect
{
    public static final MapCodec<SpawnParticlesEffect> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)Particles.CODEC.fieldOf("particle").forGetter(SpawnParticlesEffect::particle), (App)a.CODEC.fieldOf("horizontal_position").forGetter(SpawnParticlesEffect::horizontalPosition), (App)a.CODEC.fieldOf("vertical_position").forGetter(SpawnParticlesEffect::verticalPosition), (App)c.CODEC.fieldOf("horizontal_velocity").forGetter(SpawnParticlesEffect::horizontalVelocity), (App)c.CODEC.fieldOf("vertical_velocity").forGetter(SpawnParticlesEffect::verticalVelocity), (App)FloatProvider.CODEC.optionalFieldOf("speed", (Object)ConstantFloat.ZERO).forGetter(SpawnParticlesEffect::speed)).apply((Applicative)var0, SpawnParticlesEffect::new));

    public static a offsetFromEntityPosition(float var0) {
        return new a(b.ENTITY_POSITION, var0, 1.0f);
    }

    public static a inBoundingBox() {
        return new a(b.BOUNDING_BOX, 0.0f, 1.0f);
    }

    public static c movementScaled(float var0) {
        return new c(var0, ConstantFloat.ZERO);
    }

    public static c fixedVelocity(FloatProvider var0) {
        return new c(0.0f, var0);
    }

    @Override
    public void apply(WorldServer var0, int var1, EnchantedItemInUse var2, Entity var3, Vec3D var4) {
        RandomSource var5 = var3.getRandom();
        Vec3D var6 = var3.getKnownMovement();
        float var7 = var3.getBbWidth();
        float var8 = var3.getBbHeight();
        var0.sendParticles(this.particle, this.horizontalPosition.getCoordinate(var4.x(), var4.x(), var7, var5), this.verticalPosition.getCoordinate(var4.y(), var4.y() + (double)(var8 / 2.0f), var8, var5), this.horizontalPosition.getCoordinate(var4.z(), var4.z(), var7, var5), 0, this.horizontalVelocity.getVelocity(var6.x(), var5), this.verticalVelocity.getVelocity(var6.y(), var5), this.horizontalVelocity.getVelocity(var6.z(), var5), this.speed.sample(var5));
    }

    public MapCodec<SpawnParticlesEffect> codec() {
        return CODEC;
    }

    public record a(b type, float offset, float scale) {
        public static final MapCodec<a> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)b.CODEC.fieldOf("type").forGetter(a::type), (App)Codec.FLOAT.optionalFieldOf("offset", (Object)Float.valueOf(0.0f)).forGetter(a::offset), (App)ExtraCodecs.POSITIVE_FLOAT.optionalFieldOf("scale", (Object)Float.valueOf(1.0f)).forGetter(a::scale)).apply((Applicative)var0, a::new)).validate(var0 -> {
            if (var0.type() == b.ENTITY_POSITION && var0.scale() != 1.0f) {
                return DataResult.error(() -> "Cannot scale an entity position coordinate source");
            }
            return DataResult.success((Object)var0);
        });

        public double getCoordinate(double var0, double var2, float var4, RandomSource var5) {
            return this.type.getCoordinate(var0, var2, var4 * this.scale, var5) + (double)this.offset;
        }
    }

    public record c(float movementScale, FloatProvider base) {
        public static final MapCodec<c> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)Codec.FLOAT.optionalFieldOf("movement_scale", (Object)Float.valueOf(0.0f)).forGetter(c::movementScale), (App)FloatProvider.CODEC.optionalFieldOf("base", (Object)ConstantFloat.ZERO).forGetter(c::base)).apply((Applicative)var0, c::new));

        public double getVelocity(double var0, RandomSource var2) {
            return var0 * (double)this.movementScale + (double)this.base.sample(var2);
        }
    }

    public static final class b
    extends Enum<b>
    implements INamable {
        public static final /* enum */ b ENTITY_POSITION = new b("entity_position", (var0, var2, var4, var5) -> var0);
        public static final /* enum */ b BOUNDING_BOX = new b("in_bounding_box", (var0, var2, var4, var5) -> var2 + (var5.nextDouble() - 0.5) * (double)var4);
        public static final Codec<b> CODEC;
        private final String id;
        private final a source;
        private static final /* synthetic */ b[] f;

        public static b[] values() {
            return (b[])f.clone();
        }

        public static b valueOf(String var0) {
            return Enum.valueOf(b.class, var0);
        }

        private b(String var2, a var3) {
            this.id = var2;
            this.source = var3;
        }

        public double getCoordinate(double var0, double var2, float var4, RandomSource var5) {
            return this.source.getCoordinate(var0, var2, var4, var5);
        }

        @Override
        public String getSerializedName() {
            return this.id;
        }

        private static /* synthetic */ b[] a() {
            return new b[]{ENTITY_POSITION, BOUNDING_BOX};
        }

        static {
            f = b.a();
            CODEC = INamable.fromEnum(b::values);
        }

        @FunctionalInterface
        static interface a {
            public double getCoordinate(double var1, double var3, float var5, RandomSource var6);
        }
    }
}

