/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.equipment;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsEntity;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.equipment.EquipmentAsset;
import net.minecraft.world.item.equipment.EquipmentAssets;

public record Equippable(EnumItemSlot slot, Holder<SoundEffect> equipSound, Optional<ResourceKey<EquipmentAsset>> assetId, Optional<MinecraftKey> cameraOverlay, Optional<HolderSet<EntityTypes<?>>> allowedEntities, boolean dispensable, boolean swappable, boolean damageOnHurt, boolean equipOnInteract, boolean canBeSheared, Holder<SoundEffect> shearingSound) {
    public static final Codec<Equippable> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)EnumItemSlot.CODEC.fieldOf("slot").forGetter(Equippable::slot), (App)SoundEffect.CODEC.optionalFieldOf("equip_sound", SoundEffects.ARMOR_EQUIP_GENERIC).forGetter(Equippable::equipSound), (App)ResourceKey.codec(EquipmentAssets.ROOT_ID).optionalFieldOf("asset_id").forGetter(Equippable::assetId), (App)MinecraftKey.CODEC.optionalFieldOf("camera_overlay").forGetter(Equippable::cameraOverlay), (App)RegistryCodecs.homogeneousList(Registries.ENTITY_TYPE).optionalFieldOf("allowed_entities").forGetter(Equippable::allowedEntities), (App)Codec.BOOL.optionalFieldOf("dispensable", (Object)true).forGetter(Equippable::dispensable), (App)Codec.BOOL.optionalFieldOf("swappable", (Object)true).forGetter(Equippable::swappable), (App)Codec.BOOL.optionalFieldOf("damage_on_hurt", (Object)true).forGetter(Equippable::damageOnHurt), (App)Codec.BOOL.optionalFieldOf("equip_on_interact", (Object)false).forGetter(Equippable::equipOnInteract), (App)Codec.BOOL.optionalFieldOf("can_be_sheared", (Object)false).forGetter(Equippable::canBeSheared), (App)SoundEffect.CODEC.optionalFieldOf("shearing_sound", BuiltInRegistries.SOUND_EVENT.wrapAsHolder(SoundEffects.SHEARS_SNIP)).forGetter(Equippable::shearingSound)).apply((Applicative)var0, Equippable::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, Equippable> STREAM_CODEC = StreamCodec.composite(EnumItemSlot.STREAM_CODEC, Equippable::slot, SoundEffect.STREAM_CODEC, Equippable::equipSound, ResourceKey.streamCodec(EquipmentAssets.ROOT_ID).apply(ByteBufCodecs::optional), Equippable::assetId, MinecraftKey.STREAM_CODEC.apply(ByteBufCodecs::optional), Equippable::cameraOverlay, ByteBufCodecs.holderSet(Registries.ENTITY_TYPE).apply(ByteBufCodecs::optional), Equippable::allowedEntities, ByteBufCodecs.BOOL, Equippable::dispensable, ByteBufCodecs.BOOL, Equippable::swappable, ByteBufCodecs.BOOL, Equippable::damageOnHurt, ByteBufCodecs.BOOL, Equippable::equipOnInteract, ByteBufCodecs.BOOL, Equippable::canBeSheared, SoundEffect.STREAM_CODEC, Equippable::shearingSound, Equippable::new);

    public static Equippable llamaSwag(EnumColor var0) {
        return Equippable.builder(EnumItemSlot.BODY).setEquipSound(SoundEffects.LLAMA_SWAG).setAsset(EquipmentAssets.CARPETS.get(var0)).setAllowedEntities(EntityTypes.LLAMA, EntityTypes.TRADER_LLAMA).setCanBeSheared(true).setShearingSound(SoundEffects.LLAMA_CARPET_UNEQUIP).build();
    }

    public static Equippable saddle() {
        HolderGetter<EntityTypes<?>> var0 = BuiltInRegistries.acquireBootstrapRegistrationLookup(BuiltInRegistries.ENTITY_TYPE);
        return Equippable.builder(EnumItemSlot.SADDLE).setEquipSound(SoundEffects.HORSE_SADDLE).setAsset(EquipmentAssets.SADDLE).setAllowedEntities(var0.getOrThrow(TagsEntity.CAN_EQUIP_SADDLE)).setEquipOnInteract(true).setCanBeSheared(true).setShearingSound(SoundEffects.SADDLE_UNEQUIP).build();
    }

    public static Equippable harness(EnumColor var0) {
        HolderGetter<EntityTypes<?>> var1 = BuiltInRegistries.acquireBootstrapRegistrationLookup(BuiltInRegistries.ENTITY_TYPE);
        return Equippable.builder(EnumItemSlot.BODY).setEquipSound(SoundEffects.HARNESS_EQUIP).setAsset(EquipmentAssets.HARNESSES.get(var0)).setAllowedEntities(var1.getOrThrow(TagsEntity.CAN_EQUIP_HARNESS)).setEquipOnInteract(true).setCanBeSheared(true).setShearingSound(BuiltInRegistries.SOUND_EVENT.wrapAsHolder(SoundEffects.HARNESS_UNEQUIP)).build();
    }

    public static a builder(EnumItemSlot var0) {
        return new a(var0);
    }

    public EnumInteractionResult swapWithEquipmentSlot(ItemStack var0, EntityHuman var1) {
        if (!var1.canUseSlot(this.slot) || !this.canBeEquippedBy(var1.getType())) {
            return EnumInteractionResult.PASS;
        }
        ItemStack var2 = var1.getItemBySlot(this.slot);
        if (EnchantmentManager.has(var2, EnchantmentEffectComponents.PREVENT_ARMOR_CHANGE) && !var1.isCreative() || ItemStack.isSameItemSameComponents(var0, var2)) {
            return EnumInteractionResult.FAIL;
        }
        if (!var1.level().isClientSide()) {
            var1.awardStat(StatisticList.ITEM_USED.get(var0.getItem()));
        }
        if (var0.getCount() <= 1) {
            ItemStack var3 = var2.isEmpty() ? var0 : var2.copyAndClear();
            ItemStack var4 = var1.isCreative() ? var0.copy() : var0.copyAndClear();
            var1.setItemSlot(this.slot, var4);
            return EnumInteractionResult.SUCCESS.heldItemTransformedTo(var3);
        }
        ItemStack var3 = var2.copyAndClear();
        ItemStack var4 = var0.consumeAndReturn(1, var1);
        var1.setItemSlot(this.slot, var4);
        if (!var1.getInventory().add(var3)) {
            var1.drop(var3, false);
        }
        return EnumInteractionResult.SUCCESS.heldItemTransformedTo(var0);
    }

    public EnumInteractionResult equipOnTarget(EntityHuman var0, EntityLiving var1, ItemStack var2) {
        if (!var1.isEquippableInSlot(var2, this.slot) || var1.hasItemInSlot(this.slot) || !var1.isAlive()) {
            return EnumInteractionResult.PASS;
        }
        if (!var0.level().isClientSide()) {
            var1.setItemSlot(this.slot, var2.split(1));
            if (var1 instanceof EntityInsentient) {
                EntityInsentient var3 = (EntityInsentient)var1;
                var3.setGuaranteedDrop(this.slot);
            }
        }
        return EnumInteractionResult.SUCCESS;
    }

    public boolean canBeEquippedBy(EntityTypes<?> var0) {
        return this.allowedEntities.isEmpty() || this.allowedEntities.get().contains(var0.builtInRegistryHolder());
    }

    public static class a {
        private final EnumItemSlot slot;
        private Holder<SoundEffect> equipSound = SoundEffects.ARMOR_EQUIP_GENERIC;
        private Optional<ResourceKey<EquipmentAsset>> assetId = Optional.empty();
        private Optional<MinecraftKey> cameraOverlay = Optional.empty();
        private Optional<HolderSet<EntityTypes<?>>> allowedEntities = Optional.empty();
        private boolean dispensable = true;
        private boolean swappable = true;
        private boolean damageOnHurt = true;
        private boolean equipOnInteract;
        private boolean canBeSheared;
        private Holder<SoundEffect> shearingSound = BuiltInRegistries.SOUND_EVENT.wrapAsHolder(SoundEffects.SHEARS_SNIP);

        a(EnumItemSlot var0) {
            this.slot = var0;
        }

        public a setEquipSound(Holder<SoundEffect> var0) {
            this.equipSound = var0;
            return this;
        }

        public a setAsset(ResourceKey<EquipmentAsset> var0) {
            this.assetId = Optional.of(var0);
            return this;
        }

        public a setCameraOverlay(MinecraftKey var0) {
            this.cameraOverlay = Optional.of(var0);
            return this;
        }

        public a setAllowedEntities(EntityTypes<?> ... var0) {
            return this.setAllowedEntities(HolderSet.direct(EntityTypes::builtInRegistryHolder, var0));
        }

        public a setAllowedEntities(HolderSet<EntityTypes<?>> var0) {
            this.allowedEntities = Optional.of(var0);
            return this;
        }

        public a setDispensable(boolean var0) {
            this.dispensable = var0;
            return this;
        }

        public a setSwappable(boolean var0) {
            this.swappable = var0;
            return this;
        }

        public a setDamageOnHurt(boolean var0) {
            this.damageOnHurt = var0;
            return this;
        }

        public a setEquipOnInteract(boolean var0) {
            this.equipOnInteract = var0;
            return this;
        }

        public a setCanBeSheared(boolean var0) {
            this.canBeSheared = var0;
            return this;
        }

        public a setShearingSound(Holder<SoundEffect> var0) {
            this.shearingSound = var0;
            return this;
        }

        public Equippable build() {
            return new Equippable(this.slot, this.equipSound, this.assetId, this.cameraOverlay, this.allowedEntities, this.dispensable, this.swappable, this.damageOnHurt, this.equipOnInteract, this.canBeSheared, this.shearingSound);
        }
    }
}

