/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.trading;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.MathHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.ItemCost;

public class MerchantRecipe {
    public static final Codec<MerchantRecipe> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)ItemCost.CODEC.fieldOf("buy").forGetter(var0 -> var0.baseCostA), (App)ItemCost.CODEC.lenientOptionalFieldOf("buyB").forGetter(var0 -> var0.costB), (App)ItemStack.CODEC.fieldOf("sell").forGetter(var0 -> var0.result), (App)Codec.INT.lenientOptionalFieldOf("uses", (Object)0).forGetter(var0 -> var0.uses), (App)Codec.INT.lenientOptionalFieldOf("maxUses", (Object)4).forGetter(var0 -> var0.maxUses), (App)Codec.BOOL.lenientOptionalFieldOf("rewardExp", (Object)true).forGetter(var0 -> var0.rewardExp), (App)Codec.INT.lenientOptionalFieldOf("specialPrice", (Object)0).forGetter(var0 -> var0.specialPriceDiff), (App)Codec.INT.lenientOptionalFieldOf("demand", (Object)0).forGetter(var0 -> var0.demand), (App)Codec.FLOAT.lenientOptionalFieldOf("priceMultiplier", (Object)Float.valueOf(0.0f)).forGetter(var0 -> Float.valueOf(var0.priceMultiplier)), (App)Codec.INT.lenientOptionalFieldOf("xp", (Object)1).forGetter(var0 -> var0.xp)).apply((Applicative)var02, MerchantRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, MerchantRecipe> STREAM_CODEC = StreamCodec.of(MerchantRecipe::writeToStream, MerchantRecipe::createFromStream);
    public ItemCost baseCostA;
    public Optional<ItemCost> costB;
    public final ItemStack result;
    public int uses;
    public int maxUses;
    public boolean rewardExp;
    public int specialPriceDiff;
    public int demand;
    public float priceMultiplier;
    public int xp;

    private MerchantRecipe(ItemCost var0, Optional<ItemCost> var1, ItemStack var2, int var3, int var4, boolean var5, int var6, int var7, float var8, int var9) {
        this.baseCostA = var0;
        this.costB = var1;
        this.result = var2;
        this.uses = var3;
        this.maxUses = var4;
        this.rewardExp = var5;
        this.specialPriceDiff = var6;
        this.demand = var7;
        this.priceMultiplier = var8;
        this.xp = var9;
    }

    public MerchantRecipe(ItemCost var0, ItemStack var1, int var2, int var3, float var4) {
        this(var0, Optional.empty(), var1, var2, var3, var4);
    }

    public MerchantRecipe(ItemCost var0, Optional<ItemCost> var1, ItemStack var2, int var3, int var4, float var5) {
        this(var0, var1, var2, 0, var3, var4, var5);
    }

    public MerchantRecipe(ItemCost var0, Optional<ItemCost> var1, ItemStack var2, int var3, int var4, int var5, float var6) {
        this(var0, var1, var2, var3, var4, var5, var6, 0);
    }

    public MerchantRecipe(ItemCost var0, Optional<ItemCost> var1, ItemStack var2, int var3, int var4, int var5, float var6, int var7) {
        this(var0, var1, var2, var3, var4, true, 0, var7, var6, var5);
    }

    private MerchantRecipe(MerchantRecipe var0) {
        this(var0.baseCostA, var0.costB, var0.result.copy(), var0.uses, var0.maxUses, var0.rewardExp, var0.specialPriceDiff, var0.demand, var0.priceMultiplier, var0.xp);
    }

    public ItemStack getBaseCostA() {
        return this.baseCostA.itemStack();
    }

    public ItemStack getCostA() {
        return this.baseCostA.itemStack().copyWithCount(this.getModifiedCostCount(this.baseCostA));
    }

    private int getModifiedCostCount(ItemCost var0) {
        int var1 = var0.count();
        int var2 = Math.max(0, MathHelper.floor((float)(var1 * this.demand) * this.priceMultiplier));
        return MathHelper.clamp(var1 + var2 + this.specialPriceDiff, 1, var0.itemStack().getMaxStackSize());
    }

    public ItemStack getCostB() {
        return this.costB.map(ItemCost::itemStack).orElse(ItemStack.EMPTY);
    }

    public ItemCost getItemCostA() {
        return this.baseCostA;
    }

    public Optional<ItemCost> getItemCostB() {
        return this.costB;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public void updateDemand() {
        this.demand = this.demand + this.uses - (this.maxUses - this.uses);
    }

    public ItemStack assemble() {
        return this.result.copy();
    }

    public int getUses() {
        return this.uses;
    }

    public void resetUses() {
        this.uses = 0;
    }

    public int getMaxUses() {
        return this.maxUses;
    }

    public void increaseUses() {
        ++this.uses;
    }

    public int getDemand() {
        return this.demand;
    }

    public void addToSpecialPriceDiff(int var0) {
        this.specialPriceDiff += var0;
    }

    public void resetSpecialPriceDiff() {
        this.specialPriceDiff = 0;
    }

    public int getSpecialPriceDiff() {
        return this.specialPriceDiff;
    }

    public void setSpecialPriceDiff(int var0) {
        this.specialPriceDiff = var0;
    }

    public float getPriceMultiplier() {
        return this.priceMultiplier;
    }

    public int getXp() {
        return this.xp;
    }

    public boolean isOutOfStock() {
        return this.uses >= this.maxUses;
    }

    public void setToOutOfStock() {
        this.uses = this.maxUses;
    }

    public boolean needsRestock() {
        return this.uses > 0;
    }

    public boolean shouldRewardExp() {
        return this.rewardExp;
    }

    public boolean satisfiedBy(ItemStack var0, ItemStack var1) {
        if (!this.baseCostA.test(var0) || var0.getCount() < this.getModifiedCostCount(this.baseCostA)) {
            return false;
        }
        if (this.costB.isPresent()) {
            return this.costB.get().test(var1) && var1.getCount() >= this.costB.get().count();
        }
        return var1.isEmpty();
    }

    public boolean take(ItemStack var0, ItemStack var1) {
        if (!this.satisfiedBy(var0, var1)) {
            return false;
        }
        var0.shrink(this.getCostA().getCount());
        if (!this.getCostB().isEmpty()) {
            var1.shrink(this.getCostB().getCount());
        }
        return true;
    }

    public MerchantRecipe copy() {
        return new MerchantRecipe(this);
    }

    private static void writeToStream(RegistryFriendlyByteBuf var0, MerchantRecipe var1) {
        ItemCost.STREAM_CODEC.encode(var0, var1.getItemCostA());
        ItemStack.STREAM_CODEC.encode(var0, var1.getResult());
        ItemCost.OPTIONAL_STREAM_CODEC.encode(var0, var1.getItemCostB());
        var0.writeBoolean(var1.isOutOfStock());
        var0.writeInt(var1.getUses());
        var0.writeInt(var1.getMaxUses());
        var0.writeInt(var1.getXp());
        var0.writeInt(var1.getSpecialPriceDiff());
        var0.writeFloat(var1.getPriceMultiplier());
        var0.writeInt(var1.getDemand());
    }

    public static MerchantRecipe createFromStream(RegistryFriendlyByteBuf var0) {
        ItemCost var1 = (ItemCost)ItemCost.STREAM_CODEC.decode(var0);
        ItemStack var2 = (ItemStack)ItemStack.STREAM_CODEC.decode(var0);
        Optional var3 = (Optional)ItemCost.OPTIONAL_STREAM_CODEC.decode(var0);
        boolean var4 = var0.readBoolean();
        int var5 = var0.readInt();
        int var6 = var0.readInt();
        int var7 = var0.readInt();
        int var8 = var0.readInt();
        float var9 = var0.readFloat();
        int var10 = var0.readInt();
        MerchantRecipe var11 = new MerchantRecipe(var1, var3, var2, var5, var6, var7, var9, var10);
        if (var4) {
            var11.setToOutOfStock();
        }
        var11.setSpecialPriceDiff(var8);
        return var11;
    }
}

