/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.RegionLimitedWorldAccess;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.chunk.StructureAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureCheck;
import net.minecraft.world.level.levelgen.structure.StructureCheckResult;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import org.jspecify.annotations.Nullable;

public class StructureManager {
    public final GeneratorAccess level;
    private final WorldOptions worldOptions;
    private final StructureCheck structureCheck;

    public StructureManager(GeneratorAccess var0, WorldOptions var1, StructureCheck var2) {
        this.level = var0;
        this.worldOptions = var1;
        this.structureCheck = var2;
    }

    public StructureManager forWorldGenRegion(RegionLimitedWorldAccess var0) {
        if (var0.getLevel() != this.level) {
            throw new IllegalStateException("Using invalid structure manager (source level: " + String.valueOf(var0.getLevel()) + ", region: " + String.valueOf(var0));
        }
        return new StructureManager(var0, this.worldOptions, this.structureCheck);
    }

    public List<StructureStart> startsForStructure(ChunkCoordIntPair var0, Predicate<Structure> var1) {
        Map<Structure, LongSet> var2 = this.level.getChunk(var0.x, var0.z, ChunkStatus.STRUCTURE_REFERENCES).getAllReferences();
        ImmutableList.Builder var3 = ImmutableList.builder();
        for (Map.Entry<Structure, LongSet> var5 : var2.entrySet()) {
            Structure var6 = var5.getKey();
            if (!var1.test(var6)) continue;
            this.fillStartsForStructure(var6, var5.getValue(), arg_0 -> ((ImmutableList.Builder)var3).add(arg_0));
        }
        return var3.build();
    }

    public List<StructureStart> startsForStructure(SectionPosition var0, Structure var1) {
        LongSet var2 = this.level.getChunk(var0.x(), var0.z(), ChunkStatus.STRUCTURE_REFERENCES).getReferencesForStructure(var1);
        ImmutableList.Builder var3 = ImmutableList.builder();
        this.fillStartsForStructure(var1, var2, arg_0 -> ((ImmutableList.Builder)var3).add(arg_0));
        return var3.build();
    }

    public void fillStartsForStructure(Structure var0, LongSet var1, Consumer<StructureStart> var2) {
        LongIterator longIterator = var1.iterator();
        while (longIterator.hasNext()) {
            long var4 = (Long)longIterator.next();
            SectionPosition var6 = SectionPosition.of(new ChunkCoordIntPair(var4), this.level.getMinSectionY());
            StructureStart var7 = this.getStartForStructure(var6, var0, this.level.getChunk(var6.x(), var6.z(), ChunkStatus.STRUCTURE_STARTS));
            if (var7 == null || !var7.isValid()) continue;
            var2.accept(var7);
        }
    }

    public @Nullable StructureStart getStartForStructure(SectionPosition var0, Structure var1, StructureAccess var2) {
        return var2.getStartForStructure(var1);
    }

    public void setStartForStructure(SectionPosition var0, Structure var1, StructureStart var2, StructureAccess var3) {
        var3.setStartForStructure(var1, var2);
    }

    public void addReferenceForStructure(SectionPosition var0, Structure var1, long var2, StructureAccess var4) {
        var4.addReferenceForStructure(var1, var2);
    }

    public boolean shouldGenerateStructures() {
        return this.worldOptions.generateStructures();
    }

    public StructureStart getStructureAt(BlockPosition var0, Structure var1) {
        for (StructureStart var3 : this.startsForStructure(SectionPosition.of(var0), var1)) {
            if (!var3.getBoundingBox().isInside(var0)) continue;
            return var3;
        }
        return StructureStart.INVALID_START;
    }

    public StructureStart getStructureWithPieceAt(BlockPosition var0, TagKey<Structure> var12) {
        return this.getStructureWithPieceAt(var0, (Holder<Structure> var1) -> var1.is(var12));
    }

    public StructureStart getStructureWithPieceAt(BlockPosition var0, HolderSet<Structure> var1) {
        return this.getStructureWithPieceAt(var0, var1::contains);
    }

    public StructureStart getStructureWithPieceAt(BlockPosition var0, Predicate<Holder<Structure>> var1) {
        HolderLookup.b var2 = this.registryAccess().lookupOrThrow(Registries.STRUCTURE);
        for (StructureStart var4 : this.startsForStructure(new ChunkCoordIntPair(var0), arg_0 -> StructureManager.a((IRegistry)var2, var1, arg_0))) {
            if (!this.structureHasPieceAt(var0, var4)) continue;
            return var4;
        }
        return StructureStart.INVALID_START;
    }

    public StructureStart getStructureWithPieceAt(BlockPosition var0, Structure var1) {
        for (StructureStart var3 : this.startsForStructure(SectionPosition.of(var0), var1)) {
            if (!this.structureHasPieceAt(var0, var3)) continue;
            return var3;
        }
        return StructureStart.INVALID_START;
    }

    public boolean structureHasPieceAt(BlockPosition var0, StructureStart var1) {
        for (StructurePiece var3 : var1.getPieces()) {
            if (!var3.getBoundingBox().isInside(var0)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAnyStructureAt(BlockPosition var0) {
        SectionPosition var1 = SectionPosition.of(var0);
        return this.level.getChunk(var1.x(), var1.z(), ChunkStatus.STRUCTURE_REFERENCES).hasAnyStructureReferences();
    }

    public Map<Structure, LongSet> getAllStructuresAt(BlockPosition var0) {
        SectionPosition var1 = SectionPosition.of(var0);
        return this.level.getChunk(var1.x(), var1.z(), ChunkStatus.STRUCTURE_REFERENCES).getAllReferences();
    }

    public StructureCheckResult checkStructurePresence(ChunkCoordIntPair var0, Structure var1, StructurePlacement var2, boolean var3) {
        return this.structureCheck.checkStart(var0, var1, var2, var3);
    }

    public void addReference(StructureStart var0) {
        var0.addReference();
        this.structureCheck.incrementReference(var0.getChunkPos(), var0.getStructure());
    }

    public IRegistryCustom registryAccess() {
        return this.level.registryAccess();
    }

    private static /* synthetic */ boolean a(IRegistry var0, Predicate var1, Structure var2) {
        return var0.get(var0.getId(var2)).map(var1::test).orElse(false);
    }
}

