/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.particles.ExplosionParticleInfo;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.AbortableIterationConsumer;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.TickRateManager;
import net.minecraft.world.attribute.EnvironmentAttributeReader;
import net.minecraft.world.attribute.EnvironmentAttributeSystem;
import net.minecraft.world.attribute.EnvironmentAttributes;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.boss.enderdragon.EntityComplexPart;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionBrewer;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.crafting.RecipeAccess;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFireAbstract;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.FuelValues;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.PalettedContainerFactory;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.redstone.CollectingNeighborUpdater;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.level.storage.WorldDataMutable;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.Scoreboard;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jspecify.annotations.Nullable;

public abstract class World
implements GeneratorAccess,
AutoCloseable {
    public static final Codec<ResourceKey<World>> RESOURCE_KEY_CODEC = ResourceKey.codec(Registries.DIMENSION);
    public static final ResourceKey<World> OVERWORLD = ResourceKey.create(Registries.DIMENSION, MinecraftKey.withDefaultNamespace("overworld"));
    public static final ResourceKey<World> NETHER = ResourceKey.create(Registries.DIMENSION, MinecraftKey.withDefaultNamespace("the_nether"));
    public static final ResourceKey<World> END = ResourceKey.create(Registries.DIMENSION, MinecraftKey.withDefaultNamespace("the_end"));
    public static final int MAX_LEVEL_SIZE = 30000000;
    public static final int LONG_PARTICLE_CLIP_RANGE = 512;
    public static final int SHORT_PARTICLE_CLIP_RANGE = 32;
    public static final int MAX_BRIGHTNESS = 15;
    public static final int MAX_ENTITY_SPAWN_Y = 20000000;
    public static final int MIN_ENTITY_SPAWN_Y = -20000000;
    public static final WeightedList<ExplosionParticleInfo> DEFAULT_EXPLOSION_BLOCK_PARTICLES = WeightedList.builder().add(new ExplosionParticleInfo(Particles.POOF, 0.5f, 1.0f)).add(new ExplosionParticleInfo(Particles.SMOKE, 1.0f, 1.0f)).build();
    protected final List<TickingBlockEntity> blockEntityTickers = Lists.newArrayList();
    protected final CollectingNeighborUpdater neighborUpdater;
    private final List<TickingBlockEntity> pendingBlockEntityTickers = Lists.newArrayList();
    private boolean tickingBlockEntities;
    public final Thread thread;
    private final boolean isDebug;
    private int skyDarken;
    protected int randValue = RandomSource.create().nextInt();
    protected final int addend = 1013904223;
    protected float oRainLevel;
    public float rainLevel;
    protected float oThunderLevel;
    public float thunderLevel;
    public final RandomSource random = RandomSource.create();
    @Deprecated
    private final RandomSource threadSafeRandom = RandomSource.createThreadSafe();
    private final Holder<DimensionManager> dimensionTypeRegistration;
    public final WorldDataMutable levelData;
    private final boolean isClientSide;
    private final BiomeManager biomeManager;
    private final ResourceKey<World> dimension;
    private final IRegistryCustom registryAccess;
    private final DamageSources damageSources;
    private final PalettedContainerFactory palettedContainerFactory;
    private long subTickCount;

    protected World(WorldDataMutable var0, ResourceKey<World> var1, IRegistryCustom var2, Holder<DimensionManager> var3, boolean var4, boolean var5, long var6, int var8) {
        this.levelData = var0;
        this.dimensionTypeRegistration = var3;
        this.dimension = var1;
        this.isClientSide = var4;
        this.thread = Thread.currentThread();
        this.biomeManager = new BiomeManager(this, var6);
        this.isDebug = var5;
        this.neighborUpdater = new CollectingNeighborUpdater(this, var8);
        this.registryAccess = var2;
        this.palettedContainerFactory = PalettedContainerFactory.create(var2);
        this.damageSources = new DamageSources(var2);
    }

    @Override
    public boolean isClientSide() {
        return this.isClientSide;
    }

    @Override
    public @Nullable MinecraftServer getServer() {
        return null;
    }

    public boolean isInWorldBounds(BlockPosition var0) {
        return !this.isOutsideBuildHeight(var0) && World.isInWorldBoundsHorizontal(var0);
    }

    public boolean isInValidBounds(BlockPosition var0) {
        return !this.isOutsideBuildHeight(var0) && World.isInValidBoundsHorizontal(var0);
    }

    public static boolean isInSpawnableBounds(BlockPosition var0) {
        return !World.isOutsideSpawnableHeight(var0.getY()) && World.isInWorldBoundsHorizontal(var0);
    }

    private static boolean isInWorldBoundsHorizontal(BlockPosition var0) {
        return var0.getX() >= -30000000 && var0.getZ() >= -30000000 && var0.getX() < 30000000 && var0.getZ() < 30000000;
    }

    private static boolean isInValidBoundsHorizontal(BlockPosition var0) {
        int var1 = SectionPosition.blockToSectionCoord(var0.getX());
        int var2 = SectionPosition.blockToSectionCoord(var0.getZ());
        return ChunkCoordIntPair.isValid(var1, var2);
    }

    private static boolean isOutsideSpawnableHeight(int var0) {
        return var0 < -20000000 || var0 >= 20000000;
    }

    public Chunk getChunkAt(BlockPosition var0) {
        return this.getChunk(SectionPosition.blockToSectionCoord(var0.getX()), SectionPosition.blockToSectionCoord(var0.getZ()));
    }

    @Override
    public Chunk getChunk(int var0, int var1) {
        return (Chunk)this.getChunk(var0, var1, ChunkStatus.FULL);
    }

    @Override
    public @Nullable IChunkAccess getChunk(int var0, int var1, ChunkStatus var2, boolean var3) {
        IChunkAccess var4 = this.getChunkSource().getChunk(var0, var1, var2, var3);
        if (var4 == null && var3) {
            throw new IllegalStateException("Should always be able to create a chunk!");
        }
        return var4;
    }

    @Override
    public boolean setBlock(BlockPosition var0, IBlockData var1, @Block.b int var2) {
        return this.setBlock(var0, var1, var2, 512);
    }

    @Override
    public boolean setBlock(BlockPosition var0, IBlockData var1, @Block.b int var2, int var3) {
        if (!this.isInValidBounds(var0)) {
            return false;
        }
        if (!this.isClientSide() && this.isDebug()) {
            return false;
        }
        Chunk var4 = this.getChunkAt(var0);
        Block var5 = var1.getBlock();
        IBlockData var6 = var4.setBlockState(var0, var1, var2);
        if (var6 != null) {
            IBlockData var7 = this.getBlockState(var0);
            if (var7 == var1) {
                if (var6 != var7) {
                    this.setBlocksDirty(var0, var6, var7);
                }
                if ((var2 & 2) != 0 && (!this.isClientSide() || (var2 & 4) == 0) && (this.isClientSide() || var4.getFullStatus() != null && var4.getFullStatus().isOrAfter(FullChunkStatus.BLOCK_TICKING))) {
                    this.sendBlockUpdated(var0, var6, var1, var2);
                }
                if ((var2 & 1) != 0) {
                    this.updateNeighborsAt(var0, var6.getBlock());
                    if (!this.isClientSide() && var1.hasAnalogOutputSignal()) {
                        this.updateNeighbourForOutputSignal(var0, var5);
                    }
                }
                if ((var2 & 0x10) == 0 && var3 > 0) {
                    int var8 = var2 & 0xFFFFFFDE;
                    var6.updateIndirectNeighbourShapes(this, var0, var8, var3 - 1);
                    var1.updateNeighbourShapes(this, var0, var8, var3 - 1);
                    var1.updateIndirectNeighbourShapes(this, var0, var8, var3 - 1);
                }
                this.updatePOIOnBlockStateChange(var0, var6, var7);
            }
            return true;
        }
        return false;
    }

    public void updatePOIOnBlockStateChange(BlockPosition var0, IBlockData var1, IBlockData var2) {
    }

    @Override
    public boolean removeBlock(BlockPosition var0, boolean var1) {
        Fluid var2 = this.getFluidState(var0);
        return this.setBlock(var0, var2.createLegacyBlock(), 3 | (var1 ? 64 : 0));
    }

    @Override
    public boolean destroyBlock(BlockPosition var0, boolean var1, @Nullable Entity var2, int var3) {
        boolean var6;
        IBlockData var4 = this.getBlockState(var0);
        if (var4.isAir()) {
            return false;
        }
        Fluid var5 = this.getFluidState(var0);
        if (!(var4.getBlock() instanceof BlockFireAbstract)) {
            this.levelEvent(2001, var0, Block.getId(var4));
        }
        if (var1) {
            TileEntity var62 = var4.hasBlockEntity() ? this.getBlockEntity(var0) : null;
            Block.dropResources(var4, this, var0, var62, var2, ItemStack.EMPTY);
        }
        if (var6 = this.setBlock(var0, var5.createLegacyBlock(), 3, var3)) {
            this.gameEvent(GameEvent.BLOCK_DESTROY, var0, GameEvent.a.of(var2, var4));
        }
        return var6;
    }

    public void addDestroyBlockEffect(BlockPosition var0, IBlockData var1) {
    }

    public boolean setBlockAndUpdate(BlockPosition var0, IBlockData var1) {
        return this.setBlock(var0, var1, 3);
    }

    public abstract void sendBlockUpdated(BlockPosition var1, IBlockData var2, IBlockData var3, @Block.b int var4);

    public void setBlocksDirty(BlockPosition var0, IBlockData var1, IBlockData var2) {
    }

    public void updateNeighborsAt(BlockPosition var0, Block var1, @Nullable Orientation var2) {
    }

    public void updateNeighborsAtExceptFromFacing(BlockPosition var0, Block var1, EnumDirection var2, @Nullable Orientation var3) {
    }

    public void neighborChanged(BlockPosition var0, Block var1, @Nullable Orientation var2) {
    }

    public void neighborChanged(IBlockData var0, BlockPosition var1, Block var2, @Nullable Orientation var3, boolean var4) {
    }

    @Override
    public void neighborShapeChanged(EnumDirection var0, BlockPosition var1, BlockPosition var2, IBlockData var3, @Block.b int var4, int var5) {
        this.neighborUpdater.shapeUpdate(var0, var3, var1, var2, var4, var5);
    }

    @Override
    public int getHeight(HeightMap.Type var0, int var1, int var2) {
        int var3 = var1 < -30000000 || var2 < -30000000 || var1 >= 30000000 || var2 >= 30000000 ? this.getSeaLevel() + 1 : (this.hasChunk(SectionPosition.blockToSectionCoord(var1), SectionPosition.blockToSectionCoord(var2)) ? this.getChunk(SectionPosition.blockToSectionCoord(var1), SectionPosition.blockToSectionCoord(var2)).getHeight(var0, var1 & 0xF, var2 & 0xF) + 1 : this.getMinY());
        return var3;
    }

    @Override
    public LevelLightEngine getLightEngine() {
        return this.getChunkSource().getLightEngine();
    }

    @Override
    public IBlockData getBlockState(BlockPosition var0) {
        if (!this.isInValidBounds(var0)) {
            return Blocks.VOID_AIR.defaultBlockState();
        }
        Chunk var1 = this.getChunk(SectionPosition.blockToSectionCoord(var0.getX()), SectionPosition.blockToSectionCoord(var0.getZ()));
        return var1.getBlockState(var0);
    }

    @Override
    public Fluid getFluidState(BlockPosition var0) {
        if (!this.isInValidBounds(var0)) {
            return FluidTypes.EMPTY.defaultFluidState();
        }
        Chunk var1 = this.getChunkAt(var0);
        return var1.getFluidState(var0);
    }

    public boolean isBrightOutside() {
        return !this.dimensionType().hasFixedTime() && this.skyDarken < 4;
    }

    public boolean isDarkOutside() {
        return !this.dimensionType().hasFixedTime() && !this.isBrightOutside();
    }

    @Override
    public void playSound(@Nullable Entity var0, BlockPosition var1, SoundEffect var2, SoundCategory var3, float var4, float var5) {
        this.playSound(var0, (double)var1.getX() + 0.5, (double)var1.getY() + 0.5, (double)var1.getZ() + 0.5, var2, var3, var4, var5);
    }

    public abstract void playSeededSound(@Nullable Entity var1, double var2, double var4, double var6, Holder<SoundEffect> var8, SoundCategory var9, float var10, float var11, long var12);

    public void playSeededSound(@Nullable Entity var0, double var1, double var3, double var5, SoundEffect var7, SoundCategory var8, float var9, float var10, long var11) {
        this.playSeededSound(var0, var1, var3, var5, BuiltInRegistries.SOUND_EVENT.wrapAsHolder(var7), var8, var9, var10, var11);
    }

    public abstract void playSeededSound(@Nullable Entity var1, Entity var2, Holder<SoundEffect> var3, SoundCategory var4, float var5, float var6, long var7);

    public void playSound(@Nullable Entity var0, double var1, double var3, double var5, SoundEffect var7, SoundCategory var8) {
        this.playSound(var0, var1, var3, var5, var7, var8, 1.0f, 1.0f);
    }

    public void playSound(@Nullable Entity var0, double var1, double var3, double var5, SoundEffect var7, SoundCategory var8, float var9, float var10) {
        this.playSeededSound(var0, var1, var3, var5, var7, var8, var9, var10, this.threadSafeRandom.nextLong());
    }

    public void playSound(@Nullable Entity var0, double var1, double var3, double var5, Holder<SoundEffect> var7, SoundCategory var8, float var9, float var10) {
        this.playSeededSound(var0, var1, var3, var5, var7, var8, var9, var10, this.threadSafeRandom.nextLong());
    }

    public void playSound(@Nullable Entity var0, Entity var1, SoundEffect var2, SoundCategory var3, float var4, float var5) {
        this.playSeededSound(var0, var1, BuiltInRegistries.SOUND_EVENT.wrapAsHolder(var2), var3, var4, var5, this.threadSafeRandom.nextLong());
    }

    public void playLocalSound(BlockPosition var0, SoundEffect var1, SoundCategory var2, float var3, float var4, boolean var5) {
        this.playLocalSound((double)var0.getX() + 0.5, (double)var0.getY() + 0.5, (double)var0.getZ() + 0.5, var1, var2, var3, var4, var5);
    }

    public void playLocalSound(Entity var0, SoundEffect var1, SoundCategory var2, float var3, float var4) {
    }

    public void playLocalSound(double var0, double var2, double var4, SoundEffect var6, SoundCategory var7, float var8, float var9, boolean var10) {
    }

    public void playPlayerSound(SoundEffect var0, SoundCategory var1, float var2, float var3) {
    }

    @Override
    public void addParticle(ParticleParam var0, double var1, double var3, double var5, double var7, double var9, double var11) {
    }

    public void addParticle(ParticleParam var0, boolean var1, boolean var2, double var3, double var5, double var7, double var9, double var11, double var13) {
    }

    public void addAlwaysVisibleParticle(ParticleParam var0, double var1, double var3, double var5, double var7, double var9, double var11) {
    }

    public void addAlwaysVisibleParticle(ParticleParam var0, boolean var1, double var2, double var4, double var6, double var8, double var10, double var12) {
    }

    public void addBlockEntityTicker(TickingBlockEntity var0) {
        (this.tickingBlockEntities ? this.pendingBlockEntityTickers : this.blockEntityTickers).add(var0);
    }

    public void tickBlockEntities() {
        this.tickingBlockEntities = true;
        if (!this.pendingBlockEntityTickers.isEmpty()) {
            this.blockEntityTickers.addAll(this.pendingBlockEntityTickers);
            this.pendingBlockEntityTickers.clear();
        }
        Iterator<TickingBlockEntity> var0 = this.blockEntityTickers.iterator();
        boolean var1 = this.tickRateManager().runsNormally();
        while (var0.hasNext()) {
            TickingBlockEntity var2 = var0.next();
            if (var2.isRemoved()) {
                var0.remove();
                continue;
            }
            if (!var1 || !this.shouldTickBlocksAt(var2.getPos())) continue;
            var2.tick();
        }
        this.tickingBlockEntities = false;
    }

    public <T extends Entity> void guardEntityTick(Consumer<T> var0, T var1) {
        try {
            var0.accept(var1);
        }
        catch (Throwable var2) {
            CrashReport var3 = CrashReport.forThrowable(var2, "Ticking entity");
            CrashReportSystemDetails var4 = var3.addCategory("Entity being ticked");
            var1.fillCrashReportCategory(var4);
            throw new ReportedException(var3);
        }
    }

    public boolean shouldTickDeath(Entity var0) {
        return true;
    }

    public boolean shouldTickBlocksAt(long var0) {
        return true;
    }

    public boolean shouldTickBlocksAt(BlockPosition var0) {
        return this.shouldTickBlocksAt(ChunkCoordIntPair.asLong(var0));
    }

    public void explode(@Nullable Entity var0, double var1, double var3, double var5, float var7, a var8) {
        this.explode(var0, Explosion.getDefaultDamageSource(this, var0), null, var1, var3, var5, var7, false, var8, Particles.EXPLOSION, Particles.EXPLOSION_EMITTER, DEFAULT_EXPLOSION_BLOCK_PARTICLES, SoundEffects.GENERIC_EXPLODE);
    }

    public void explode(@Nullable Entity var0, double var1, double var3, double var5, float var7, boolean var8, a var9) {
        this.explode(var0, Explosion.getDefaultDamageSource(this, var0), null, var1, var3, var5, var7, var8, var9, Particles.EXPLOSION, Particles.EXPLOSION_EMITTER, DEFAULT_EXPLOSION_BLOCK_PARTICLES, SoundEffects.GENERIC_EXPLODE);
    }

    public void explode(@Nullable Entity var0, @Nullable DamageSource var1, @Nullable ExplosionDamageCalculator var2, Vec3D var3, float var4, boolean var5, a var6) {
        this.explode(var0, var1, var2, var3.x(), var3.y(), var3.z(), var4, var5, var6, Particles.EXPLOSION, Particles.EXPLOSION_EMITTER, DEFAULT_EXPLOSION_BLOCK_PARTICLES, SoundEffects.GENERIC_EXPLODE);
    }

    public void explode(@Nullable Entity var0, @Nullable DamageSource var1, @Nullable ExplosionDamageCalculator var2, double var3, double var5, double var7, float var9, boolean var10, a var11) {
        this.explode(var0, var1, var2, var3, var5, var7, var9, var10, var11, Particles.EXPLOSION, Particles.EXPLOSION_EMITTER, DEFAULT_EXPLOSION_BLOCK_PARTICLES, SoundEffects.GENERIC_EXPLODE);
    }

    public abstract void explode(@Nullable Entity var1, @Nullable DamageSource var2, @Nullable ExplosionDamageCalculator var3, double var4, double var6, double var8, float var10, boolean var11, a var12, ParticleParam var13, ParticleParam var14, WeightedList<ExplosionParticleInfo> var15, Holder<SoundEffect> var16);

    public abstract String gatherChunkSourceStats();

    @Override
    public @Nullable TileEntity getBlockEntity(BlockPosition var0) {
        if (!this.isInValidBounds(var0)) {
            return null;
        }
        if (!this.isClientSide() && Thread.currentThread() != this.thread) {
            return null;
        }
        return this.getChunkAt(var0).getBlockEntity(var0, Chunk.EnumTileEntityState.IMMEDIATE);
    }

    public void setBlockEntity(TileEntity var0) {
        BlockPosition var1 = var0.getBlockPos();
        if (!this.isInValidBounds(var1)) {
            return;
        }
        this.getChunkAt(var1).addAndRegisterBlockEntity(var0);
    }

    public void removeBlockEntity(BlockPosition var0) {
        if (!this.isInValidBounds(var0)) {
            return;
        }
        this.getChunkAt(var0).removeBlockEntity(var0);
    }

    public boolean isLoaded(BlockPosition var0) {
        if (!this.isInValidBounds(var0)) {
            return false;
        }
        return this.getChunkSource().hasChunk(SectionPosition.blockToSectionCoord(var0.getX()), SectionPosition.blockToSectionCoord(var0.getZ()));
    }

    public boolean loadedAndEntityCanStandOnFace(BlockPosition var0, Entity var1, EnumDirection var2) {
        if (!this.isInValidBounds(var0)) {
            return false;
        }
        IChunkAccess var3 = this.getChunk(SectionPosition.blockToSectionCoord(var0.getX()), SectionPosition.blockToSectionCoord(var0.getZ()), ChunkStatus.FULL, false);
        if (var3 == null) {
            return false;
        }
        return var3.getBlockState(var0).entityCanStandOnFace(this, var0, var1, var2);
    }

    public boolean loadedAndEntityCanStandOn(BlockPosition var0, Entity var1) {
        return this.loadedAndEntityCanStandOnFace(var0, var1, EnumDirection.UP);
    }

    public void updateSkyBrightness() {
        this.skyDarken = (int)(15.0f - this.environmentAttributes().getDimensionValue(EnvironmentAttributes.SKY_LIGHT_LEVEL).floatValue());
    }

    public void setSpawnSettings(boolean var0) {
        this.getChunkSource().setSpawnSettings(var0);
    }

    public abstract void setRespawnData(WorldData.a var1);

    public abstract WorldData.a getRespawnData();

    public WorldData.a getWorldBorderAdjustedRespawnData(WorldData.a var0) {
        WorldBorder var1 = this.getWorldBorder();
        if (!var1.isWithinBounds(var0.pos())) {
            BlockPosition var2 = this.getHeightmapPos(HeightMap.Type.MOTION_BLOCKING, BlockPosition.containing(var1.getCenterX(), 0.0, var1.getCenterZ()));
            return WorldData.a.of(var0.dimension(), var2, var0.yaw(), var0.pitch());
        }
        return var0;
    }

    protected void prepareWeather() {
        if (this.levelData.isRaining()) {
            this.rainLevel = 1.0f;
            if (this.levelData.isThundering()) {
                this.thunderLevel = 1.0f;
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.getChunkSource().close();
    }

    @Override
    public @Nullable IBlockAccess getChunkForCollisions(int var0, int var1) {
        return this.getChunk(var0, var1, ChunkStatus.FULL, false);
    }

    @Override
    public List<Entity> getEntities(@Nullable Entity var0, AxisAlignedBB var1, Predicate<? super Entity> var2) {
        Profiler.get().incrementCounter("getEntities");
        ArrayList var32 = Lists.newArrayList();
        this.getEntities().get(var1, var3 -> {
            if (var3 != var0 && var2.test((Entity)var3)) {
                var32.add(var3);
            }
        });
        for (EntityComplexPart var5 : this.dragonParts()) {
            if (var5 == var0 || var5.parentMob == var0 || !var2.test(var5) || !var1.intersects(var5.getBoundingBox())) continue;
            var32.add(var5);
        }
        return var32;
    }

    @Override
    public <T extends Entity> List<T> getEntities(EntityTypeTest<Entity, T> var0, AxisAlignedBB var1, Predicate<? super T> var2) {
        ArrayList var3 = Lists.newArrayList();
        this.getEntities(var0, var1, var2, var3);
        return var3;
    }

    public <T extends Entity> void getEntities(EntityTypeTest<Entity, T> var0, AxisAlignedBB var1, Predicate<? super T> var2, List<? super T> var3) {
        this.getEntities(var0, var1, var2, var3, Integer.MAX_VALUE);
    }

    public <T extends Entity> void getEntities(EntityTypeTest<Entity, T> var0, AxisAlignedBB var1, Predicate<? super T> var2, List<? super T> var3, int var42) {
        Profiler.get().incrementCounter("getEntities");
        this.getEntities().get(var0, var1, var4 -> {
            if (var2.test(var4)) {
                var3.add((Object)var4);
                if (var3.size() >= var42) {
                    return AbortableIterationConsumer.a.ABORT;
                }
            }
            if (var4 instanceof EntityEnderDragon) {
                EntityEnderDragon var5 = (EntityEnderDragon)var4;
                for (EntityComplexPart var9 : var5.getSubEntities()) {
                    Entity var10 = (Entity)var0.tryCast(var9);
                    if (var10 == null || !var2.test(var10)) continue;
                    var3.add((Object)var10);
                    if (var3.size() < var42) continue;
                    return AbortableIterationConsumer.a.ABORT;
                }
            }
            return AbortableIterationConsumer.a.CONTINUE;
        });
    }

    public <T extends Entity> boolean hasEntities(EntityTypeTest<Entity, T> var0, AxisAlignedBB var1, Predicate<? super T> var2) {
        Profiler.get().incrementCounter("hasEntities");
        MutableBoolean var32 = new MutableBoolean();
        this.getEntities().get(var0, var1, var3 -> {
            if (var2.test(var3)) {
                var32.setTrue();
                return AbortableIterationConsumer.a.ABORT;
            }
            if (var3 instanceof EntityEnderDragon) {
                EntityEnderDragon var4 = (EntityEnderDragon)var3;
                for (EntityComplexPart var8 : var4.getSubEntities()) {
                    Entity var9 = (Entity)var0.tryCast(var8);
                    if (var9 == null || !var2.test(var9)) continue;
                    var32.setTrue();
                    return AbortableIterationConsumer.a.ABORT;
                }
            }
            return AbortableIterationConsumer.a.CONTINUE;
        });
        return var32.isTrue();
    }

    public List<Entity> getPushableEntities(Entity var0, AxisAlignedBB var1) {
        return this.getEntities(var0, var1, IEntitySelector.pushableBy(var0));
    }

    public abstract @Nullable Entity getEntity(int var1);

    public @Nullable Entity getEntity(UUID var0) {
        return this.getEntities().get(var0);
    }

    public @Nullable Entity getEntityInAnyDimension(UUID var0) {
        return this.getEntity(var0);
    }

    public @Nullable EntityHuman getPlayerInAnyDimension(UUID var0) {
        return this.getPlayerByUUID(var0);
    }

    public abstract Collection<EntityComplexPart> dragonParts();

    public void blockEntityChanged(BlockPosition var0) {
        if (this.hasChunkAt(var0)) {
            this.getChunkAt(var0).markUnsaved();
        }
    }

    public void onBlockEntityAdded(TileEntity var0) {
    }

    public long getDayTime() {
        return this.levelData.getDayTime();
    }

    public boolean mayInteract(Entity var0, BlockPosition var1) {
        return true;
    }

    public void broadcastEntityEvent(Entity var0, byte var1) {
    }

    public void broadcastDamageEvent(Entity var0, DamageSource var1) {
    }

    public void blockEvent(BlockPosition var0, Block var1, int var2, int var3) {
        this.getBlockState(var0).triggerEvent(this, var0, var2, var3);
    }

    @Override
    public WorldData getLevelData() {
        return this.levelData;
    }

    public abstract TickRateManager tickRateManager();

    public float getThunderLevel(float var0) {
        return MathHelper.lerp(var0, this.oThunderLevel, this.thunderLevel) * this.getRainLevel(var0);
    }

    public void setThunderLevel(float var0) {
        float var1;
        this.oThunderLevel = var1 = MathHelper.clamp(var0, 0.0f, 1.0f);
        this.thunderLevel = var1;
    }

    public float getRainLevel(float var0) {
        return MathHelper.lerp(var0, this.oRainLevel, this.rainLevel);
    }

    public void setRainLevel(float var0) {
        float var1;
        this.oRainLevel = var1 = MathHelper.clamp(var0, 0.0f, 1.0f);
        this.rainLevel = var1;
    }

    public boolean canHaveWeather() {
        return this.dimensionType().hasSkyLight() && !this.dimensionType().hasCeiling() && this.dimension() != END;
    }

    public boolean isThundering() {
        return this.canHaveWeather() && (double)this.getThunderLevel(1.0f) > 0.9;
    }

    public boolean isRaining() {
        return this.canHaveWeather() && (double)this.getRainLevel(1.0f) > 0.2;
    }

    public boolean isRainingAt(BlockPosition var0) {
        return this.precipitationAt(var0) == BiomeBase.Precipitation.RAIN;
    }

    public BiomeBase.Precipitation precipitationAt(BlockPosition var0) {
        if (!this.isRaining()) {
            return BiomeBase.Precipitation.NONE;
        }
        if (!this.canSeeSky(var0)) {
            return BiomeBase.Precipitation.NONE;
        }
        if (this.getHeightmapPos(HeightMap.Type.MOTION_BLOCKING, var0).getY() > var0.getY()) {
            return BiomeBase.Precipitation.NONE;
        }
        BiomeBase var1 = this.getBiome(var0).value();
        return var1.getPrecipitationAt(var0, this.getSeaLevel());
    }

    public abstract @Nullable WorldMap getMapData(MapId var1);

    public void globalLevelEvent(int var0, BlockPosition var1, int var2) {
    }

    public CrashReportSystemDetails fillReportDetails(CrashReport var0) {
        CrashReportSystemDetails var1 = var0.addCategory("Affected level", 1);
        var1.setDetail("All players", () -> {
            List<? extends EntityHuman> var0 = this.players();
            return var0.size() + " total; " + var0.stream().map(EntityHuman::debugInfo).collect(Collectors.joining(", "));
        });
        var1.setDetail("Chunk stats", this.getChunkSource()::gatherStats);
        var1.setDetail("Level dimension", () -> this.dimension().identifier().toString());
        try {
            this.levelData.fillCrashReportCategory(var1, this);
        }
        catch (Throwable var2) {
            var1.setDetailError("Level Data Unobtainable", var2);
        }
        return var1;
    }

    public abstract void destroyBlockProgress(int var1, BlockPosition var2, int var3);

    public void createFireworks(double var0, double var2, double var4, double var6, double var8, double var10, List<FireworkExplosion> var12) {
    }

    public abstract Scoreboard getScoreboard();

    public void updateNeighbourForOutputSignal(BlockPosition var0, Block var1) {
        for (EnumDirection var3 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
            BlockPosition var4 = var0.relative(var3);
            if (!this.hasChunkAt(var4)) continue;
            IBlockData var5 = this.getBlockState(var4);
            if (var5.is(Blocks.COMPARATOR)) {
                this.neighborChanged(var5, var4, var1, null, false);
                continue;
            }
            if (!var5.isRedstoneConductor(this, var4) || !(var5 = this.getBlockState(var4 = var4.relative(var3))).is(Blocks.COMPARATOR)) continue;
            this.neighborChanged(var5, var4, var1, null, false);
        }
    }

    @Override
    public int getSkyDarken() {
        return this.skyDarken;
    }

    public void setSkyFlashTime(int var0) {
    }

    public void sendPacketToServer(Packet<?> var0) {
        throw new UnsupportedOperationException("Can't send packets to server unless you're on the client.");
    }

    @Override
    public DimensionManager dimensionType() {
        return this.dimensionTypeRegistration.value();
    }

    public Holder<DimensionManager> dimensionTypeRegistration() {
        return this.dimensionTypeRegistration;
    }

    public ResourceKey<World> dimension() {
        return this.dimension;
    }

    @Override
    public RandomSource getRandom() {
        return this.random;
    }

    @Override
    public boolean isStateAtPosition(BlockPosition var0, Predicate<IBlockData> var1) {
        return var1.test(this.getBlockState(var0));
    }

    @Override
    public boolean isFluidAtPosition(BlockPosition var0, Predicate<Fluid> var1) {
        return var1.test(this.getFluidState(var0));
    }

    public abstract RecipeAccess recipeAccess();

    public BlockPosition getBlockRandomPos(int var0, int var1, int var2, int var3) {
        this.randValue = this.randValue * 3 + 1013904223;
        int var4 = this.randValue >> 2;
        return new BlockPosition(var0 + (var4 & 0xF), var1 + (var4 >> 16 & var3), var2 + (var4 >> 8 & 0xF));
    }

    public boolean noSave() {
        return false;
    }

    @Override
    public BiomeManager getBiomeManager() {
        return this.biomeManager;
    }

    public final boolean isDebug() {
        return this.isDebug;
    }

    public abstract LevelEntityGetter<Entity> getEntities();

    @Override
    public long nextSubTickCount() {
        return this.subTickCount++;
    }

    @Override
    public IRegistryCustom registryAccess() {
        return this.registryAccess;
    }

    public DamageSources damageSources() {
        return this.damageSources;
    }

    @Override
    public abstract EnvironmentAttributeSystem environmentAttributes();

    public abstract PotionBrewer potionBrewing();

    public abstract FuelValues fuelValues();

    public int getClientLeafTintColor(BlockPosition var0) {
        return 0;
    }

    public PalettedContainerFactory palettedContainerFactory() {
        return this.palettedContainerFactory;
    }

    @Override
    public /* synthetic */ EnvironmentAttributeReader environmentAttributes() {
        return this.environmentAttributes();
    }

    @Override
    public /* synthetic */ IChunkAccess getChunk(int n2, int n3) {
        return this.getChunk(n2, n3);
    }

    public static final class a
    extends Enum<a>
    implements INamable {
        public static final /* enum */ a NONE = new a("none");
        public static final /* enum */ a BLOCK = new a("block");
        public static final /* enum */ a MOB = new a("mob");
        public static final /* enum */ a TNT = new a("tnt");
        public static final /* enum */ a TRIGGER = new a("trigger");
        public static final Codec<a> CODEC;
        private final String id;
        private static final /* synthetic */ a[] h;

        public static a[] values() {
            return (a[])h.clone();
        }

        public static a valueOf(String var0) {
            return Enum.valueOf(a.class, var0);
        }

        private a(String var2) {
            this.id = var2;
        }

        @Override
        public String getSerializedName() {
            return this.id;
        }

        private static /* synthetic */ a[] a() {
            return new a[]{NONE, BLOCK, MOB, TNT, TRIGGER};
        }

        static {
            h = a.a();
            CODEC = INamable.fromEnum(a::values);
        }
    }
}

