/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.jspecify.annotations.Nullable;

public class BlockCocoa
extends BlockFacingHorizontal
implements IBlockFragilePlantElement {
    public static final MapCodec<BlockCocoa> CODEC = BlockCocoa.simpleCodec(BlockCocoa::new);
    public static final int MAX_AGE = 2;
    public static final BlockStateInteger AGE = BlockProperties.AGE_2;
    private static final List<Map<EnumDirection, VoxelShape>> SHAPES = IntStream.rangeClosed(0, 2).mapToObj(var0 -> VoxelShapes.rotateHorizontal(Block.column(4 + var0 * 2, 7 - var0 * 2, 12.0).move(0.0, 0.0, (double)(var0 - 5) / 16.0).optimize())).toList();

    public MapCodec<BlockCocoa> codec() {
        return CODEC;
    }

    public BlockCocoa(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(FACING, EnumDirection.NORTH)).setValue(AGE, 0));
    }

    @Override
    protected boolean isRandomlyTicking(IBlockData var0) {
        return var0.getValue(AGE) < 2;
    }

    @Override
    protected void randomTick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        int var4;
        if (var1.random.nextInt(5) == 0 && (var4 = var0.getValue(AGE).intValue()) < 2) {
            var1.setBlock(var2, (IBlockData)var0.setValue(AGE, var4 + 1), 2);
        }
    }

    @Override
    protected boolean canSurvive(IBlockData var0, IWorldReader var1, BlockPosition var2) {
        IBlockData var3 = var1.getBlockState(var2.relative((EnumDirection)var0.getValue(FACING)));
        return var3.is(TagsBlock.JUNGLE_LOGS);
    }

    @Override
    protected VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return SHAPES.get(var0.getValue(AGE)).get(var0.getValue(FACING));
    }

    @Override
    public @Nullable IBlockData getStateForPlacement(BlockActionContext var0) {
        IBlockData var1 = this.defaultBlockState();
        World var2 = var0.getLevel();
        BlockPosition var3 = var0.getClickedPos();
        for (EnumDirection var7 : var0.getNearestLookingDirections()) {
            if (!var7.getAxis().isHorizontal() || !(var1 = (IBlockData)var1.setValue(FACING, var7)).canSurvive(var2, var3)) continue;
            return var1;
        }
        return null;
    }

    @Override
    protected IBlockData updateShape(IBlockData var0, IWorldReader var1, ScheduledTickAccess var2, BlockPosition var3, EnumDirection var4, BlockPosition var5, IBlockData var6, RandomSource var7) {
        if (var4 == var0.getValue(FACING) && !var0.canSurvive(var1, var3)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5, var6, var7);
    }

    @Override
    public boolean isValidBonemealTarget(IWorldReader var0, BlockPosition var1, IBlockData var2) {
        return var2.getValue(AGE) < 2;
    }

    @Override
    public boolean isBonemealSuccess(World var0, RandomSource var1, BlockPosition var2, IBlockData var3) {
        return true;
    }

    @Override
    public void performBonemeal(WorldServer var0, RandomSource var1, BlockPosition var2, IBlockData var3) {
        var0.setBlock(var2, (IBlockData)var3.setValue(AGE, var3.getValue(AGE) + 1), 2);
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(FACING, AGE);
    }

    @Override
    protected boolean isPathfindable(IBlockData var0, PathMode var1) {
        return false;
    }
}

