/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.util.UtilColor;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.CommandBlockListenerAbstract;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockDirectional;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.GameMasterBlock;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityCommand;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class BlockCommand
extends BlockTileEntity
implements GameMasterBlock {
    public static final MapCodec<BlockCommand> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)Codec.BOOL.fieldOf("automatic").forGetter(var0 -> var0.automatic), BlockCommand.propertiesCodec()).apply((Applicative)var02, BlockCommand::new));
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final BlockStateEnum<EnumDirection> FACING = BlockDirectional.FACING;
    public static final BlockStateBoolean CONDITIONAL = BlockProperties.CONDITIONAL;
    private final boolean automatic;

    public MapCodec<BlockCommand> codec() {
        return CODEC;
    }

    public BlockCommand(boolean var0, BlockBase.Info var1) {
        super(var1);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(FACING, EnumDirection.NORTH)).setValue(CONDITIONAL, false));
        this.automatic = var0;
    }

    @Override
    public TileEntity newBlockEntity(BlockPosition var0, IBlockData var1) {
        TileEntityCommand var2 = new TileEntityCommand(var0, var1);
        var2.setAutomatic(this.automatic);
        return var2;
    }

    @Override
    protected void neighborChanged(IBlockData var0, World var1, BlockPosition var2, Block var3, @Nullable Orientation var4, boolean var5) {
        if (var1.isClientSide()) {
            return;
        }
        TileEntity var6 = var1.getBlockEntity(var2);
        if (var6 instanceof TileEntityCommand) {
            TileEntityCommand var7 = (TileEntityCommand)var6;
            this.setPoweredAndUpdate(var1, var2, var7, var1.hasNeighborSignal(var2));
        }
    }

    private void setPoweredAndUpdate(World var0, BlockPosition var1, TileEntityCommand var2, boolean var3) {
        boolean var4 = var2.isPowered();
        if (var3 == var4) {
            return;
        }
        var2.setPowered(var3);
        if (var3) {
            if (var2.isAutomatic() || var2.getMode() == TileEntityCommand.Type.SEQUENCE) {
                return;
            }
            var2.markConditionMet();
            var0.scheduleTick(var1, this, 1);
        }
    }

    @Override
    protected void tick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        TileEntity var4 = var1.getBlockEntity(var2);
        if (var4 instanceof TileEntityCommand) {
            TileEntityCommand var5 = (TileEntityCommand)var4;
            CommandBlockListenerAbstract var6 = var5.getCommandBlock();
            boolean var7 = !UtilColor.isNullOrEmpty(var6.getCommand());
            TileEntityCommand.Type var8 = var5.getMode();
            boolean var9 = var5.wasConditionMet();
            if (var8 == TileEntityCommand.Type.AUTO) {
                var5.markConditionMet();
                if (var9) {
                    this.execute(var0, var1, var2, var6, var7);
                } else if (var5.isConditional()) {
                    var6.setSuccessCount(0);
                }
                if (var5.isPowered() || var5.isAutomatic()) {
                    var1.scheduleTick(var2, this, 1);
                }
            } else if (var8 == TileEntityCommand.Type.REDSTONE) {
                if (var9) {
                    this.execute(var0, var1, var2, var6, var7);
                } else if (var5.isConditional()) {
                    var6.setSuccessCount(0);
                }
            }
            var1.updateNeighbourForOutputSignal(var2, this);
        }
    }

    private void execute(IBlockData var0, WorldServer var1, BlockPosition var2, CommandBlockListenerAbstract var3, boolean var4) {
        if (var4) {
            var3.performCommand(var1);
        } else {
            var3.setSuccessCount(0);
        }
        BlockCommand.executeChain(var1, var2, var0.getValue(FACING));
    }

    @Override
    protected EnumInteractionResult useWithoutItem(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3, MovingObjectPositionBlock var4) {
        TileEntity var5 = var1.getBlockEntity(var2);
        if (var5 instanceof TileEntityCommand && var3.canUseGameMasterBlocks()) {
            var3.openCommandBlock((TileEntityCommand)var5);
            return EnumInteractionResult.SUCCESS;
        }
        return EnumInteractionResult.PASS;
    }

    @Override
    protected boolean hasAnalogOutputSignal(IBlockData var0) {
        return true;
    }

    @Override
    protected int getAnalogOutputSignal(IBlockData var0, World var1, BlockPosition var2, EnumDirection var3) {
        TileEntity var4 = var1.getBlockEntity(var2);
        if (var4 instanceof TileEntityCommand) {
            return ((TileEntityCommand)var4).getCommandBlock().getSuccessCount();
        }
        return 0;
    }

    @Override
    public void setPlacedBy(World var0, BlockPosition var1, IBlockData var2, @Nullable EntityLiving var3, ItemStack var4) {
        TileEntity var5 = var0.getBlockEntity(var1);
        if (!(var5 instanceof TileEntityCommand)) {
            return;
        }
        TileEntityCommand var6 = (TileEntityCommand)var5;
        CommandBlockListenerAbstract var7 = var6.getCommandBlock();
        if (var0 instanceof WorldServer) {
            WorldServer var8 = (WorldServer)var0;
            if (!var4.has(DataComponents.BLOCK_ENTITY_DATA)) {
                var7.setTrackOutput(var8.getGameRules().get(GameRules.SEND_COMMAND_FEEDBACK));
                var6.setAutomatic(this.automatic);
            }
            boolean var9 = var0.hasNeighborSignal(var1);
            this.setPoweredAndUpdate(var0, var1, var6, var9);
        }
    }

    @Override
    protected IBlockData rotate(IBlockData var0, EnumBlockRotation var1) {
        return (IBlockData)var0.setValue(FACING, var1.rotate(var0.getValue(FACING)));
    }

    @Override
    protected IBlockData mirror(IBlockData var0, EnumBlockMirror var1) {
        return var0.rotate(var1.getRotation(var0.getValue(FACING)));
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(FACING, CONDITIONAL);
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        return (IBlockData)this.defaultBlockState().setValue(FACING, var0.getNearestLookingDirection().getOpposite());
    }

    private static void executeChain(WorldServer var0, BlockPosition var1, EnumDirection var2) {
        BlockPosition.MutableBlockPosition var3 = var1.mutable();
        GameRules var4 = var0.getGameRules();
        int var5 = var4.get(GameRules.MAX_COMMAND_SEQUENCE_LENGTH);
        while (var5-- > 0) {
            TileEntityCommand var9;
            TileEntity var8;
            var3.move(var2);
            IBlockData var6 = var0.getBlockState(var3);
            Block var7 = var6.getBlock();
            if (!var6.is(Blocks.CHAIN_COMMAND_BLOCK) || !((var8 = var0.getBlockEntity(var3)) instanceof TileEntityCommand) || (var9 = (TileEntityCommand)var8).getMode() != TileEntityCommand.Type.SEQUENCE) break;
            if (var9.isPowered() || var9.isAutomatic()) {
                CommandBlockListenerAbstract var10 = var9.getCommandBlock();
                if (var9.markConditionMet()) {
                    if (!var10.performCommand(var0)) break;
                    var0.updateNeighbourForOutputSignal(var3, var7);
                } else if (var9.isConditional()) {
                    var10.setSuccessCount(0);
                }
            }
            var2 = var6.getValue(FACING);
        }
        if (var5 <= 0) {
            int var6 = Math.max(var4.get(GameRules.MAX_COMMAND_SEQUENCE_LENGTH), 0);
            LOGGER.warn("Command Block chain tried to execute more than {} steps!", (Object)var6);
        }
    }
}

