/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockCoral;
import net.minecraft.world.level.block.BlockCoralBase;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class BlockCoralPlant
extends BlockCoralBase {
    public static final MapCodec<BlockCoralPlant> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)BlockCoral.DEAD_CORAL_FIELD.forGetter(var0 -> var0.deadBlock), BlockCoralPlant.propertiesCodec()).apply((Applicative)var02, BlockCoralPlant::new));
    private final Block deadBlock;
    private static final VoxelShape SHAPE = Block.column(12.0, 0.0, 15.0);

    public MapCodec<BlockCoralPlant> codec() {
        return CODEC;
    }

    protected BlockCoralPlant(Block var0, BlockBase.Info var1) {
        super(var1);
        this.deadBlock = var0;
    }

    @Override
    protected void onPlace(IBlockData var0, World var1, BlockPosition var2, IBlockData var3, boolean var4) {
        this.tryScheduleDieTick(var0, var1, var1, var1.random, var2);
    }

    @Override
    protected void tick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        if (!BlockCoralPlant.scanForWater(var0, var1, var2)) {
            var1.setBlock(var2, (IBlockData)this.deadBlock.defaultBlockState().setValue(WATERLOGGED, false), 2);
        }
    }

    @Override
    protected IBlockData updateShape(IBlockData var0, IWorldReader var1, ScheduledTickAccess var2, BlockPosition var3, EnumDirection var4, BlockPosition var5, IBlockData var6, RandomSource var7) {
        if (var4 == EnumDirection.DOWN && !var0.canSurvive(var1, var3)) {
            return Blocks.AIR.defaultBlockState();
        }
        this.tryScheduleDieTick(var0, var1, var2, var7, var3);
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            var2.scheduleTick(var3, FluidTypes.WATER, FluidTypes.WATER.getTickDelay(var1));
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5, var6, var7);
    }

    @Override
    protected VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return SHAPE;
    }
}

