/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockRedstoneWire;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockSupport;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.redstone.ExperimentalRedstoneUtils;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.ticks.TickListPriority;
import org.jspecify.annotations.Nullable;

public abstract class BlockDiodeAbstract
extends BlockFacingHorizontal {
    public static final BlockStateBoolean POWERED = BlockProperties.POWERED;
    private static final VoxelShape SHAPE = Block.column(16.0, 0.0, 2.0);

    protected BlockDiodeAbstract(BlockBase.Info var0) {
        super(var0);
    }

    protected abstract MapCodec<? extends BlockDiodeAbstract> codec();

    @Override
    protected VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return SHAPE;
    }

    @Override
    protected boolean canSurvive(IBlockData var0, IWorldReader var1, BlockPosition var2) {
        BlockPosition var3 = var2.below();
        return this.canSurviveOn(var1, var3, var1.getBlockState(var3));
    }

    protected boolean canSurviveOn(IWorldReader var0, BlockPosition var1, IBlockData var2) {
        return var2.isFaceSturdy(var0, var1, EnumDirection.UP, EnumBlockSupport.RIGID);
    }

    @Override
    protected void tick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        if (this.isLocked(var1, var2, var0)) {
            return;
        }
        boolean var4 = var0.getValue(POWERED);
        boolean var5 = this.shouldTurnOn(var1, var2, var0);
        if (var4 && !var5) {
            var1.setBlock(var2, (IBlockData)var0.setValue(POWERED, false), 2);
        } else if (!var4) {
            var1.setBlock(var2, (IBlockData)var0.setValue(POWERED, true), 2);
            if (!var5) {
                var1.scheduleTick(var2, this, this.getDelay(var0), TickListPriority.VERY_HIGH);
            }
        }
    }

    @Override
    protected int getDirectSignal(IBlockData var0, IBlockAccess var1, BlockPosition var2, EnumDirection var3) {
        return var0.getSignal(var1, var2, var3);
    }

    @Override
    protected int getSignal(IBlockData var0, IBlockAccess var1, BlockPosition var2, EnumDirection var3) {
        if (!var0.getValue(POWERED).booleanValue()) {
            return 0;
        }
        if (var0.getValue(FACING) == var3) {
            return this.getOutputSignal(var1, var2, var0);
        }
        return 0;
    }

    @Override
    protected void neighborChanged(IBlockData var0, World var1, BlockPosition var2, Block var3, @Nullable Orientation var4, boolean var5) {
        if (var0.canSurvive(var1, var2)) {
            this.checkTickOnNeighbor(var1, var2, var0);
            return;
        }
        TileEntity var6 = var0.hasBlockEntity() ? var1.getBlockEntity(var2) : null;
        BlockDiodeAbstract.dropResources(var0, var1, var2, var6);
        var1.removeBlock(var2, false);
        for (EnumDirection var10 : EnumDirection.values()) {
            var1.updateNeighborsAt(var2.relative(var10), this);
        }
    }

    protected void checkTickOnNeighbor(World var0, BlockPosition var1, IBlockData var2) {
        boolean var4;
        if (this.isLocked(var0, var1, var2)) {
            return;
        }
        boolean var3 = var2.getValue(POWERED);
        if (var3 != (var4 = this.shouldTurnOn(var0, var1, var2)) && !var0.getBlockTicks().willTickThisTick(var1, this)) {
            TickListPriority var5 = TickListPriority.HIGH;
            if (this.shouldPrioritize(var0, var1, var2)) {
                var5 = TickListPriority.EXTREMELY_HIGH;
            } else if (var3) {
                var5 = TickListPriority.VERY_HIGH;
            }
            var0.scheduleTick(var1, this, this.getDelay(var2), var5);
        }
    }

    public boolean isLocked(IWorldReader var0, BlockPosition var1, IBlockData var2) {
        return false;
    }

    protected boolean shouldTurnOn(World var0, BlockPosition var1, IBlockData var2) {
        return this.getInputSignal(var0, var1, var2) > 0;
    }

    protected int getInputSignal(World var0, BlockPosition var1, IBlockData var2) {
        EnumDirection var3 = (EnumDirection)var2.getValue(FACING);
        BlockPosition var4 = var1.relative(var3);
        int var5 = var0.getSignal(var4, var3);
        if (var5 >= 15) {
            return var5;
        }
        IBlockData var6 = var0.getBlockState(var4);
        return Math.max(var5, var6.is(Blocks.REDSTONE_WIRE) ? var6.getValue(BlockRedstoneWire.POWER) : 0);
    }

    protected int getAlternateSignal(SignalGetter var0, BlockPosition var1, IBlockData var2) {
        EnumDirection var3 = (EnumDirection)var2.getValue(FACING);
        EnumDirection var4 = var3.getClockWise();
        EnumDirection var5 = var3.getCounterClockWise();
        boolean var6 = this.sideInputDiodesOnly();
        return Math.max(var0.getControlInputSignal(var1.relative(var4), var4, var6), var0.getControlInputSignal(var1.relative(var5), var5, var6));
    }

    @Override
    protected boolean isSignalSource(IBlockData var0) {
        return true;
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        return (IBlockData)this.defaultBlockState().setValue(FACING, var0.getHorizontalDirection().getOpposite());
    }

    @Override
    public void setPlacedBy(World var0, BlockPosition var1, IBlockData var2, @Nullable EntityLiving var3, ItemStack var4) {
        if (this.shouldTurnOn(var0, var1, var2)) {
            var0.scheduleTick(var1, this, 1);
        }
    }

    @Override
    protected void onPlace(IBlockData var0, World var1, BlockPosition var2, IBlockData var3, boolean var4) {
        this.updateNeighborsInFront(var1, var2, var0);
    }

    @Override
    protected void affectNeighborsAfterRemoval(IBlockData var0, WorldServer var1, BlockPosition var2, boolean var3) {
        if (!var3) {
            this.updateNeighborsInFront(var1, var2, var0);
        }
    }

    protected void updateNeighborsInFront(World var0, BlockPosition var1, IBlockData var2) {
        EnumDirection var3 = (EnumDirection)var2.getValue(FACING);
        BlockPosition var4 = var1.relative(var3.getOpposite());
        Orientation var5 = ExperimentalRedstoneUtils.initialOrientation(var0, var3.getOpposite(), EnumDirection.UP);
        var0.neighborChanged(var4, this, var5);
        var0.updateNeighborsAtExceptFromFacing(var4, this, var3, var5);
    }

    protected boolean sideInputDiodesOnly() {
        return false;
    }

    protected int getOutputSignal(IBlockAccess var0, BlockPosition var1, IBlockData var2) {
        return 15;
    }

    public static boolean isDiode(IBlockData var0) {
        return var0.getBlock() instanceof BlockDiodeAbstract;
    }

    public boolean shouldPrioritize(IBlockAccess var0, BlockPosition var1, IBlockData var2) {
        EnumDirection var3 = ((EnumDirection)var2.getValue(FACING)).getOpposite();
        IBlockData var4 = var0.getBlockState(var1.relative(var3));
        return BlockDiodeAbstract.isDiode(var4) && var4.getValue(FACING) != var3;
    }

    protected abstract int getDelay(IBlockData var1);
}

