/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.dispenser.DispenseBehaviorItem;
import net.minecraft.core.dispenser.IDispenseBehavior;
import net.minecraft.core.dispenser.SourceBlock;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.IInventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockDispenser;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityDispenser;
import net.minecraft.world.level.block.entity.TileEntityDropper;
import net.minecraft.world.level.block.entity.TileEntityHopper;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import org.slf4j.Logger;

public class BlockDropper
extends BlockDispenser {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final MapCodec<BlockDropper> CODEC = BlockDropper.simpleCodec(BlockDropper::new);
    private static final IDispenseBehavior DISPENSE_BEHAVIOUR = new DispenseBehaviorItem();

    public MapCodec<BlockDropper> codec() {
        return CODEC;
    }

    public BlockDropper(BlockBase.Info var0) {
        super(var0);
    }

    @Override
    protected IDispenseBehavior getDispenseMethod(World var0, ItemStack var1) {
        return DISPENSE_BEHAVIOUR;
    }

    @Override
    public TileEntity newBlockEntity(BlockPosition var0, IBlockData var1) {
        return new TileEntityDropper(var0, var1);
    }

    @Override
    public void dispenseFrom(WorldServer var0, IBlockData var1, BlockPosition var2) {
        ItemStack var9;
        TileEntityDispenser var3 = var0.getBlockEntity(var2, TileEntityTypes.DROPPER).orElse(null);
        if (var3 == null) {
            LOGGER.warn("Ignoring dispensing attempt for Dropper without matching block entity at {}", (Object)var2);
            return;
        }
        SourceBlock var4 = new SourceBlock(var0, var2, var1, var3);
        int var5 = var3.getRandomSlot(var0.random);
        if (var5 < 0) {
            var0.levelEvent(1001, var2, 0);
            return;
        }
        ItemStack var6 = var3.getItem(var5);
        if (var6.isEmpty()) {
            return;
        }
        EnumDirection var7 = (EnumDirection)var0.getBlockState(var2).getValue(FACING);
        IInventory var8 = TileEntityHopper.getContainerAt(var0, var2.relative(var7));
        if (var8 == null) {
            var9 = DISPENSE_BEHAVIOUR.dispense(var4, var6);
        } else {
            var9 = TileEntityHopper.addItem(var3, var8, var6.copyWithCount(1), var7.getOpposite());
            if (var9.isEmpty()) {
                var9 = var6.copy();
                var9.shrink(1);
            } else {
                var9 = var6.copy();
            }
        }
        var3.setItem(var5, var9);
    }
}

